/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.applications.configuration.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.openmetadata.schema.type.IndexMappingLanguage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "entities", "recreateIndex", "batchSize", "payLoadSize", "producerThreads", "consumerThreads", "maxConcurrentRequests", "maxRetries", "initialBackoff", "maxBackoff", "queueSize", "searchIndexMappingLanguage"})
public class SearchIndexingAppConfig {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Application type.")
    private SearchIndexingType type = SearchIndexingType.fromValue("SearchIndexing");
    @JsonProperty(value="entities")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of Entities to Reindex")
    @Valid
    private Set<String> entities = new LinkedHashSet<String>(Arrays.asList("all"));
    @JsonProperty(value="recreateIndex")
    @JsonPropertyDescription(value="This schema publisher run modes.")
    private Boolean recreateIndex = false;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 100).")
    private Integer batchSize = 100;
    @JsonProperty(value="payLoadSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 100).")
    private Long payLoadSize = 0x6400000L;
    @JsonProperty(value="producerThreads")
    @JsonPropertyDescription(value="Number of threads to use for reindexing")
    private Integer producerThreads = 10;
    @JsonProperty(value="consumerThreads")
    @JsonPropertyDescription(value="Number of threads to use for reindexing")
    private Integer consumerThreads = 10;
    @JsonProperty(value="maxConcurrentRequests")
    @JsonPropertyDescription(value="Maximum number of concurrent requests to the search index")
    private Integer maxConcurrentRequests = 100;
    @JsonProperty(value="maxRetries")
    @JsonPropertyDescription(value="Maximum number of retries for a failed request")
    private Integer maxRetries = 3;
    @JsonProperty(value="initialBackoff")
    @JsonPropertyDescription(value="Initial backoff time in milliseconds")
    private Integer initialBackoff = 1000;
    @JsonProperty(value="maxBackoff")
    @JsonPropertyDescription(value="Maximum backoff time in milliseconds")
    private Integer maxBackoff = 10000;
    @JsonProperty(value="queueSize")
    @JsonPropertyDescription(value="Queue Size to user internally for reindexing.")
    private Integer queueSize = 100;
    @JsonProperty(value="searchIndexMappingLanguage")
    @JsonPropertyDescription(value="This schema defines the language options available for search index mappings.")
    private IndexMappingLanguage searchIndexMappingLanguage = IndexMappingLanguage.fromValue("EN");

    @JsonProperty(value="type")
    public SearchIndexingType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SearchIndexingType type) {
        this.type = type;
    }

    public SearchIndexingAppConfig withType(SearchIndexingType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="entities")
    public Set<String> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="entities")
    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }

    public SearchIndexingAppConfig withEntities(Set<String> entities) {
        this.entities = entities;
        return this;
    }

    @JsonProperty(value="recreateIndex")
    public Boolean getRecreateIndex() {
        return this.recreateIndex;
    }

    @JsonProperty(value="recreateIndex")
    public void setRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
    }

    public SearchIndexingAppConfig withRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public SearchIndexingAppConfig withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="payLoadSize")
    public Long getPayLoadSize() {
        return this.payLoadSize;
    }

    @JsonProperty(value="payLoadSize")
    public void setPayLoadSize(Long payLoadSize) {
        this.payLoadSize = payLoadSize;
    }

    public SearchIndexingAppConfig withPayLoadSize(Long payLoadSize) {
        this.payLoadSize = payLoadSize;
        return this;
    }

    @JsonProperty(value="producerThreads")
    public Integer getProducerThreads() {
        return this.producerThreads;
    }

    @JsonProperty(value="producerThreads")
    public void setProducerThreads(Integer producerThreads) {
        this.producerThreads = producerThreads;
    }

    public SearchIndexingAppConfig withProducerThreads(Integer producerThreads) {
        this.producerThreads = producerThreads;
        return this;
    }

    @JsonProperty(value="consumerThreads")
    public Integer getConsumerThreads() {
        return this.consumerThreads;
    }

    @JsonProperty(value="consumerThreads")
    public void setConsumerThreads(Integer consumerThreads) {
        this.consumerThreads = consumerThreads;
    }

    public SearchIndexingAppConfig withConsumerThreads(Integer consumerThreads) {
        this.consumerThreads = consumerThreads;
        return this;
    }

    @JsonProperty(value="maxConcurrentRequests")
    public Integer getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @JsonProperty(value="maxConcurrentRequests")
    public void setMaxConcurrentRequests(Integer maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    public SearchIndexingAppConfig withMaxConcurrentRequests(Integer maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return this;
    }

    @JsonProperty(value="maxRetries")
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @JsonProperty(value="maxRetries")
    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public SearchIndexingAppConfig withMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @JsonProperty(value="initialBackoff")
    public Integer getInitialBackoff() {
        return this.initialBackoff;
    }

    @JsonProperty(value="initialBackoff")
    public void setInitialBackoff(Integer initialBackoff) {
        this.initialBackoff = initialBackoff;
    }

    public SearchIndexingAppConfig withInitialBackoff(Integer initialBackoff) {
        this.initialBackoff = initialBackoff;
        return this;
    }

    @JsonProperty(value="maxBackoff")
    public Integer getMaxBackoff() {
        return this.maxBackoff;
    }

    @JsonProperty(value="maxBackoff")
    public void setMaxBackoff(Integer maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    public SearchIndexingAppConfig withMaxBackoff(Integer maxBackoff) {
        this.maxBackoff = maxBackoff;
        return this;
    }

    @JsonProperty(value="queueSize")
    public Integer getQueueSize() {
        return this.queueSize;
    }

    @JsonProperty(value="queueSize")
    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public SearchIndexingAppConfig withQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public IndexMappingLanguage getSearchIndexMappingLanguage() {
        return this.searchIndexMappingLanguage;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public void setSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
    }

    public SearchIndexingAppConfig withSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SearchIndexingAppConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("entities");
        sb.append('=');
        sb.append(this.entities == null ? "<null>" : this.entities);
        sb.append(',');
        sb.append("recreateIndex");
        sb.append('=');
        sb.append(this.recreateIndex == null ? "<null>" : this.recreateIndex);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("payLoadSize");
        sb.append('=');
        sb.append(this.payLoadSize == null ? "<null>" : this.payLoadSize);
        sb.append(',');
        sb.append("producerThreads");
        sb.append('=');
        sb.append(this.producerThreads == null ? "<null>" : this.producerThreads);
        sb.append(',');
        sb.append("consumerThreads");
        sb.append('=');
        sb.append(this.consumerThreads == null ? "<null>" : this.consumerThreads);
        sb.append(',');
        sb.append("maxConcurrentRequests");
        sb.append('=');
        sb.append(this.maxConcurrentRequests == null ? "<null>" : this.maxConcurrentRequests);
        sb.append(',');
        sb.append("maxRetries");
        sb.append('=');
        sb.append(this.maxRetries == null ? "<null>" : this.maxRetries);
        sb.append(',');
        sb.append("initialBackoff");
        sb.append('=');
        sb.append(this.initialBackoff == null ? "<null>" : this.initialBackoff);
        sb.append(',');
        sb.append("maxBackoff");
        sb.append('=');
        sb.append(this.maxBackoff == null ? "<null>" : this.maxBackoff);
        sb.append(',');
        sb.append("queueSize");
        sb.append('=');
        sb.append(this.queueSize == null ? "<null>" : this.queueSize);
        sb.append(',');
        sb.append("searchIndexMappingLanguage");
        sb.append('=');
        sb.append(this.searchIndexMappingLanguage == null ? "<null>" : this.searchIndexMappingLanguage);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.maxBackoff == null ? 0 : this.maxBackoff.hashCode());
        result = result * 31 + (this.queueSize == null ? 0 : this.queueSize.hashCode());
        result = result * 31 + (this.searchIndexMappingLanguage == null ? 0 : this.searchIndexMappingLanguage.hashCode());
        result = result * 31 + (this.recreateIndex == null ? 0 : this.recreateIndex.hashCode());
        result = result * 31 + (this.maxConcurrentRequests == null ? 0 : this.maxConcurrentRequests.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.initialBackoff == null ? 0 : this.initialBackoff.hashCode());
        result = result * 31 + (this.maxRetries == null ? 0 : this.maxRetries.hashCode());
        result = result * 31 + (this.entities == null ? 0 : this.entities.hashCode());
        result = result * 31 + (this.producerThreads == null ? 0 : this.producerThreads.hashCode());
        result = result * 31 + (this.payLoadSize == null ? 0 : this.payLoadSize.hashCode());
        result = result * 31 + (this.consumerThreads == null ? 0 : this.consumerThreads.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SearchIndexingAppConfig)) {
            return false;
        }
        SearchIndexingAppConfig rhs = (SearchIndexingAppConfig)other;
        return (this.maxBackoff == rhs.maxBackoff || this.maxBackoff != null && this.maxBackoff.equals(rhs.maxBackoff)) && (this.queueSize == rhs.queueSize || this.queueSize != null && this.queueSize.equals(rhs.queueSize)) && (this.searchIndexMappingLanguage == rhs.searchIndexMappingLanguage || this.searchIndexMappingLanguage != null && this.searchIndexMappingLanguage.equals((Object)rhs.searchIndexMappingLanguage)) && (this.recreateIndex == rhs.recreateIndex || this.recreateIndex != null && this.recreateIndex.equals(rhs.recreateIndex)) && (this.maxConcurrentRequests == rhs.maxConcurrentRequests || this.maxConcurrentRequests != null && this.maxConcurrentRequests.equals(rhs.maxConcurrentRequests)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.initialBackoff == rhs.initialBackoff || this.initialBackoff != null && this.initialBackoff.equals(rhs.initialBackoff)) && (this.maxRetries == rhs.maxRetries || this.maxRetries != null && this.maxRetries.equals(rhs.maxRetries)) && (this.entities == rhs.entities || this.entities != null && this.entities.equals(rhs.entities)) && (this.producerThreads == rhs.producerThreads || this.producerThreads != null && this.producerThreads.equals(rhs.producerThreads)) && (this.payLoadSize == rhs.payLoadSize || this.payLoadSize != null && this.payLoadSize.equals(rhs.payLoadSize)) && (this.consumerThreads == rhs.consumerThreads || this.consumerThreads != null && this.consumerThreads.equals(rhs.consumerThreads)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize));
    }

    public static enum SearchIndexingType {
        SEARCH_INDEXING("SearchIndexing");

        private final String value;
        private static final Map<String, SearchIndexingType> CONSTANTS;

        private SearchIndexingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SearchIndexingType fromValue(String value) {
            SearchIndexingType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SearchIndexingType>();
            for (SearchIndexingType c : SearchIndexingType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

