/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.automations;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.automations.WorkflowStatus;
import org.openmetadata.schema.entity.automations.WorkflowType;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "workflowType", "request", "status", "response", "owners", "domain"})
public class CreateWorkflow
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this workflow definition.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="workflowType")
    @JsonPropertyDescription(value="This enum defines the type for which this workflow applies to.")
    @NotNull
    private WorkflowType workflowType;
    @JsonProperty(value="request")
    @JsonPropertyDescription(value="Request body for a specific workflow type")
    @NotNull
    private Object request;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Enum defining possible Workflow status")
    private WorkflowStatus status;
    @JsonProperty(value="response")
    @JsonPropertyDescription(value="Response to the request.")
    private Object response;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Fully qualified name of the domain the Table belongs to.")
    private String domain;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateWorkflow withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateWorkflow withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateWorkflow withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="workflowType")
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    @JsonProperty(value="workflowType")
    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public CreateWorkflow withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    @JsonProperty(value="request")
    public Object getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    public void setRequest(Object request) {
        this.request = request;
    }

    public CreateWorkflow withRequest(Object request) {
        this.request = request;
        return this;
    }

    @JsonProperty(value="status")
    public WorkflowStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(WorkflowStatus status) {
        this.status = status;
    }

    public CreateWorkflow withStatus(WorkflowStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="response")
    public Object getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    public void setResponse(Object response) {
        this.response = response;
    }

    public CreateWorkflow withResponse(Object response) {
        this.response = response;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateWorkflow withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateWorkflow withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateWorkflow.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("workflowType");
        sb.append('=');
        sb.append(this.workflowType == null ? "<null>" : this.workflowType);
        sb.append(',');
        sb.append("request");
        sb.append('=');
        sb.append(this.request == null ? "<null>" : this.request);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("response");
        sb.append('=');
        sb.append(this.response == null ? "<null>" : this.response);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.request == null ? 0 : this.request.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.response == null ? 0 : this.response.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.workflowType == null ? 0 : this.workflowType.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateWorkflow)) {
            return false;
        }
        CreateWorkflow rhs = (CreateWorkflow)other;
        return (this.request == rhs.request || this.request != null && this.request.equals(rhs.request)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.response == rhs.response || this.response != null && this.response.equals(rhs.response)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.workflowType == rhs.workflowType || this.workflowType != null && this.workflowType.equals((Object)rhs.workflowType)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

