/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.automations;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"connection", "serviceType", "connectionType", "serviceName", "secretsManagerProvider"})
public class TestServiceConnectionRequest {
    @JsonProperty(value="connection")
    @JsonPropertyDescription(value="Connection object.")
    private Object connection;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="This schema defines the service types entities which requires a connection.")
    private ServiceType serviceType;
    @JsonProperty(value="connectionType")
    @JsonPropertyDescription(value="Type of the connection to test such as Snowflake, MySQL, Looker, etc.")
    private String connectionType;
    @JsonProperty(value="serviceName")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) String serviceName;
    @JsonProperty(value="secretsManagerProvider")
    @JsonPropertyDescription(value="OpenMetadata Secrets Manager Provider. Make sure to configure the same secrets manager providers as the ones configured on the OpenMetadata server.")
    private SecretsManagerProvider secretsManagerProvider = SecretsManagerProvider.fromValue("db");

    @JsonProperty(value="connection")
    public Object getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    public void setConnection(Object connection) {
        this.connection = connection;
    }

    public TestServiceConnectionRequest withConnection(Object connection) {
        this.connection = connection;
        return this;
    }

    @JsonProperty(value="serviceType")
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public TestServiceConnectionRequest withServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @JsonProperty(value="connectionType")
    public String getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public TestServiceConnectionRequest withConnectionType(String connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public TestServiceConnectionRequest withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @JsonProperty(value="secretsManagerProvider")
    public SecretsManagerProvider getSecretsManagerProvider() {
        return this.secretsManagerProvider;
    }

    @JsonProperty(value="secretsManagerProvider")
    public void setSecretsManagerProvider(SecretsManagerProvider secretsManagerProvider) {
        this.secretsManagerProvider = secretsManagerProvider;
    }

    public TestServiceConnectionRequest withSecretsManagerProvider(SecretsManagerProvider secretsManagerProvider) {
        this.secretsManagerProvider = secretsManagerProvider;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestServiceConnectionRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("connection");
        sb.append('=');
        sb.append(this.connection == null ? "<null>" : this.connection);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("connectionType");
        sb.append('=');
        sb.append(this.connectionType == null ? "<null>" : this.connectionType);
        sb.append(',');
        sb.append("serviceName");
        sb.append('=');
        sb.append(this.serviceName == null ? "<null>" : this.serviceName);
        sb.append(',');
        sb.append("secretsManagerProvider");
        sb.append('=');
        sb.append(this.secretsManagerProvider == null ? "<null>" : this.secretsManagerProvider);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.connection == null ? 0 : this.connection.hashCode());
        result = result * 31 + (this.secretsManagerProvider == null ? 0 : this.secretsManagerProvider.hashCode());
        result = result * 31 + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = result * 31 + (this.connectionType == null ? 0 : this.connectionType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestServiceConnectionRequest)) {
            return false;
        }
        TestServiceConnectionRequest rhs = (TestServiceConnectionRequest)other;
        return (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals((Object)rhs.serviceType)) && (this.connection == rhs.connection || this.connection != null && this.connection.equals(rhs.connection)) && (this.secretsManagerProvider == rhs.secretsManagerProvider || this.secretsManagerProvider != null && this.secretsManagerProvider.equals((Object)rhs.secretsManagerProvider)) && (this.serviceName == rhs.serviceName || this.serviceName != null && this.serviceName.equals(rhs.serviceName)) && (this.connectionType == rhs.connectionType || this.connectionType != null && this.connectionType.equals(rhs.connectionType));
    }
}

