/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.automations;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.automations.WorkflowStatus;
import org.openmetadata.schema.entity.automations.WorkflowType;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "displayName", "description", "fullyQualifiedName", "workflowType", "status", "request", "response", "openMetadataServerConnection", "owners", "version", "updatedAt", "updatedBy", "href", "changeDescription", "deleted", "domain", "dataProducts"})
public class Workflow
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this workflow definition.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="workflowType")
    @JsonPropertyDescription(value="This enum defines the type for which this workflow applies to.")
    @NotNull
    private WorkflowType workflowType;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Enum defining possible Workflow status")
    private WorkflowStatus status;
    @JsonProperty(value="request")
    @JsonPropertyDescription(value="Request body for a specific workflow type")
    @NotNull
    private Object request;
    @JsonProperty(value="response")
    @JsonPropertyDescription(value="Response to the request.")
    private Object response;
    @JsonProperty(value="openMetadataServerConnection")
    @JsonPropertyDescription(value="OpenMetadata Connection Config")
    @Valid
    private OpenMetadataConnection openMetadataServerConnection;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference domain;
    @JsonProperty(value="dataProducts")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> dataProducts = null;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Workflow withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Workflow withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Workflow withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Workflow withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Workflow withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="workflowType")
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    @JsonProperty(value="workflowType")
    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public Workflow withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    @JsonProperty(value="status")
    public WorkflowStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(WorkflowStatus status) {
        this.status = status;
    }

    public Workflow withStatus(WorkflowStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="request")
    public Object getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    public void setRequest(Object request) {
        this.request = request;
    }

    public Workflow withRequest(Object request) {
        this.request = request;
        return this;
    }

    @JsonProperty(value="response")
    public Object getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    public void setResponse(Object response) {
        this.response = response;
    }

    public Workflow withResponse(Object response) {
        this.response = response;
        return this;
    }

    @JsonProperty(value="openMetadataServerConnection")
    public OpenMetadataConnection getOpenMetadataServerConnection() {
        return this.openMetadataServerConnection;
    }

    @JsonProperty(value="openMetadataServerConnection")
    public void setOpenMetadataServerConnection(OpenMetadataConnection openMetadataServerConnection) {
        this.openMetadataServerConnection = openMetadataServerConnection;
    }

    public Workflow withOpenMetadataServerConnection(OpenMetadataConnection openMetadataServerConnection) {
        this.openMetadataServerConnection = openMetadataServerConnection;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public Workflow withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public Workflow withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Workflow withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Workflow withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Workflow withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Workflow withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Workflow withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public Workflow withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public void setDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public Workflow withDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Workflow.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("workflowType");
        sb.append('=');
        sb.append(this.workflowType == null ? "<null>" : this.workflowType);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("request");
        sb.append('=');
        sb.append(this.request == null ? "<null>" : this.request);
        sb.append(',');
        sb.append("response");
        sb.append('=');
        sb.append(this.response == null ? "<null>" : this.response);
        sb.append(',');
        sb.append("openMetadataServerConnection");
        sb.append('=');
        sb.append(this.openMetadataServerConnection == null ? "<null>" : this.openMetadataServerConnection);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("dataProducts");
        sb.append('=');
        sb.append(this.dataProducts == null ? "<null>" : this.dataProducts);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.request == null ? 0 : this.request.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.dataProducts == null ? 0 : this.dataProducts.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.openMetadataServerConnection == null ? 0 : this.openMetadataServerConnection.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.response == null ? 0 : this.response.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.workflowType == null ? 0 : this.workflowType.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Workflow)) {
            return false;
        }
        Workflow rhs = (Workflow)other;
        return (this.request == rhs.request || this.request != null && this.request.equals(rhs.request)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.dataProducts == rhs.dataProducts || this.dataProducts != null && this.dataProducts.equals(rhs.dataProducts)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.openMetadataServerConnection == rhs.openMetadataServerConnection || this.openMetadataServerConnection != null && this.openMetadataServerConnection.equals(rhs.openMetadataServerConnection)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.response == rhs.response || this.response != null && this.response.equals(rhs.response)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.workflowType == rhs.workflowType || this.workflowType != null && this.workflowType.equals((Object)rhs.workflowType)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }
}

