/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.automations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum WorkflowStatus {
    PENDING("Pending"),
    SUCCESSFUL("Successful"),
    FAILED("Failed"),
    RUNNING("Running");

    private final String value;
    private static final Map<String, WorkflowStatus> CONSTANTS;

    private WorkflowStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static WorkflowStatus fromValue(String value) {
        WorkflowStatus constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, WorkflowStatus>();
        for (WorkflowStatus c : WorkflowStatus.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

