/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.data.TermReference;
import org.openmetadata.schema.entity.type.Style;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Votes;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "displayName", "description", "style", "fullyQualifiedName", "synonyms", "glossary", "parent", "children", "relatedTerms", "references", "version", "updatedAt", "updatedBy", "href", "reviewers", "owners", "usageCount", "tags", "changeDescription", "status", "deleted", "provider", "disabled", "mutuallyExclusive", "extension", "domain", "dataProducts", "votes", "childrenCount"})
public class GlossaryTerm
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this glossary.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="style")
    @JsonPropertyDescription(value="UI Style is used to associate a color code and/or icon to entity to customize the look of that entity in UI.")
    @Valid
    private Style style;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="synonyms")
    @JsonPropertyDescription(value="Alternate names that are synonyms or near-synonyms for the glossary term.")
    @Valid
    private List<String> synonyms = new ArrayList<String>();
    @JsonProperty(value="glossary")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference glossary;
    @JsonProperty(value="parent")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference parent;
    @JsonProperty(value="children")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> children = null;
    @JsonProperty(value="relatedTerms")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> relatedTerms = null;
    @JsonProperty(value="references")
    @JsonPropertyDescription(value="Link to a reference from an external glossary.")
    @Valid
    private List<TermReference> references = new ArrayList<TermReference>();
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="reviewers")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> reviewers = null;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="usageCount")
    @JsonPropertyDescription(value="Count of how many times this and it's children glossary terms are used as labels.")
    private Integer usageCount;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags associated with this glossary term. These tags captures relationship of a glossary term with a tag automatically. As an example a glossary term 'User.PhoneNumber' might have an associated tag 'PII.Sensitive'. When 'User.Address' is used to label a column in a table, 'PII.Sensitive' label is also applied automatically due to Associated tag relationship.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="status")
    private Status status;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");
    @JsonProperty(value="disabled")
    @JsonPropertyDescription(value="System glossary can't be deleted. Use this flag to disable them.")
    private Boolean disabled;
    @JsonProperty(value="mutuallyExclusive")
    @JsonPropertyDescription(value="Glossary terms that are children of this term are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity from this group. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.")
    private Boolean mutuallyExclusive = false;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference domain;
    @JsonProperty(value="dataProducts")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> dataProducts = null;
    @JsonProperty(value="votes")
    @JsonPropertyDescription(value="This schema defines the Votes for a Data Asset.")
    @Valid
    private Votes votes;
    @JsonProperty(value="childrenCount")
    @JsonPropertyDescription(value="Count of immediate children glossary terms.")
    private Integer childrenCount;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public GlossaryTerm withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GlossaryTerm withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public GlossaryTerm withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public GlossaryTerm withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="style")
    public Style getStyle() {
        return this.style;
    }

    @Override
    @JsonProperty(value="style")
    public void setStyle(Style style) {
        this.style = style;
    }

    public GlossaryTerm withStyle(Style style) {
        this.style = style;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public GlossaryTerm withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="synonyms")
    public List<String> getSynonyms() {
        return this.synonyms;
    }

    @JsonProperty(value="synonyms")
    public void setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
    }

    public GlossaryTerm withSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    @JsonProperty(value="glossary")
    public EntityReference getGlossary() {
        return this.glossary;
    }

    @JsonProperty(value="glossary")
    public void setGlossary(EntityReference glossary) {
        this.glossary = glossary;
    }

    public GlossaryTerm withGlossary(EntityReference glossary) {
        this.glossary = glossary;
        return this;
    }

    @JsonProperty(value="parent")
    public EntityReference getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    public void setParent(EntityReference parent) {
        this.parent = parent;
    }

    public GlossaryTerm withParent(EntityReference parent) {
        this.parent = parent;
        return this;
    }

    @Override
    @JsonProperty(value="children")
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @Override
    @JsonProperty(value="children")
    public void setChildren(List<EntityReference> children) {
        this.children = children;
    }

    public GlossaryTerm withChildren(List<EntityReference> children) {
        this.children = children;
        return this;
    }

    @JsonProperty(value="relatedTerms")
    public List<EntityReference> getRelatedTerms() {
        return this.relatedTerms;
    }

    @JsonProperty(value="relatedTerms")
    public void setRelatedTerms(List<EntityReference> relatedTerms) {
        this.relatedTerms = relatedTerms;
    }

    public GlossaryTerm withRelatedTerms(List<EntityReference> relatedTerms) {
        this.relatedTerms = relatedTerms;
        return this;
    }

    @JsonProperty(value="references")
    public List<TermReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<TermReference> references) {
        this.references = references;
    }

    public GlossaryTerm withReferences(List<TermReference> references) {
        this.references = references;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public GlossaryTerm withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public GlossaryTerm withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public GlossaryTerm withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public GlossaryTerm withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="reviewers")
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @Override
    @JsonProperty(value="reviewers")
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public GlossaryTerm withReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public GlossaryTerm withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="usageCount")
    public Integer getUsageCount() {
        return this.usageCount;
    }

    @JsonProperty(value="usageCount")
    public void setUsageCount(Integer usageCount) {
        this.usageCount = usageCount;
    }

    public GlossaryTerm withUsageCount(Integer usageCount) {
        this.usageCount = usageCount;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public GlossaryTerm withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public GlossaryTerm withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    public GlossaryTerm withStatus(Status status) {
        this.status = status;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public GlossaryTerm withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public GlossaryTerm withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public GlossaryTerm withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @JsonProperty(value="mutuallyExclusive")
    public Boolean getMutuallyExclusive() {
        return this.mutuallyExclusive;
    }

    @JsonProperty(value="mutuallyExclusive")
    public void setMutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
    }

    public GlossaryTerm withMutuallyExclusive(Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @Override
    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public GlossaryTerm withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public GlossaryTerm withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public void setDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public GlossaryTerm withDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    @Override
    @JsonProperty(value="votes")
    public Votes getVotes() {
        return this.votes;
    }

    @Override
    @JsonProperty(value="votes")
    public void setVotes(Votes votes) {
        this.votes = votes;
    }

    public GlossaryTerm withVotes(Votes votes) {
        this.votes = votes;
        return this;
    }

    @JsonProperty(value="childrenCount")
    public Integer getChildrenCount() {
        return this.childrenCount;
    }

    @JsonProperty(value="childrenCount")
    public void setChildrenCount(Integer childrenCount) {
        this.childrenCount = childrenCount;
    }

    public GlossaryTerm withChildrenCount(Integer childrenCount) {
        this.childrenCount = childrenCount;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GlossaryTerm.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(this.style == null ? "<null>" : this.style);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("synonyms");
        sb.append('=');
        sb.append(this.synonyms == null ? "<null>" : this.synonyms);
        sb.append(',');
        sb.append("glossary");
        sb.append('=');
        sb.append(this.glossary == null ? "<null>" : this.glossary);
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(this.parent == null ? "<null>" : this.parent);
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(this.children == null ? "<null>" : this.children);
        sb.append(',');
        sb.append("relatedTerms");
        sb.append('=');
        sb.append(this.relatedTerms == null ? "<null>" : this.relatedTerms);
        sb.append(',');
        sb.append("references");
        sb.append('=');
        sb.append(this.references == null ? "<null>" : this.references);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("reviewers");
        sb.append('=');
        sb.append(this.reviewers == null ? "<null>" : this.reviewers);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("usageCount");
        sb.append('=');
        sb.append(this.usageCount == null ? "<null>" : this.usageCount);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("disabled");
        sb.append('=');
        sb.append(this.disabled == null ? "<null>" : this.disabled);
        sb.append(',');
        sb.append("mutuallyExclusive");
        sb.append('=');
        sb.append(this.mutuallyExclusive == null ? "<null>" : this.mutuallyExclusive);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("dataProducts");
        sb.append('=');
        sb.append(this.dataProducts == null ? "<null>" : this.dataProducts);
        sb.append(',');
        sb.append("votes");
        sb.append('=');
        sb.append(this.votes == null ? "<null>" : this.votes);
        sb.append(',');
        sb.append("childrenCount");
        sb.append('=');
        sb.append(this.childrenCount == null ? "<null>" : this.childrenCount);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.parent == null ? 0 : this.parent.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.references == null ? 0 : this.references.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.relatedTerms == null ? 0 : this.relatedTerms.hashCode());
        result = result * 31 + (this.children == null ? 0 : this.children.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.disabled == null ? 0 : this.disabled.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.childrenCount == null ? 0 : this.childrenCount.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.synonyms == null ? 0 : this.synonyms.hashCode());
        result = result * 31 + (this.dataProducts == null ? 0 : this.dataProducts.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.reviewers == null ? 0 : this.reviewers.hashCode());
        result = result * 31 + (this.usageCount == null ? 0 : this.usageCount.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.glossary == null ? 0 : this.glossary.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.mutuallyExclusive == null ? 0 : this.mutuallyExclusive.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.style == null ? 0 : this.style.hashCode());
        result = result * 31 + (this.votes == null ? 0 : this.votes.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GlossaryTerm)) {
            return false;
        }
        GlossaryTerm rhs = (GlossaryTerm)other;
        return (this.parent == rhs.parent || this.parent != null && this.parent.equals(rhs.parent)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.references == rhs.references || this.references != null && this.references.equals(rhs.references)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.relatedTerms == rhs.relatedTerms || this.relatedTerms != null && this.relatedTerms.equals(rhs.relatedTerms)) && (this.children == rhs.children || this.children != null && this.children.equals(rhs.children)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.disabled == rhs.disabled || this.disabled != null && this.disabled.equals(rhs.disabled)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.childrenCount == rhs.childrenCount || this.childrenCount != null && this.childrenCount.equals(rhs.childrenCount)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.synonyms == rhs.synonyms || this.synonyms != null && this.synonyms.equals(rhs.synonyms)) && (this.dataProducts == rhs.dataProducts || this.dataProducts != null && this.dataProducts.equals(rhs.dataProducts)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.reviewers == rhs.reviewers || this.reviewers != null && this.reviewers.equals(rhs.reviewers)) && (this.usageCount == rhs.usageCount || this.usageCount != null && this.usageCount.equals(rhs.usageCount)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.glossary == rhs.glossary || this.glossary != null && this.glossary.equals(rhs.glossary)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.mutuallyExclusive == rhs.mutuallyExclusive || this.mutuallyExclusive != null && this.mutuallyExclusive.equals(rhs.mutuallyExclusive)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.style == rhs.style || this.style != null && this.style.equals(rhs.style)) && (this.votes == rhs.votes || this.votes != null && this.votes.equals(rhs.votes)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum Status {
        DRAFT("Draft"),
        APPROVED("Approved"),
        DEPRECATED("Deprecated"),
        REJECTED("Rejected");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

