/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.ColumnsEntityInterface;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.data.CreateTable;
import org.openmetadata.schema.api.services.CreateDatabaseService;
import org.openmetadata.schema.tests.CustomMetric;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.DataModel;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TableData;
import org.openmetadata.schema.type.TableJoins;
import org.openmetadata.schema.type.TablePartition;
import org.openmetadata.schema.type.TableProfile;
import org.openmetadata.schema.type.TableProfilerConfig;
import org.openmetadata.schema.type.TableType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.schema.type.Votes;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "displayName", "fullyQualifiedName", "description", "version", "updatedAt", "updatedBy", "href", "tableType", "columns", "tableConstraints", "tablePartition", "owners", "databaseSchema", "database", "service", "serviceType", "location", "locationPath", "schemaDefinition", "tags", "usageSummary", "followers", "joins", "sampleData", "tableProfilerConfig", "customMetrics", "profile", "testSuite", "dataModel", "changeDescription", "deleted", "retentionPeriod", "extension", "sourceUrl", "domain", "dataProducts", "fileFormat", "votes", "lifeCycle", "sourceHash"})
public class Table
implements ColumnsEntityInterface,
EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this table. It could be title or label from the source services.")
    private String displayName;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="tableType")
    @JsonPropertyDescription(value="This schema defines the type used for describing different types of tables.")
    private TableType tableType;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="Columns in this table.")
    @Valid
    @NotNull
    private List<Column> columns = null;
    @JsonProperty(value="tableConstraints")
    @JsonPropertyDescription(value="Table constraints.")
    @Valid
    private List<TableConstraint> tableConstraints = null;
    @JsonProperty(value="tablePartition")
    @JsonPropertyDescription(value="This schema defines the partition column of a table and format the partition is created.")
    @Valid
    private TablePartition tablePartition;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference databaseSchema;
    @JsonProperty(value="database")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference database;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference service;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...")
    private CreateDatabaseService.DatabaseServiceType serviceType;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference location;
    @JsonProperty(value="locationPath")
    @JsonPropertyDescription(value="Full storage path in case of external and managed tables.")
    private String locationPath = null;
    @JsonProperty(value="schemaDefinition")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    private String schemaDefinition;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this table.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="usageSummary")
    @JsonPropertyDescription(value="This schema defines the type for usage details. Daily, weekly, and monthly aggregation of usage is computed along with the percentile rank based on the usage for a given day.")
    @Valid
    private UsageDetails usageSummary;
    @JsonProperty(value="followers")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> followers = null;
    @JsonProperty(value="joins")
    @JsonPropertyDescription(value="This schema defines the type to capture information about how this table is joined with other tables and columns.")
    @Valid
    private TableJoins joins;
    @JsonProperty(value="sampleData")
    @JsonPropertyDescription(value="This schema defines the type to capture rows of sample data for a table.")
    @Valid
    private TableData sampleData;
    @JsonProperty(value="tableProfilerConfig")
    @JsonPropertyDescription(value="This schema defines the type for Table profile config.")
    @Valid
    private TableProfilerConfig tableProfilerConfig;
    @JsonProperty(value="customMetrics")
    @JsonPropertyDescription(value="List of Custom Metrics registered for a table.")
    @Valid
    private List<CustomMetric> customMetrics = null;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="This schema defines the type to capture the table's data profile.")
    @Valid
    private TableProfile profile;
    @JsonProperty(value="testSuite")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference testSuite;
    @JsonProperty(value="dataModel")
    @JsonPropertyDescription(value="This captures information about how the table is modeled. Currently only DBT and DDL model is supported.")
    @Valid
    private DataModel dataModel;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="retentionPeriod")
    @JsonPropertyDescription(value="Duration in ISO 8601 format in UTC. Example - 'P23DT23H'.")
    private String retentionPeriod;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;
    @JsonProperty(value="sourceUrl")
    @JsonPropertyDescription(value="Source Url of the respective entity.")
    private String sourceUrl;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference domain;
    @JsonProperty(value="dataProducts")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> dataProducts = null;
    @JsonProperty(value="fileFormat")
    @JsonPropertyDescription(value="File format in case of file/datalake tables.")
    private CreateTable.FileFormat fileFormat;
    @JsonProperty(value="votes")
    @JsonPropertyDescription(value="This schema defines the Votes for a Data Asset.")
    @Valid
    private Votes votes;
    @JsonProperty(value="lifeCycle")
    @JsonPropertyDescription(value="This schema defines Life Cycle Properties.")
    @Valid
    private LifeCycle lifeCycle;
    @JsonProperty(value="sourceHash")
    @JsonPropertyDescription(value="Source hash of the entity")
    @Size(min=1, max=32)
    private @Size(min=1, max=32) String sourceHash;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Table withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Table withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Table withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Table withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Table withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public Table withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Table withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Table withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Table withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="tableType")
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty(value="tableType")
    public void setTableType(TableType tableType) {
        this.tableType = tableType;
    }

    public Table withTableType(TableType tableType) {
        this.tableType = tableType;
        return this;
    }

    @Override
    @JsonProperty(value="columns")
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public Table withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="tableConstraints")
    public List<TableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    @JsonProperty(value="tableConstraints")
    public void setTableConstraints(List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
    }

    public Table withTableConstraints(List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
        return this;
    }

    @JsonProperty(value="tablePartition")
    public TablePartition getTablePartition() {
        return this.tablePartition;
    }

    @JsonProperty(value="tablePartition")
    public void setTablePartition(TablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    public Table withTablePartition(TablePartition tablePartition) {
        this.tablePartition = tablePartition;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public Table withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public EntityReference getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(EntityReference databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public Table withDatabaseSchema(EntityReference databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="database")
    public EntityReference getDatabase() {
        return this.database;
    }

    @JsonProperty(value="database")
    public void setDatabase(EntityReference database) {
        this.database = database;
    }

    public Table withDatabase(EntityReference database) {
        this.database = database;
        return this;
    }

    @JsonProperty(value="service")
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(EntityReference service) {
        this.service = service;
    }

    public Table withService(EntityReference service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="serviceType")
    public CreateDatabaseService.DatabaseServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(CreateDatabaseService.DatabaseServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public Table withServiceType(CreateDatabaseService.DatabaseServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @JsonProperty(value="location")
    public EntityReference getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(EntityReference location) {
        this.location = location;
    }

    public Table withLocation(EntityReference location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="locationPath")
    public String getLocationPath() {
        return this.locationPath;
    }

    @JsonProperty(value="locationPath")
    public void setLocationPath(String locationPath) {
        this.locationPath = locationPath;
    }

    public Table withLocationPath(String locationPath) {
        this.locationPath = locationPath;
        return this;
    }

    @JsonProperty(value="schemaDefinition")
    public String getSchemaDefinition() {
        return this.schemaDefinition;
    }

    @JsonProperty(value="schemaDefinition")
    public void setSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    public Table withSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public Table withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="usageSummary")
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    public void setUsageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public Table withUsageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Override
    @JsonProperty(value="followers")
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @Override
    @JsonProperty(value="followers")
    public void setFollowers(List<EntityReference> followers) {
        this.followers = followers;
    }

    public Table withFollowers(List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    @JsonProperty(value="joins")
    public TableJoins getJoins() {
        return this.joins;
    }

    @JsonProperty(value="joins")
    public void setJoins(TableJoins joins) {
        this.joins = joins;
    }

    public Table withJoins(TableJoins joins) {
        this.joins = joins;
        return this;
    }

    @JsonProperty(value="sampleData")
    public TableData getSampleData() {
        return this.sampleData;
    }

    @JsonProperty(value="sampleData")
    public void setSampleData(TableData sampleData) {
        this.sampleData = sampleData;
    }

    public Table withSampleData(TableData sampleData) {
        this.sampleData = sampleData;
        return this;
    }

    @JsonProperty(value="tableProfilerConfig")
    public TableProfilerConfig getTableProfilerConfig() {
        return this.tableProfilerConfig;
    }

    @JsonProperty(value="tableProfilerConfig")
    public void setTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
    }

    public Table withTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
        return this;
    }

    @JsonProperty(value="customMetrics")
    public List<CustomMetric> getCustomMetrics() {
        return this.customMetrics;
    }

    @JsonProperty(value="customMetrics")
    public void setCustomMetrics(List<CustomMetric> customMetrics) {
        this.customMetrics = customMetrics;
    }

    public Table withCustomMetrics(List<CustomMetric> customMetrics) {
        this.customMetrics = customMetrics;
        return this;
    }

    @JsonProperty(value="profile")
    public TableProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    public void setProfile(TableProfile profile) {
        this.profile = profile;
    }

    public Table withProfile(TableProfile profile) {
        this.profile = profile;
        return this;
    }

    @JsonProperty(value="testSuite")
    public EntityReference getTestSuite() {
        return this.testSuite;
    }

    @JsonProperty(value="testSuite")
    public void setTestSuite(EntityReference testSuite) {
        this.testSuite = testSuite;
    }

    public Table withTestSuite(EntityReference testSuite) {
        this.testSuite = testSuite;
        return this;
    }

    @JsonProperty(value="dataModel")
    public DataModel getDataModel() {
        return this.dataModel;
    }

    @JsonProperty(value="dataModel")
    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public Table withDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Table withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Table withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty(value="retentionPeriod")
    public String getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @JsonProperty(value="retentionPeriod")
    public void setRetentionPeriod(String retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public Table withRetentionPeriod(String retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @Override
    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public Table withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    @JsonProperty(value="sourceUrl")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Table withSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public Table withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @Override
    @JsonProperty(value="dataProducts")
    public void setDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public Table withDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    @JsonProperty(value="fileFormat")
    public CreateTable.FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty(value="fileFormat")
    public void setFileFormat(CreateTable.FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Table withFileFormat(CreateTable.FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Override
    @JsonProperty(value="votes")
    public Votes getVotes() {
        return this.votes;
    }

    @Override
    @JsonProperty(value="votes")
    public void setVotes(Votes votes) {
        this.votes = votes;
    }

    public Table withVotes(Votes votes) {
        this.votes = votes;
        return this;
    }

    @Override
    @JsonProperty(value="lifeCycle")
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @Override
    @JsonProperty(value="lifeCycle")
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public Table withLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @JsonProperty(value="sourceHash")
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public Table withSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Table.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("tableType");
        sb.append('=');
        sb.append(this.tableType == null ? "<null>" : this.tableType);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("tableConstraints");
        sb.append('=');
        sb.append(this.tableConstraints == null ? "<null>" : this.tableConstraints);
        sb.append(',');
        sb.append("tablePartition");
        sb.append('=');
        sb.append(this.tablePartition == null ? "<null>" : this.tablePartition);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("database");
        sb.append('=');
        sb.append(this.database == null ? "<null>" : this.database);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("locationPath");
        sb.append('=');
        sb.append(this.locationPath == null ? "<null>" : this.locationPath);
        sb.append(',');
        sb.append("schemaDefinition");
        sb.append('=');
        sb.append(this.schemaDefinition == null ? "<null>" : this.schemaDefinition);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("usageSummary");
        sb.append('=');
        sb.append(this.usageSummary == null ? "<null>" : this.usageSummary);
        sb.append(',');
        sb.append("followers");
        sb.append('=');
        sb.append(this.followers == null ? "<null>" : this.followers);
        sb.append(',');
        sb.append("joins");
        sb.append('=');
        sb.append(this.joins == null ? "<null>" : this.joins);
        sb.append(',');
        sb.append("sampleData");
        sb.append('=');
        sb.append(this.sampleData == null ? "<null>" : this.sampleData);
        sb.append(',');
        sb.append("tableProfilerConfig");
        sb.append('=');
        sb.append(this.tableProfilerConfig == null ? "<null>" : this.tableProfilerConfig);
        sb.append(',');
        sb.append("customMetrics");
        sb.append('=');
        sb.append(this.customMetrics == null ? "<null>" : this.customMetrics);
        sb.append(',');
        sb.append("profile");
        sb.append('=');
        sb.append(this.profile == null ? "<null>" : this.profile);
        sb.append(',');
        sb.append("testSuite");
        sb.append('=');
        sb.append(this.testSuite == null ? "<null>" : this.testSuite);
        sb.append(',');
        sb.append("dataModel");
        sb.append('=');
        sb.append(this.dataModel == null ? "<null>" : this.dataModel);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("retentionPeriod");
        sb.append('=');
        sb.append(this.retentionPeriod == null ? "<null>" : this.retentionPeriod);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("dataProducts");
        sb.append('=');
        sb.append(this.dataProducts == null ? "<null>" : this.dataProducts);
        sb.append(',');
        sb.append("fileFormat");
        sb.append('=');
        sb.append(this.fileFormat == null ? "<null>" : this.fileFormat);
        sb.append(',');
        sb.append("votes");
        sb.append('=');
        sb.append(this.votes == null ? "<null>" : this.votes);
        sb.append(',');
        sb.append("lifeCycle");
        sb.append('=');
        sb.append(this.lifeCycle == null ? "<null>" : this.lifeCycle);
        sb.append(',');
        sb.append("sourceHash");
        sb.append('=');
        sb.append(this.sourceHash == null ? "<null>" : this.sourceHash);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.joins == null ? 0 : this.joins.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.schemaDefinition == null ? 0 : this.schemaDefinition.hashCode());
        result = result * 31 + (this.testSuite == null ? 0 : this.testSuite.hashCode());
        result = result * 31 + (this.dataModel == null ? 0 : this.dataModel.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.customMetrics == null ? 0 : this.customMetrics.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.tableType == null ? 0 : this.tableType.hashCode());
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + (this.tableProfilerConfig == null ? 0 : this.tableProfilerConfig.hashCode());
        result = result * 31 + (this.usageSummary == null ? 0 : this.usageSummary.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.retentionPeriod == null ? 0 : this.retentionPeriod.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.profile == null ? 0 : this.profile.hashCode());
        result = result * 31 + (this.dataProducts == null ? 0 : this.dataProducts.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.tableConstraints == null ? 0 : this.tableConstraints.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.sourceHash == null ? 0 : this.sourceHash.hashCode());
        result = result * 31 + (this.followers == null ? 0 : this.followers.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.sampleData == null ? 0 : this.sampleData.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.tablePartition == null ? 0 : this.tablePartition.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.votes == null ? 0 : this.votes.hashCode());
        result = result * 31 + (this.lifeCycle == null ? 0 : this.lifeCycle.hashCode());
        result = result * 31 + (this.locationPath == null ? 0 : this.locationPath.hashCode());
        result = result * 31 + (this.fileFormat == null ? 0 : this.fileFormat.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Table)) {
            return false;
        }
        Table rhs = (Table)other;
        return (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.joins == rhs.joins || this.joins != null && this.joins.equals(rhs.joins)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.schemaDefinition == rhs.schemaDefinition || this.schemaDefinition != null && this.schemaDefinition.equals(rhs.schemaDefinition)) && (this.testSuite == rhs.testSuite || this.testSuite != null && this.testSuite.equals(rhs.testSuite)) && (this.dataModel == rhs.dataModel || this.dataModel != null && this.dataModel.equals(rhs.dataModel)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.customMetrics == rhs.customMetrics || this.customMetrics != null && this.customMetrics.equals(rhs.customMetrics)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.tableType == rhs.tableType || this.tableType != null && this.tableType.equals((Object)rhs.tableType)) && (this.database == rhs.database || this.database != null && this.database.equals(rhs.database)) && (this.tableProfilerConfig == rhs.tableProfilerConfig || this.tableProfilerConfig != null && this.tableProfilerConfig.equals(rhs.tableProfilerConfig)) && (this.usageSummary == rhs.usageSummary || this.usageSummary != null && this.usageSummary.equals(rhs.usageSummary)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.retentionPeriod == rhs.retentionPeriod || this.retentionPeriod != null && this.retentionPeriod.equals(rhs.retentionPeriod)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.profile == rhs.profile || this.profile != null && this.profile.equals(rhs.profile)) && (this.dataProducts == rhs.dataProducts || this.dataProducts != null && this.dataProducts.equals(rhs.dataProducts)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.tableConstraints == rhs.tableConstraints || this.tableConstraints != null && this.tableConstraints.equals(rhs.tableConstraints)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.sourceHash == rhs.sourceHash || this.sourceHash != null && this.sourceHash.equals(rhs.sourceHash)) && (this.followers == rhs.followers || this.followers != null && this.followers.equals(rhs.followers)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.sampleData == rhs.sampleData || this.sampleData != null && this.sampleData.equals(rhs.sampleData)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.tablePartition == rhs.tablePartition || this.tablePartition != null && this.tablePartition.equals(rhs.tablePartition)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.votes == rhs.votes || this.votes != null && this.votes.equals(rhs.votes)) && (this.lifeCycle == rhs.lifeCycle || this.lifeCycle != null && this.lifeCycle.equals(rhs.lifeCycle)) && (this.locationPath == rhs.locationPath || this.locationPath != null && this.locationPath.equals(rhs.locationPath)) && (this.fileFormat == rhs.fileFormat || this.fileFormat != null && this.fileFormat.equals((Object)rhs.fileFormat));
    }
}

