/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.entity.events.Argument;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "effect", "prefixCondition", "arguments"})
public class ArgumentsInput {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the filter")
    private String name;
    @JsonProperty(value="effect")
    private Effect effect = Effect.fromValue("include");
    @JsonProperty(value="prefixCondition")
    @JsonPropertyDescription(value="Prefix Condition to be applied to the Condition.")
    private PrefixCondition prefixCondition = PrefixCondition.fromValue("AND");
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="Arguments List")
    @Valid
    private List<Argument> arguments = new ArrayList<Argument>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public ArgumentsInput withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="effect")
    public Effect getEffect() {
        return this.effect;
    }

    @JsonProperty(value="effect")
    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public ArgumentsInput withEffect(Effect effect) {
        this.effect = effect;
        return this;
    }

    @JsonProperty(value="prefixCondition")
    public PrefixCondition getPrefixCondition() {
        return this.prefixCondition;
    }

    @JsonProperty(value="prefixCondition")
    public void setPrefixCondition(PrefixCondition prefixCondition) {
        this.prefixCondition = prefixCondition;
    }

    public ArgumentsInput withPrefixCondition(PrefixCondition prefixCondition) {
        this.prefixCondition = prefixCondition;
        return this;
    }

    @JsonProperty(value="arguments")
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public ArgumentsInput withArguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ArgumentsInput.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("effect");
        sb.append('=');
        sb.append(this.effect == null ? "<null>" : this.effect);
        sb.append(',');
        sb.append("prefixCondition");
        sb.append('=');
        sb.append(this.prefixCondition == null ? "<null>" : this.prefixCondition);
        sb.append(',');
        sb.append("arguments");
        sb.append('=');
        sb.append(this.arguments == null ? "<null>" : this.arguments);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.prefixCondition == null ? 0 : this.prefixCondition.hashCode());
        result = result * 31 + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = result * 31 + (this.effect == null ? 0 : this.effect.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArgumentsInput)) {
            return false;
        }
        ArgumentsInput rhs = (ArgumentsInput)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.prefixCondition == rhs.prefixCondition || this.prefixCondition != null && this.prefixCondition.equals((Object)rhs.prefixCondition)) && (this.arguments == rhs.arguments || this.arguments != null && this.arguments.equals(rhs.arguments)) && (this.effect == rhs.effect || this.effect != null && this.effect.equals((Object)rhs.effect));
    }

    public static enum Effect {
        INCLUDE("include"),
        EXCLUDE("exclude");

        private final String value;
        private static final Map<String, Effect> CONSTANTS;

        private Effect(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Effect fromValue(String value) {
            Effect constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Effect>();
            for (Effect c : Effect.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PrefixCondition {
        AND("AND"),
        OR("OR");

        private final String value;
        private static final Map<String, PrefixCondition> CONSTANTS;

        private PrefixCondition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PrefixCondition fromValue(String value) {
            PrefixCondition constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PrefixCondition>();
            for (PrefixCondition c : PrefixCondition.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

