/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openmetadata.schema.entity.events.ArgumentsInput;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "fullyQualifiedName", "description", "effect", "condition", "arguments", "inputType", "prefixCondition"})
public class EventFilterRule {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of this Event Filter.")
    private String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name of the Filter.")
    private String displayName;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="effect")
    @NotNull
    private ArgumentsInput.Effect effect = ArgumentsInput.Effect.fromValue("include");
    @JsonProperty(value="condition")
    @JsonPropertyDescription(value="Expression in SpEL.")
    @NotNull
    private String condition;
    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="Arguments to the Condition.")
    @Valid
    private List<String> arguments = new ArrayList<String>();
    @JsonProperty(value="inputType")
    private InputType inputType;
    @JsonProperty(value="prefixCondition")
    @JsonPropertyDescription(value="Prefix Condition to be applied to the Condition.")
    private ArgumentsInput.PrefixCondition prefixCondition = ArgumentsInput.PrefixCondition.fromValue("AND");

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventFilterRule withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EventFilterRule withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public EventFilterRule withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public EventFilterRule withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="effect")
    public ArgumentsInput.Effect getEffect() {
        return this.effect;
    }

    @JsonProperty(value="effect")
    public void setEffect(ArgumentsInput.Effect effect) {
        this.effect = effect;
    }

    public EventFilterRule withEffect(ArgumentsInput.Effect effect) {
        this.effect = effect;
        return this;
    }

    @JsonProperty(value="condition")
    public String getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public EventFilterRule withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    @JsonProperty(value="arguments")
    public List<String> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public EventFilterRule withArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonProperty(value="inputType")
    public InputType getInputType() {
        return this.inputType;
    }

    @JsonProperty(value="inputType")
    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    public EventFilterRule withInputType(InputType inputType) {
        this.inputType = inputType;
        return this;
    }

    @JsonProperty(value="prefixCondition")
    public ArgumentsInput.PrefixCondition getPrefixCondition() {
        return this.prefixCondition;
    }

    @JsonProperty(value="prefixCondition")
    public void setPrefixCondition(ArgumentsInput.PrefixCondition prefixCondition) {
        this.prefixCondition = prefixCondition;
    }

    public EventFilterRule withPrefixCondition(ArgumentsInput.PrefixCondition prefixCondition) {
        this.prefixCondition = prefixCondition;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventFilterRule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("effect");
        sb.append('=');
        sb.append(this.effect == null ? "<null>" : this.effect);
        sb.append(',');
        sb.append("condition");
        sb.append('=');
        sb.append(this.condition == null ? "<null>" : this.condition);
        sb.append(',');
        sb.append("arguments");
        sb.append('=');
        sb.append(this.arguments == null ? "<null>" : this.arguments);
        sb.append(',');
        sb.append("inputType");
        sb.append('=');
        sb.append(this.inputType == null ? "<null>" : this.inputType);
        sb.append(',');
        sb.append("prefixCondition");
        sb.append('=');
        sb.append(this.prefixCondition == null ? "<null>" : this.prefixCondition);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.condition == null ? 0 : this.condition.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.effect == null ? 0 : this.effect.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.prefixCondition == null ? 0 : this.prefixCondition.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = result * 31 + (this.inputType == null ? 0 : this.inputType.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EventFilterRule)) {
            return false;
        }
        EventFilterRule rhs = (EventFilterRule)other;
        return (this.condition == rhs.condition || this.condition != null && this.condition.equals(rhs.condition)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.effect == rhs.effect || this.effect != null && this.effect.equals((Object)rhs.effect)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.prefixCondition == rhs.prefixCondition || this.prefixCondition != null && this.prefixCondition.equals((Object)rhs.prefixCondition)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.arguments == rhs.arguments || this.arguments != null && this.arguments.equals(rhs.arguments)) && (this.inputType == rhs.inputType || this.inputType != null && this.inputType.equals((Object)rhs.inputType)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName));
    }

    public static enum InputType {
        STATIC("static"),
        RUNTIME("runtime"),
        NONE("none");

        private final String value;
        private static final Map<String, InputType> CONSTANTS;

        private InputType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static InputType fromValue(String value) {
            InputType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, InputType>();
            for (InputType c : InputType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

