/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.events.AlertFilteringInput;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.FilteringRules;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.events.TriggerConfig;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "owners", "href", "version", "updatedAt", "updatedBy", "changeDescription", "alertType", "trigger", "filteringRules", "destinations", "enabled", "batchSize", "provider", "retries", "pollInterval", "input", "domain"})
public class EventSubscription
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display name for this Event Subscription.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="alertType")
    @JsonPropertyDescription(value="Type of Alerts supported.")
    @NotNull
    private CreateEventSubscription.AlertType alertType = CreateEventSubscription.AlertType.fromValue("Notification");
    @JsonProperty(value="trigger")
    @JsonPropertyDescription(value="Trigger Configuration for Alerts.")
    @Valid
    private TriggerConfig trigger;
    @JsonProperty(value="filteringRules")
    @JsonPropertyDescription(value="Filtering Rules for Event Subscription.")
    @Valid
    private FilteringRules filteringRules;
    @JsonProperty(value="destinations")
    @JsonPropertyDescription(value="Destination Config.")
    @Valid
    @NotNull
    private List<SubscriptionDestination> destinations = new ArrayList<SubscriptionDestination>();
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Is the event Subscription enabled.")
    private Boolean enabled = true;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 100).")
    private Integer batchSize = 100;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");
    @JsonProperty(value="retries")
    @JsonPropertyDescription(value="Number of times to retry callback on failure. (Default 3).")
    private Integer retries = 3;
    @JsonProperty(value="pollInterval")
    @JsonPropertyDescription(value="Poll Interval in seconds.")
    private Integer pollInterval = 60;
    @JsonProperty(value="input")
    @JsonPropertyDescription(value="Observability of the event subscription.")
    @Valid
    private AlertFilteringInput input;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference domain;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public EventSubscription withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventSubscription withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public EventSubscription withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EventSubscription withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public EventSubscription withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public EventSubscription withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public EventSubscription withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public EventSubscription withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public EventSubscription withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public EventSubscription withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public EventSubscription withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @JsonProperty(value="alertType")
    public CreateEventSubscription.AlertType getAlertType() {
        return this.alertType;
    }

    @JsonProperty(value="alertType")
    public void setAlertType(CreateEventSubscription.AlertType alertType) {
        this.alertType = alertType;
    }

    public EventSubscription withAlertType(CreateEventSubscription.AlertType alertType) {
        this.alertType = alertType;
        return this;
    }

    @JsonProperty(value="trigger")
    public TriggerConfig getTrigger() {
        return this.trigger;
    }

    @JsonProperty(value="trigger")
    public void setTrigger(TriggerConfig trigger) {
        this.trigger = trigger;
    }

    public EventSubscription withTrigger(TriggerConfig trigger) {
        this.trigger = trigger;
        return this;
    }

    @JsonProperty(value="filteringRules")
    public FilteringRules getFilteringRules() {
        return this.filteringRules;
    }

    @JsonProperty(value="filteringRules")
    public void setFilteringRules(FilteringRules filteringRules) {
        this.filteringRules = filteringRules;
    }

    public EventSubscription withFilteringRules(FilteringRules filteringRules) {
        this.filteringRules = filteringRules;
        return this;
    }

    @JsonProperty(value="destinations")
    public List<SubscriptionDestination> getDestinations() {
        return this.destinations;
    }

    @JsonProperty(value="destinations")
    public void setDestinations(List<SubscriptionDestination> destinations) {
        this.destinations = destinations;
    }

    public EventSubscription withDestinations(List<SubscriptionDestination> destinations) {
        this.destinations = destinations;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public EventSubscription withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public EventSubscription withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public EventSubscription withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public EventSubscription withRetries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="pollInterval")
    public Integer getPollInterval() {
        return this.pollInterval;
    }

    @JsonProperty(value="pollInterval")
    public void setPollInterval(Integer pollInterval) {
        this.pollInterval = pollInterval;
    }

    public EventSubscription withPollInterval(Integer pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    @JsonProperty(value="input")
    public AlertFilteringInput getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    public void setInput(AlertFilteringInput input) {
        this.input = input;
    }

    public EventSubscription withInput(AlertFilteringInput input) {
        this.input = input;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public EventSubscription withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventSubscription.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("alertType");
        sb.append('=');
        sb.append(this.alertType == null ? "<null>" : this.alertType);
        sb.append(',');
        sb.append("trigger");
        sb.append('=');
        sb.append(this.trigger == null ? "<null>" : this.trigger);
        sb.append(',');
        sb.append("filteringRules");
        sb.append('=');
        sb.append(this.filteringRules == null ? "<null>" : this.filteringRules);
        sb.append(',');
        sb.append("destinations");
        sb.append('=');
        sb.append(this.destinations == null ? "<null>" : this.destinations);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("retries");
        sb.append('=');
        sb.append(this.retries == null ? "<null>" : this.retries);
        sb.append(',');
        sb.append("pollInterval");
        sb.append('=');
        sb.append(this.pollInterval == null ? "<null>" : this.pollInterval);
        sb.append(',');
        sb.append("input");
        sb.append('=');
        sb.append(this.input == null ? "<null>" : this.input);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.alertType == null ? 0 : this.alertType.hashCode());
        result = result * 31 + (this.filteringRules == null ? 0 : this.filteringRules.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.destinations == null ? 0 : this.destinations.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.trigger == null ? 0 : this.trigger.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.retries == null ? 0 : this.retries.hashCode());
        result = result * 31 + (this.input == null ? 0 : this.input.hashCode());
        result = result * 31 + (this.pollInterval == null ? 0 : this.pollInterval.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EventSubscription)) {
            return false;
        }
        EventSubscription rhs = (EventSubscription)other;
        return (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.alertType == rhs.alertType || this.alertType != null && this.alertType.equals((Object)rhs.alertType)) && (this.filteringRules == rhs.filteringRules || this.filteringRules != null && this.filteringRules.equals(rhs.filteringRules)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.destinations == rhs.destinations || this.destinations != null && this.destinations.equals(rhs.destinations)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.trigger == rhs.trigger || this.trigger != null && this.trigger.equals(rhs.trigger)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.retries == rhs.retries || this.retries != null && this.retries.equals(rhs.retries)) && (this.input == rhs.input || this.input != null && this.input.equals(rhs.input)) && (this.pollInterval == rhs.pollInterval || this.pollInterval != null && this.pollInterval.equals(rhs.pollInterval)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }
}

