/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.entity.events.SubscriptionStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "category", "type", "statusDetails", "timeout", "readTimeout", "enabled", "config"})
public class SubscriptionDestination {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="category")
    @JsonPropertyDescription(value="Subscription Endpoint Type.")
    @NotNull
    private SubscriptionCategory category;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Subscription Endpoint Type.")
    @NotNull
    private SubscriptionType type;
    @JsonProperty(value="statusDetails")
    @JsonPropertyDescription(value="Subscription Current Status")
    @Valid
    private SubscriptionStatus statusDetails;
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="Connection timeout in seconds. (Default 10s).")
    private Integer timeout = 10;
    @JsonProperty(value="readTimeout")
    @JsonPropertyDescription(value="Read timeout in seconds. (Default 12s).")
    private Integer readTimeout = 12;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Is the subscription enabled.")
    private Boolean enabled = true;
    @JsonProperty(value="config")
    private Object config;

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public SubscriptionDestination withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="category")
    public SubscriptionCategory getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(SubscriptionCategory category) {
        this.category = category;
    }

    public SubscriptionDestination withCategory(SubscriptionCategory category) {
        this.category = category;
        return this;
    }

    @JsonProperty(value="type")
    public SubscriptionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SubscriptionType type) {
        this.type = type;
    }

    public SubscriptionDestination withType(SubscriptionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="statusDetails")
    public SubscriptionStatus getStatusDetails() {
        return this.statusDetails;
    }

    @JsonProperty(value="statusDetails")
    public void setStatusDetails(SubscriptionStatus statusDetails) {
        this.statusDetails = statusDetails;
    }

    public SubscriptionDestination withStatusDetails(SubscriptionStatus statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    @JsonProperty(value="timeout")
    public Integer getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public SubscriptionDestination withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty(value="readTimeout")
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @JsonProperty(value="readTimeout")
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public SubscriptionDestination withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SubscriptionDestination withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="config")
    public Object getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    public void setConfig(Object config) {
        this.config = config;
    }

    public SubscriptionDestination withConfig(Object config) {
        this.config = config;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SubscriptionDestination.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("statusDetails");
        sb.append('=');
        sb.append(this.statusDetails == null ? "<null>" : this.statusDetails);
        sb.append(',');
        sb.append("timeout");
        sb.append('=');
        sb.append(this.timeout == null ? "<null>" : this.timeout);
        sb.append(',');
        sb.append("readTimeout");
        sb.append('=');
        sb.append(this.readTimeout == null ? "<null>" : this.readTimeout);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("config");
        sb.append('=');
        sb.append(this.config == null ? "<null>" : this.config);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.readTimeout == null ? 0 : this.readTimeout.hashCode());
        result = result * 31 + (this.statusDetails == null ? 0 : this.statusDetails.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.config == null ? 0 : this.config.hashCode());
        result = result * 31 + (this.timeout == null ? 0 : this.timeout.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SubscriptionDestination)) {
            return false;
        }
        SubscriptionDestination rhs = (SubscriptionDestination)other;
        return (this.readTimeout == rhs.readTimeout || this.readTimeout != null && this.readTimeout.equals(rhs.readTimeout)) && (this.statusDetails == rhs.statusDetails || this.statusDetails != null && this.statusDetails.equals(rhs.statusDetails)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.category == rhs.category || this.category != null && this.category.equals((Object)rhs.category)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.config == rhs.config || this.config != null && this.config.equals(rhs.config)) && (this.timeout == rhs.timeout || this.timeout != null && this.timeout.equals(rhs.timeout)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled));
    }

    public static enum SubscriptionCategory {
        USERS("Users"),
        TEAMS("Teams"),
        ADMINS("Admins"),
        ASSIGNEES("Assignees"),
        OWNERS("Owners"),
        MENTIONS("Mentions"),
        FOLLOWERS("Followers"),
        EXTERNAL("External");

        private final String value;
        private static final Map<String, SubscriptionCategory> CONSTANTS;

        private SubscriptionCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SubscriptionCategory fromValue(String value) {
            SubscriptionCategory constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SubscriptionCategory>();
            for (SubscriptionCategory c : SubscriptionCategory.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SubscriptionType {
        WEBHOOK("Webhook"),
        SLACK("Slack"),
        MS_TEAMS("MsTeams"),
        G_CHAT("GChat"),
        EMAIL("Email"),
        ACTIVITY_FEED("ActivityFeed");

        private final String value;
        private static final Map<String, SubscriptionType> CONSTANTS;

        private SubscriptionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SubscriptionType fromValue(String value) {
            SubscriptionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SubscriptionType>();
            for (SubscriptionType c : SubscriptionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

