/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"status", "lastSuccessfulAt", "lastFailedAt", "lastFailedStatusCode", "lastFailedReason", "nextAttempt", "timestamp"})
public class SubscriptionStatus {
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status is `disabled`, when eventSubscription was created with `enabled` set to false and it never started publishing events. Status is `active` when eventSubscription is normally functioning and 200 OK response was received for callback notification. Status is `failed` on bad callback URL, connection failures, `1xx`, and `3xx` response was received for callback notification. Status is `awaitingRetry` when previous attempt at callback timed out or received `4xx`, `5xx` response. Status is `retryLimitReached` after all retries fail.")
    private Status status;
    @JsonProperty(value="lastSuccessfulAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long lastSuccessfulAt;
    @JsonProperty(value="lastFailedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long lastFailedAt;
    @JsonProperty(value="lastFailedStatusCode")
    @JsonPropertyDescription(value="Last non-successful activity response code received during callback.")
    private Integer lastFailedStatusCode;
    @JsonProperty(value="lastFailedReason")
    @JsonPropertyDescription(value="Last non-successful activity response reason received during callback.")
    private String lastFailedReason;
    @JsonProperty(value="nextAttempt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long nextAttempt;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    public SubscriptionStatus withStatus(Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="lastSuccessfulAt")
    public Long getLastSuccessfulAt() {
        return this.lastSuccessfulAt;
    }

    @JsonProperty(value="lastSuccessfulAt")
    public void setLastSuccessfulAt(Long lastSuccessfulAt) {
        this.lastSuccessfulAt = lastSuccessfulAt;
    }

    public SubscriptionStatus withLastSuccessfulAt(Long lastSuccessfulAt) {
        this.lastSuccessfulAt = lastSuccessfulAt;
        return this;
    }

    @JsonProperty(value="lastFailedAt")
    public Long getLastFailedAt() {
        return this.lastFailedAt;
    }

    @JsonProperty(value="lastFailedAt")
    public void setLastFailedAt(Long lastFailedAt) {
        this.lastFailedAt = lastFailedAt;
    }

    public SubscriptionStatus withLastFailedAt(Long lastFailedAt) {
        this.lastFailedAt = lastFailedAt;
        return this;
    }

    @JsonProperty(value="lastFailedStatusCode")
    public Integer getLastFailedStatusCode() {
        return this.lastFailedStatusCode;
    }

    @JsonProperty(value="lastFailedStatusCode")
    public void setLastFailedStatusCode(Integer lastFailedStatusCode) {
        this.lastFailedStatusCode = lastFailedStatusCode;
    }

    public SubscriptionStatus withLastFailedStatusCode(Integer lastFailedStatusCode) {
        this.lastFailedStatusCode = lastFailedStatusCode;
        return this;
    }

    @JsonProperty(value="lastFailedReason")
    public String getLastFailedReason() {
        return this.lastFailedReason;
    }

    @JsonProperty(value="lastFailedReason")
    public void setLastFailedReason(String lastFailedReason) {
        this.lastFailedReason = lastFailedReason;
    }

    public SubscriptionStatus withLastFailedReason(String lastFailedReason) {
        this.lastFailedReason = lastFailedReason;
        return this;
    }

    @JsonProperty(value="nextAttempt")
    public Long getNextAttempt() {
        return this.nextAttempt;
    }

    @JsonProperty(value="nextAttempt")
    public void setNextAttempt(Long nextAttempt) {
        this.nextAttempt = nextAttempt;
    }

    public SubscriptionStatus withNextAttempt(Long nextAttempt) {
        this.nextAttempt = nextAttempt;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public SubscriptionStatus withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SubscriptionStatus.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("lastSuccessfulAt");
        sb.append('=');
        sb.append(this.lastSuccessfulAt == null ? "<null>" : this.lastSuccessfulAt);
        sb.append(',');
        sb.append("lastFailedAt");
        sb.append('=');
        sb.append(this.lastFailedAt == null ? "<null>" : this.lastFailedAt);
        sb.append(',');
        sb.append("lastFailedStatusCode");
        sb.append('=');
        sb.append(this.lastFailedStatusCode == null ? "<null>" : this.lastFailedStatusCode);
        sb.append(',');
        sb.append("lastFailedReason");
        sb.append('=');
        sb.append(this.lastFailedReason == null ? "<null>" : this.lastFailedReason);
        sb.append(',');
        sb.append("nextAttempt");
        sb.append('=');
        sb.append(this.nextAttempt == null ? "<null>" : this.nextAttempt);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lastFailedAt == null ? 0 : this.lastFailedAt.hashCode());
        result = result * 31 + (this.lastFailedReason == null ? 0 : this.lastFailedReason.hashCode());
        result = result * 31 + (this.lastFailedStatusCode == null ? 0 : this.lastFailedStatusCode.hashCode());
        result = result * 31 + (this.lastSuccessfulAt == null ? 0 : this.lastSuccessfulAt.hashCode());
        result = result * 31 + (this.nextAttempt == null ? 0 : this.nextAttempt.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SubscriptionStatus)) {
            return false;
        }
        SubscriptionStatus rhs = (SubscriptionStatus)other;
        return (this.lastFailedAt == rhs.lastFailedAt || this.lastFailedAt != null && this.lastFailedAt.equals(rhs.lastFailedAt)) && (this.lastFailedReason == rhs.lastFailedReason || this.lastFailedReason != null && this.lastFailedReason.equals(rhs.lastFailedReason)) && (this.lastFailedStatusCode == rhs.lastFailedStatusCode || this.lastFailedStatusCode != null && this.lastFailedStatusCode.equals(rhs.lastFailedStatusCode)) && (this.lastSuccessfulAt == rhs.lastSuccessfulAt || this.lastSuccessfulAt != null && this.lastSuccessfulAt.equals(rhs.lastSuccessfulAt)) && (this.nextAttempt == rhs.nextAttempt || this.nextAttempt != null && this.nextAttempt.equals(rhs.nextAttempt)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }

    public static enum Status {
        DISABLED("disabled"),
        FAILED("failed"),
        RETRY_LIMIT_REACHED("retryLimitReached"),
        AWAITING_RETRY("awaitingRetry"),
        ACTIVE("active");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

