/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"triggerType", "scheduleInfo", "cronExpression"})
public class TriggerConfig {
    @JsonProperty(value="triggerType")
    @JsonPropertyDescription(value="Trigger Configuration for Alerts.")
    @NotNull
    private TriggerType triggerType = TriggerType.fromValue("RealTime");
    @JsonProperty(value="scheduleInfo")
    @JsonPropertyDescription(value="Schedule Info")
    private ScheduleInfo scheduleInfo = ScheduleInfo.fromValue("Weekly");
    @JsonProperty(value="cronExpression")
    @JsonPropertyDescription(value="Cron Expression in case of Custom scheduled Trigger")
    private String cronExpression;

    @JsonProperty(value="triggerType")
    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    @JsonProperty(value="triggerType")
    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public TriggerConfig withTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    @JsonProperty(value="scheduleInfo")
    public ScheduleInfo getScheduleInfo() {
        return this.scheduleInfo;
    }

    @JsonProperty(value="scheduleInfo")
    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
    }

    public TriggerConfig withScheduleInfo(ScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    @JsonProperty(value="cronExpression")
    public String getCronExpression() {
        return this.cronExpression;
    }

    @JsonProperty(value="cronExpression")
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public TriggerConfig withCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TriggerConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("triggerType");
        sb.append('=');
        sb.append(this.triggerType == null ? "<null>" : this.triggerType);
        sb.append(',');
        sb.append("scheduleInfo");
        sb.append('=');
        sb.append(this.scheduleInfo == null ? "<null>" : this.scheduleInfo);
        sb.append(',');
        sb.append("cronExpression");
        sb.append('=');
        sb.append(this.cronExpression == null ? "<null>" : this.cronExpression);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.cronExpression == null ? 0 : this.cronExpression.hashCode());
        result = result * 31 + (this.triggerType == null ? 0 : this.triggerType.hashCode());
        result = result * 31 + (this.scheduleInfo == null ? 0 : this.scheduleInfo.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig rhs = (TriggerConfig)other;
        return (this.cronExpression == rhs.cronExpression || this.cronExpression != null && this.cronExpression.equals(rhs.cronExpression)) && (this.triggerType == rhs.triggerType || this.triggerType != null && this.triggerType.equals((Object)rhs.triggerType)) && (this.scheduleInfo == rhs.scheduleInfo || this.scheduleInfo != null && this.scheduleInfo.equals((Object)rhs.scheduleInfo));
    }

    public static enum TriggerType {
        REAL_TIME("RealTime"),
        SCHEDULED("Scheduled");

        private final String value;
        private static final Map<String, TriggerType> CONSTANTS;

        private TriggerType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TriggerType fromValue(String value) {
            TriggerType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TriggerType>();
            for (TriggerType c : TriggerType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ScheduleInfo {
        DAILY("Daily"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly"),
        CUSTOM("Custom");

        private final String value;
        private static final Map<String, ScheduleInfo> CONSTANTS;

        private ScheduleInfo(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ScheduleInfo fromValue(String value) {
            ScheduleInfo constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ScheduleInfo>();
            for (ScheduleInfo c : ScheduleInfo.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

