/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.feed;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.SuggestionStatus;
import org.openmetadata.schema.type.SuggestionType;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "type", "href", "entityLink", "createdAt", "createdBy", "updatedAt", "updatedBy", "status", "description", "tagLabels"})
public class Suggestion {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of a Suggestion.")
    private SuggestionType type;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="entityLink")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$")
    private @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$") String entityLink;
    @JsonProperty(value="createdAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long createdAt;
    @JsonProperty(value="createdBy")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference createdBy;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User or Bot who updated the suggestion.")
    private String updatedBy;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status of a Suggestion.")
    private SuggestionStatus status = SuggestionStatus.fromValue("Open");
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="The main message of the thread in Markdown format.")
    private String description;
    @JsonProperty(value="tagLabels")
    @JsonPropertyDescription(value="Tags or Glossary Terms.")
    @Valid
    private List<TagLabel> tagLabels = null;

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Suggestion withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="type")
    public SuggestionType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SuggestionType type) {
        this.type = type;
    }

    public Suggestion withType(SuggestionType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Suggestion withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="entityLink")
    public String getEntityLink() {
        return this.entityLink;
    }

    @JsonProperty(value="entityLink")
    public void setEntityLink(String entityLink) {
        this.entityLink = entityLink;
    }

    public Suggestion withEntityLink(String entityLink) {
        this.entityLink = entityLink;
        return this;
    }

    @JsonProperty(value="createdAt")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public Suggestion withCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="createdBy")
    public EntityReference getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(EntityReference createdBy) {
        this.createdBy = createdBy;
    }

    public Suggestion withCreatedBy(EntityReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Suggestion withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Suggestion withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonProperty(value="status")
    public SuggestionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(SuggestionStatus status) {
        this.status = status;
    }

    public Suggestion withStatus(SuggestionStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Suggestion withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="tagLabels")
    public List<TagLabel> getTagLabels() {
        return this.tagLabels;
    }

    @JsonProperty(value="tagLabels")
    public void setTagLabels(List<TagLabel> tagLabels) {
        this.tagLabels = tagLabels;
    }

    public Suggestion withTagLabels(List<TagLabel> tagLabels) {
        this.tagLabels = tagLabels;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Suggestion.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("entityLink");
        sb.append('=');
        sb.append(this.entityLink == null ? "<null>" : this.entityLink);
        sb.append(',');
        sb.append("createdAt");
        sb.append('=');
        sb.append(this.createdAt == null ? "<null>" : this.createdAt);
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(this.createdBy == null ? "<null>" : this.createdBy);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("tagLabels");
        sb.append('=');
        sb.append(this.tagLabels == null ? "<null>" : this.tagLabels);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        result = result * 31 + (this.tagLabels == null ? 0 : this.tagLabels.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.entityLink == null ? 0 : this.entityLink.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Suggestion)) {
            return false;
        }
        Suggestion rhs = (Suggestion)other;
        return (this.createdAt == rhs.createdAt || this.createdAt != null && this.createdAt.equals(rhs.createdAt)) && (this.tagLabels == rhs.tagLabels || this.tagLabels != null && this.tagLabels.equals(rhs.tagLabels)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.createdBy == rhs.createdBy || this.createdBy != null && this.createdBy.equals(rhs.createdBy)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.entityLink == rhs.entityLink || this.entityLink != null && this.entityLink.equals(rhs.entityLink)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

