/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.feed;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.openmetadata.schema.entity.feed.FeedInfo;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.ChatbotDetails;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Reaction;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.ThreadType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "type", "href", "threadTs", "about", "entityRef", "entityUrlLink", "domain", "generatedBy", "cardStyle", "fieldOperation", "feedInfo", "addressedTo", "createdBy", "updatedAt", "updatedBy", "resolved", "message", "postsCount", "posts", "reactions", "task", "announcement", "chatbot"})
public class Thread {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of thread.")
    private ThreadType type = ThreadType.fromValue("Conversation");
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="threadTs")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long threadTs;
    @JsonProperty(value="about")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$")
    @NotNull
    private @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$") @NotNull String about;
    @JsonProperty(value="entityRef")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference entityRef;
    @JsonProperty(value="entityUrlLink")
    @JsonPropertyDescription(value="Link to the entity in `about` that the thread belongs to.")
    private String entityUrlLink;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID domain;
    @JsonProperty(value="generatedBy")
    @JsonPropertyDescription(value="User or team that generated the thread.")
    private GeneratedBy generatedBy = GeneratedBy.fromValue("user");
    @JsonProperty(value="cardStyle")
    @JsonPropertyDescription(value="Card style for the thread.")
    private CardStyle cardStyle = CardStyle.fromValue("default");
    @JsonProperty(value="fieldOperation")
    @JsonPropertyDescription(value="Operation on thread, whether the field was added, or updated or deleted.")
    private FieldOperation fieldOperation = FieldOperation.fromValue("updated");
    @JsonProperty(value="feedInfo")
    @JsonPropertyDescription(value="Entity Id of the entity in `about` that the thread belongs to.")
    @Valid
    private FeedInfo feedInfo;
    @JsonProperty(value="addressedTo")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$")
    private @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$") String addressedTo;
    @JsonProperty(value="createdBy")
    @JsonPropertyDescription(value="User who created the thread.")
    private String createdBy;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="resolved")
    @JsonPropertyDescription(value="When `true` indicates the thread has been resolved.")
    private Boolean resolved = false;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="The main message of the thread in Markdown format.")
    @NotNull
    private String message;
    @JsonProperty(value="postsCount")
    @JsonPropertyDescription(value="The total count of posts in the thread.")
    private Integer postsCount = 0;
    @JsonProperty(value="posts")
    @Valid
    private List<Post> posts = new ArrayList<Post>();
    @JsonProperty(value="reactions")
    @Valid
    private List<Reaction> reactions = null;
    @JsonProperty(value="task")
    @JsonPropertyDescription(value="Details about the task. This is only applicable if thread is of type task.")
    @Valid
    private TaskDetails task;
    @JsonProperty(value="announcement")
    @JsonPropertyDescription(value="Details about the announcement. This is only applicable if thread is of type announcement.")
    @Valid
    private AnnouncementDetails announcement;
    @JsonProperty(value="chatbot")
    @JsonPropertyDescription(value="Details about the Chatbot conversation. This is only applicable if thread is of type Chatbot.")
    @Valid
    private ChatbotDetails chatbot;

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Thread withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="type")
    public ThreadType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ThreadType type) {
        this.type = type;
    }

    public Thread withType(ThreadType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Thread withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="threadTs")
    public Long getThreadTs() {
        return this.threadTs;
    }

    @JsonProperty(value="threadTs")
    public void setThreadTs(Long threadTs) {
        this.threadTs = threadTs;
    }

    public Thread withThreadTs(Long threadTs) {
        this.threadTs = threadTs;
        return this;
    }

    @JsonProperty(value="about")
    public String getAbout() {
        return this.about;
    }

    @JsonProperty(value="about")
    public void setAbout(String about) {
        this.about = about;
    }

    public Thread withAbout(String about) {
        this.about = about;
        return this;
    }

    @JsonProperty(value="entityRef")
    public EntityReference getEntityRef() {
        return this.entityRef;
    }

    @JsonProperty(value="entityRef")
    public void setEntityRef(EntityReference entityRef) {
        this.entityRef = entityRef;
    }

    public Thread withEntityRef(EntityReference entityRef) {
        this.entityRef = entityRef;
        return this;
    }

    @JsonProperty(value="entityUrlLink")
    public String getEntityUrlLink() {
        return this.entityUrlLink;
    }

    @JsonProperty(value="entityUrlLink")
    public void setEntityUrlLink(String entityUrlLink) {
        this.entityUrlLink = entityUrlLink;
    }

    public Thread withEntityUrlLink(String entityUrlLink) {
        this.entityUrlLink = entityUrlLink;
        return this;
    }

    @JsonProperty(value="domain")
    public UUID getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(UUID domain) {
        this.domain = domain;
    }

    public Thread withDomain(UUID domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="generatedBy")
    public GeneratedBy getGeneratedBy() {
        return this.generatedBy;
    }

    @JsonProperty(value="generatedBy")
    public void setGeneratedBy(GeneratedBy generatedBy) {
        this.generatedBy = generatedBy;
    }

    public Thread withGeneratedBy(GeneratedBy generatedBy) {
        this.generatedBy = generatedBy;
        return this;
    }

    @JsonProperty(value="cardStyle")
    public CardStyle getCardStyle() {
        return this.cardStyle;
    }

    @JsonProperty(value="cardStyle")
    public void setCardStyle(CardStyle cardStyle) {
        this.cardStyle = cardStyle;
    }

    public Thread withCardStyle(CardStyle cardStyle) {
        this.cardStyle = cardStyle;
        return this;
    }

    @JsonProperty(value="fieldOperation")
    public FieldOperation getFieldOperation() {
        return this.fieldOperation;
    }

    @JsonProperty(value="fieldOperation")
    public void setFieldOperation(FieldOperation fieldOperation) {
        this.fieldOperation = fieldOperation;
    }

    public Thread withFieldOperation(FieldOperation fieldOperation) {
        this.fieldOperation = fieldOperation;
        return this;
    }

    @JsonProperty(value="feedInfo")
    public FeedInfo getFeedInfo() {
        return this.feedInfo;
    }

    @JsonProperty(value="feedInfo")
    public void setFeedInfo(FeedInfo feedInfo) {
        this.feedInfo = feedInfo;
    }

    public Thread withFeedInfo(FeedInfo feedInfo) {
        this.feedInfo = feedInfo;
        return this;
    }

    @JsonProperty(value="addressedTo")
    public String getAddressedTo() {
        return this.addressedTo;
    }

    @JsonProperty(value="addressedTo")
    public void setAddressedTo(String addressedTo) {
        this.addressedTo = addressedTo;
    }

    public Thread withAddressedTo(String addressedTo) {
        this.addressedTo = addressedTo;
        return this;
    }

    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Thread withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Thread withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Thread withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonProperty(value="resolved")
    public Boolean getResolved() {
        return this.resolved;
    }

    @JsonProperty(value="resolved")
    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    public Thread withResolved(Boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public Thread withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="postsCount")
    public Integer getPostsCount() {
        return this.postsCount;
    }

    @JsonProperty(value="postsCount")
    public void setPostsCount(Integer postsCount) {
        this.postsCount = postsCount;
    }

    public Thread withPostsCount(Integer postsCount) {
        this.postsCount = postsCount;
        return this;
    }

    @JsonProperty(value="posts")
    public List<Post> getPosts() {
        return this.posts;
    }

    @JsonProperty(value="posts")
    public void setPosts(List<Post> posts) {
        this.posts = posts;
    }

    public Thread withPosts(List<Post> posts) {
        this.posts = posts;
        return this;
    }

    @JsonProperty(value="reactions")
    public List<Reaction> getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="reactions")
    public void setReactions(List<Reaction> reactions) {
        this.reactions = reactions;
    }

    public Thread withReactions(List<Reaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    @JsonProperty(value="task")
    public TaskDetails getTask() {
        return this.task;
    }

    @JsonProperty(value="task")
    public void setTask(TaskDetails task) {
        this.task = task;
    }

    public Thread withTask(TaskDetails task) {
        this.task = task;
        return this;
    }

    @JsonProperty(value="announcement")
    public AnnouncementDetails getAnnouncement() {
        return this.announcement;
    }

    @JsonProperty(value="announcement")
    public void setAnnouncement(AnnouncementDetails announcement) {
        this.announcement = announcement;
    }

    public Thread withAnnouncement(AnnouncementDetails announcement) {
        this.announcement = announcement;
        return this;
    }

    @JsonProperty(value="chatbot")
    public ChatbotDetails getChatbot() {
        return this.chatbot;
    }

    @JsonProperty(value="chatbot")
    public void setChatbot(ChatbotDetails chatbot) {
        this.chatbot = chatbot;
    }

    public Thread withChatbot(ChatbotDetails chatbot) {
        this.chatbot = chatbot;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("threadTs");
        sb.append('=');
        sb.append(this.threadTs == null ? "<null>" : this.threadTs);
        sb.append(',');
        sb.append("about");
        sb.append('=');
        sb.append(this.about == null ? "<null>" : this.about);
        sb.append(',');
        sb.append("entityRef");
        sb.append('=');
        sb.append(this.entityRef == null ? "<null>" : this.entityRef);
        sb.append(',');
        sb.append("entityUrlLink");
        sb.append('=');
        sb.append(this.entityUrlLink == null ? "<null>" : this.entityUrlLink);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("generatedBy");
        sb.append('=');
        sb.append(this.generatedBy == null ? "<null>" : this.generatedBy);
        sb.append(',');
        sb.append("cardStyle");
        sb.append('=');
        sb.append(this.cardStyle == null ? "<null>" : this.cardStyle);
        sb.append(',');
        sb.append("fieldOperation");
        sb.append('=');
        sb.append(this.fieldOperation == null ? "<null>" : this.fieldOperation);
        sb.append(',');
        sb.append("feedInfo");
        sb.append('=');
        sb.append(this.feedInfo == null ? "<null>" : this.feedInfo);
        sb.append(',');
        sb.append("addressedTo");
        sb.append('=');
        sb.append(this.addressedTo == null ? "<null>" : this.addressedTo);
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(this.createdBy == null ? "<null>" : this.createdBy);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("resolved");
        sb.append('=');
        sb.append(this.resolved == null ? "<null>" : this.resolved);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("postsCount");
        sb.append('=');
        sb.append(this.postsCount == null ? "<null>" : this.postsCount);
        sb.append(',');
        sb.append("posts");
        sb.append('=');
        sb.append(this.posts == null ? "<null>" : this.posts);
        sb.append(',');
        sb.append("reactions");
        sb.append('=');
        sb.append(this.reactions == null ? "<null>" : this.reactions);
        sb.append(',');
        sb.append("task");
        sb.append('=');
        sb.append(this.task == null ? "<null>" : this.task);
        sb.append(',');
        sb.append("announcement");
        sb.append('=');
        sb.append(this.announcement == null ? "<null>" : this.announcement);
        sb.append(',');
        sb.append("chatbot");
        sb.append('=');
        sb.append(this.chatbot == null ? "<null>" : this.chatbot);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.addressedTo == null ? 0 : this.addressedTo.hashCode());
        result = result * 31 + (this.about == null ? 0 : this.about.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.posts == null ? 0 : this.posts.hashCode());
        result = result * 31 + (this.postsCount == null ? 0 : this.postsCount.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.generatedBy == null ? 0 : this.generatedBy.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.resolved == null ? 0 : this.resolved.hashCode());
        result = result * 31 + (this.announcement == null ? 0 : this.announcement.hashCode());
        result = result * 31 + (this.entityUrlLink == null ? 0 : this.entityUrlLink.hashCode());
        result = result * 31 + (this.chatbot == null ? 0 : this.chatbot.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.feedInfo == null ? 0 : this.feedInfo.hashCode());
        result = result * 31 + (this.fieldOperation == null ? 0 : this.fieldOperation.hashCode());
        result = result * 31 + (this.entityRef == null ? 0 : this.entityRef.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.task == null ? 0 : this.task.hashCode());
        result = result * 31 + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.reactions == null ? 0 : this.reactions.hashCode());
        result = result * 31 + (this.threadTs == null ? 0 : this.threadTs.hashCode());
        result = result * 31 + (this.cardStyle == null ? 0 : this.cardStyle.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Thread)) {
            return false;
        }
        Thread rhs = (Thread)other;
        return (this.addressedTo == rhs.addressedTo || this.addressedTo != null && this.addressedTo.equals(rhs.addressedTo)) && (this.about == rhs.about || this.about != null && this.about.equals(rhs.about)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.posts == rhs.posts || this.posts != null && this.posts.equals(rhs.posts)) && (this.postsCount == rhs.postsCount || this.postsCount != null && this.postsCount.equals(rhs.postsCount)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.generatedBy == rhs.generatedBy || this.generatedBy != null && this.generatedBy.equals((Object)rhs.generatedBy)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.resolved == rhs.resolved || this.resolved != null && this.resolved.equals(rhs.resolved)) && (this.announcement == rhs.announcement || this.announcement != null && this.announcement.equals(rhs.announcement)) && (this.entityUrlLink == rhs.entityUrlLink || this.entityUrlLink != null && this.entityUrlLink.equals(rhs.entityUrlLink)) && (this.chatbot == rhs.chatbot || this.chatbot != null && this.chatbot.equals(rhs.chatbot)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.feedInfo == rhs.feedInfo || this.feedInfo != null && this.feedInfo.equals(rhs.feedInfo)) && (this.fieldOperation == rhs.fieldOperation || this.fieldOperation != null && this.fieldOperation.equals((Object)rhs.fieldOperation)) && (this.entityRef == rhs.entityRef || this.entityRef != null && this.entityRef.equals(rhs.entityRef)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.task == rhs.task || this.task != null && this.task.equals(rhs.task)) && (this.createdBy == rhs.createdBy || this.createdBy != null && this.createdBy.equals(rhs.createdBy)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.reactions == rhs.reactions || this.reactions != null && this.reactions.equals(rhs.reactions)) && (this.threadTs == rhs.threadTs || this.threadTs != null && this.threadTs.equals(rhs.threadTs)) && (this.cardStyle == rhs.cardStyle || this.cardStyle != null && this.cardStyle.equals((Object)rhs.cardStyle));
    }

    public static enum GeneratedBy {
        USER("user"),
        SYSTEM("system");

        private final String value;
        private static final Map<String, GeneratedBy> CONSTANTS;

        private GeneratedBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GeneratedBy fromValue(String value) {
            GeneratedBy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, GeneratedBy>();
            for (GeneratedBy c : GeneratedBy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CardStyle {
        DEFAULT("default"),
        LOGICAL_TEST_CASE_ADDED("logicalTestCaseAdded"),
        ENTITY_CREATED("entityCreated"),
        ENTITY_DELETED("entityDeleted"),
        ENTITY_SOFT_DELETED("entitySoftDeleted"),
        DESCRIPTION("description"),
        TAGS("tags"),
        OWNER("owner"),
        TEST_CASE_RESULT("testCaseResult"),
        CUSTOM_PROPERTIES("customProperties"),
        ASSETS("assets"),
        DOMAIN("domain");

        private final String value;
        private static final Map<String, CardStyle> CONSTANTS;

        private CardStyle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CardStyle fromValue(String value) {
            CardStyle constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CardStyle>();
            for (CardStyle c : CardStyle.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum FieldOperation {
        ADDED("added"),
        UPDATED("updated"),
        DELETED("deleted"),
        NONE("none");

        private final String value;
        private static final Map<String, FieldOperation> CONSTANTS;

        private FieldOperation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FieldOperation fromValue(String value) {
            FieldOperation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FieldOperation>();
            for (FieldOperation c : FieldOperation.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

