/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ServiceType {
    DASHBOARD("Dashboard"),
    DATABASE("Database"),
    MESSAGING("Messaging"),
    METADATA("Metadata"),
    ML_MODEL("MlModel"),
    PIPELINE("Pipeline"),
    STORAGE("Storage"),
    SEARCH("Search"),
    API("API");

    private final String value;
    private static final Map<String, ServiceType> CONSTANTS;

    private ServiceType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ServiceType fromValue(String value) {
        ServiceType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ServiceType>();
        for (ServiceType c : ServiceType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

