/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.services.connections;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "mandatory", "passed", "message", "errorLog"})
public class TestConnectionStepResult {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the step being tested")
    @NotNull
    private String name;
    @JsonProperty(value="mandatory")
    @JsonPropertyDescription(value="Is this step mandatory to be passed?")
    @NotNull
    private Boolean mandatory = true;
    @JsonProperty(value="passed")
    @JsonPropertyDescription(value="Did the step pass successfully?")
    @NotNull
    private Boolean passed;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Results or exceptions to be shared after running the test. This message comes from the test connection definition")
    private String message = null;
    @JsonProperty(value="errorLog")
    @JsonPropertyDescription(value="In case of failed step, this field would contain the actual error faced during the step.")
    private String errorLog = null;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public TestConnectionStepResult withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="mandatory")
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @JsonProperty(value="mandatory")
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public TestConnectionStepResult withMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    @JsonProperty(value="passed")
    public Boolean getPassed() {
        return this.passed;
    }

    @JsonProperty(value="passed")
    public void setPassed(Boolean passed) {
        this.passed = passed;
    }

    public TestConnectionStepResult withPassed(Boolean passed) {
        this.passed = passed;
        return this;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public TestConnectionStepResult withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="errorLog")
    public String getErrorLog() {
        return this.errorLog;
    }

    @JsonProperty(value="errorLog")
    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    public TestConnectionStepResult withErrorLog(String errorLog) {
        this.errorLog = errorLog;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestConnectionStepResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("mandatory");
        sb.append('=');
        sb.append(this.mandatory == null ? "<null>" : this.mandatory);
        sb.append(',');
        sb.append("passed");
        sb.append('=');
        sb.append(this.passed == null ? "<null>" : this.passed);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("errorLog");
        sb.append('=');
        sb.append(this.errorLog == null ? "<null>" : this.errorLog);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.errorLog == null ? 0 : this.errorLog.hashCode());
        result = result * 31 + (this.passed == null ? 0 : this.passed.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.mandatory == null ? 0 : this.mandatory.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestConnectionStepResult)) {
            return false;
        }
        TestConnectionStepResult rhs = (TestConnectionStepResult)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.errorLog == rhs.errorLog || this.errorLog != null && this.errorLog.equals(rhs.errorLog)) && (this.passed == rhs.passed || this.passed != null && this.passed.equals(rhs.passed)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.mandatory == rhs.mandatory || this.mandatory != null && this.mandatory.equals(rhs.mandatory));
    }
}

