/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.teams;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Profile;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "teamType", "name", "email", "fullyQualifiedName", "displayName", "description", "version", "updatedAt", "updatedBy", "href", "profile", "parents", "children", "users", "childrenCount", "userCount", "owns", "owners", "isJoinable", "changeDescription", "deleted", "defaultRoles", "inheritedRoles", "policies", "domains"})
public class Team
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="teamType")
    @JsonPropertyDescription(value="Organization is the highest level entity. An Organization has one of more Business Units, Division, Departments, Group, or Users. A Business Unit has one or more Divisions, Departments, Group, or Users. A Division has one or more Divisions, Departments, Group, or Users. A Department has one or more Departments, Group, or Users. A Group has only Users")
    private CreateTeam.TeamType teamType = CreateTeam.TeamType.fromValue("Group");
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @Email
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    private @Email @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$") @Size(min=6, max=127) String email;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Name used for display purposes. Example 'Data Science team'.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="This schema defines the type for a profile of a user, team, or organization.")
    @Valid
    private Profile profile;
    @JsonProperty(value="parents")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> parents = null;
    @JsonProperty(value="children")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> children = null;
    @JsonProperty(value="users")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> users = null;
    @JsonProperty(value="childrenCount")
    @JsonPropertyDescription(value="Total count of Children teams.")
    private Integer childrenCount;
    @JsonProperty(value="userCount")
    @JsonPropertyDescription(value="Total count of users that are part of the team.")
    private Integer userCount;
    @JsonProperty(value="owns")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owns = null;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="isJoinable")
    @JsonPropertyDescription(value="Can any user join this team during sign up? Value of true indicates yes, and false no.")
    private Boolean isJoinable = true;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="defaultRoles")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> defaultRoles = null;
    @JsonProperty(value="inheritedRoles")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> inheritedRoles = null;
    @JsonProperty(value="policies")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> policies = null;
    @JsonProperty(value="domains")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> domains = null;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Team withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="teamType")
    public CreateTeam.TeamType getTeamType() {
        return this.teamType;
    }

    @JsonProperty(value="teamType")
    public void setTeamType(CreateTeam.TeamType teamType) {
        this.teamType = teamType;
    }

    public Team withTeamType(CreateTeam.TeamType teamType) {
        this.teamType = teamType;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Team withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public Team withEmail(String email) {
        this.email = email;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Team withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Team withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Team withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public Team withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Team withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Team withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Team withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="profile")
    public Profile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public Team withProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @JsonProperty(value="parents")
    public List<EntityReference> getParents() {
        return this.parents;
    }

    @JsonProperty(value="parents")
    public void setParents(List<EntityReference> parents) {
        this.parents = parents;
    }

    public Team withParents(List<EntityReference> parents) {
        this.parents = parents;
        return this;
    }

    @Override
    @JsonProperty(value="children")
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @Override
    @JsonProperty(value="children")
    public void setChildren(List<EntityReference> children) {
        this.children = children;
    }

    public Team withChildren(List<EntityReference> children) {
        this.children = children;
        return this;
    }

    @JsonProperty(value="users")
    public List<EntityReference> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<EntityReference> users) {
        this.users = users;
    }

    public Team withUsers(List<EntityReference> users) {
        this.users = users;
        return this;
    }

    @JsonProperty(value="childrenCount")
    public Integer getChildrenCount() {
        return this.childrenCount;
    }

    @JsonProperty(value="childrenCount")
    public void setChildrenCount(Integer childrenCount) {
        this.childrenCount = childrenCount;
    }

    public Team withChildrenCount(Integer childrenCount) {
        this.childrenCount = childrenCount;
        return this;
    }

    @JsonProperty(value="userCount")
    public Integer getUserCount() {
        return this.userCount;
    }

    @JsonProperty(value="userCount")
    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public Team withUserCount(Integer userCount) {
        this.userCount = userCount;
        return this;
    }

    @JsonProperty(value="owns")
    public List<EntityReference> getOwns() {
        return this.owns;
    }

    @JsonProperty(value="owns")
    public void setOwns(List<EntityReference> owns) {
        this.owns = owns;
    }

    public Team withOwns(List<EntityReference> owns) {
        this.owns = owns;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public Team withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @JsonProperty(value="isJoinable")
    public Boolean getIsJoinable() {
        return this.isJoinable;
    }

    @JsonProperty(value="isJoinable")
    public void setIsJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
    }

    public Team withIsJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Team withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Team withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty(value="defaultRoles")
    public List<EntityReference> getDefaultRoles() {
        return this.defaultRoles;
    }

    @JsonProperty(value="defaultRoles")
    public void setDefaultRoles(List<EntityReference> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public Team withDefaultRoles(List<EntityReference> defaultRoles) {
        this.defaultRoles = defaultRoles;
        return this;
    }

    @JsonProperty(value="inheritedRoles")
    public List<EntityReference> getInheritedRoles() {
        return this.inheritedRoles;
    }

    @JsonProperty(value="inheritedRoles")
    public void setInheritedRoles(List<EntityReference> inheritedRoles) {
        this.inheritedRoles = inheritedRoles;
    }

    public Team withInheritedRoles(List<EntityReference> inheritedRoles) {
        this.inheritedRoles = inheritedRoles;
        return this;
    }

    @JsonProperty(value="policies")
    public List<EntityReference> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    public void setPolicies(List<EntityReference> policies) {
        this.policies = policies;
    }

    public Team withPolicies(List<EntityReference> policies) {
        this.policies = policies;
        return this;
    }

    @JsonProperty(value="domains")
    public List<EntityReference> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    public void setDomains(List<EntityReference> domains) {
        this.domains = domains;
    }

    public Team withDomains(List<EntityReference> domains) {
        this.domains = domains;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Team.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("teamType");
        sb.append('=');
        sb.append(this.teamType == null ? "<null>" : this.teamType);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("profile");
        sb.append('=');
        sb.append(this.profile == null ? "<null>" : this.profile);
        sb.append(',');
        sb.append("parents");
        sb.append('=');
        sb.append(this.parents == null ? "<null>" : this.parents);
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(this.children == null ? "<null>" : this.children);
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(this.users == null ? "<null>" : this.users);
        sb.append(',');
        sb.append("childrenCount");
        sb.append('=');
        sb.append(this.childrenCount == null ? "<null>" : this.childrenCount);
        sb.append(',');
        sb.append("userCount");
        sb.append('=');
        sb.append(this.userCount == null ? "<null>" : this.userCount);
        sb.append(',');
        sb.append("owns");
        sb.append('=');
        sb.append(this.owns == null ? "<null>" : this.owns);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("isJoinable");
        sb.append('=');
        sb.append(this.isJoinable == null ? "<null>" : this.isJoinable);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("defaultRoles");
        sb.append('=');
        sb.append(this.defaultRoles == null ? "<null>" : this.defaultRoles);
        sb.append(',');
        sb.append("inheritedRoles");
        sb.append('=');
        sb.append(this.inheritedRoles == null ? "<null>" : this.inheritedRoles);
        sb.append(',');
        sb.append("policies");
        sb.append('=');
        sb.append(this.policies == null ? "<null>" : this.policies);
        sb.append(',');
        sb.append("domains");
        sb.append('=');
        sb.append(this.domains == null ? "<null>" : this.domains);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.policies == null ? 0 : this.policies.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.children == null ? 0 : this.children.hashCode());
        result = result * 31 + (this.owns == null ? 0 : this.owns.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.childrenCount == null ? 0 : this.childrenCount.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.profile == null ? 0 : this.profile.hashCode());
        result = result * 31 + (this.inheritedRoles == null ? 0 : this.inheritedRoles.hashCode());
        result = result * 31 + (this.domains == null ? 0 : this.domains.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.users == null ? 0 : this.users.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.userCount == null ? 0 : this.userCount.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.defaultRoles == null ? 0 : this.defaultRoles.hashCode());
        result = result * 31 + (this.teamType == null ? 0 : this.teamType.hashCode());
        result = result * 31 + (this.isJoinable == null ? 0 : this.isJoinable.hashCode());
        result = result * 31 + (this.parents == null ? 0 : this.parents.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Team)) {
            return false;
        }
        Team rhs = (Team)other;
        return (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.policies == rhs.policies || this.policies != null && this.policies.equals(rhs.policies)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.children == rhs.children || this.children != null && this.children.equals(rhs.children)) && (this.owns == rhs.owns || this.owns != null && this.owns.equals(rhs.owns)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.childrenCount == rhs.childrenCount || this.childrenCount != null && this.childrenCount.equals(rhs.childrenCount)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.profile == rhs.profile || this.profile != null && this.profile.equals(rhs.profile)) && (this.inheritedRoles == rhs.inheritedRoles || this.inheritedRoles != null && this.inheritedRoles.equals(rhs.inheritedRoles)) && (this.domains == rhs.domains || this.domains != null && this.domains.equals(rhs.domains)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.users == rhs.users || this.users != null && this.users.equals(rhs.users)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.userCount == rhs.userCount || this.userCount != null && this.userCount.equals(rhs.userCount)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.defaultRoles == rhs.defaultRoles || this.defaultRoles != null && this.defaultRoles.equals(rhs.defaultRoles)) && (this.teamType == rhs.teamType || this.teamType != null && this.teamType.equals((Object)rhs.teamType)) && (this.isJoinable == rhs.isJoinable || this.isJoinable != null && this.isJoinable.equals(rhs.isJoinable)) && (this.parents == rhs.parents || this.parents != null && this.parents.equals(rhs.parents));
    }
}

