/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.teams;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.api.teams.CreateTeam;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "teamType", "name", "description", "fullyQualifiedName", "displayName", "href", "children", "isJoinable"})
public class TeamHierarchy {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="teamType")
    @JsonPropertyDescription(value="Organization is the highest level entity. An Organization has one of more Business Units, Division, Departments, Group, or Users. A Business Unit has one or more Divisions, Departments, Group, or Users. A Division has one or more Divisions, Departments, Group, or Users. A Department has one or more Departments, Group, or Users. A Group has only Users")
    private CreateTeam.TeamType teamType = CreateTeam.TeamType.fromValue("Group");
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Name used for display purposes. Example 'Data Science team'.")
    private String displayName;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="children")
    @Valid
    private List<TeamHierarchy> children = null;
    @JsonProperty(value="isJoinable")
    @JsonPropertyDescription(value="Can any user join this team during sign up? Value of true indicates yes, and false no.")
    private Boolean isJoinable = true;

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public TeamHierarchy withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="teamType")
    public CreateTeam.TeamType getTeamType() {
        return this.teamType;
    }

    @JsonProperty(value="teamType")
    public void setTeamType(CreateTeam.TeamType teamType) {
        this.teamType = teamType;
    }

    public TeamHierarchy withTeamType(CreateTeam.TeamType teamType) {
        this.teamType = teamType;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public TeamHierarchy withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TeamHierarchy withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public TeamHierarchy withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public TeamHierarchy withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public TeamHierarchy withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="children")
    public List<TeamHierarchy> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    public void setChildren(List<TeamHierarchy> children) {
        this.children = children;
    }

    public TeamHierarchy withChildren(List<TeamHierarchy> children) {
        this.children = children;
        return this;
    }

    @JsonProperty(value="isJoinable")
    public Boolean getIsJoinable() {
        return this.isJoinable;
    }

    @JsonProperty(value="isJoinable")
    public void setIsJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
    }

    public TeamHierarchy withIsJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TeamHierarchy.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("teamType");
        sb.append('=');
        sb.append(this.teamType == null ? "<null>" : this.teamType);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(this.children == null ? "<null>" : this.children);
        sb.append(',');
        sb.append("isJoinable");
        sb.append('=');
        sb.append(this.isJoinable == null ? "<null>" : this.isJoinable);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.teamType == null ? 0 : this.teamType.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.isJoinable == null ? 0 : this.isJoinable.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TeamHierarchy)) {
            return false;
        }
        TeamHierarchy rhs = (TeamHierarchy)other;
        return (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.teamType == rhs.teamType || this.teamType != null && this.teamType.equals((Object)rhs.teamType)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.isJoinable == rhs.isJoinable || this.isJoinable != null && this.isJoinable.equals(rhs.isJoinable));
    }
}

