/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.teams;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Profile;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "description", "displayName", "version", "updatedAt", "updatedBy", "email", "href", "timezone", "isBot", "isAdmin", "authenticationMechanism", "profile", "teams", "defaultPersona", "personas", "owns", "follows", "changeDescription", "deleted", "roles", "inheritedRoles", "isEmailVerified", "domains"})
public class User
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Name used for display purposes. Example 'FirstName LastName'.")
    private String displayName;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @Email
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    @NotNull
    private @Email @Pattern(regexp="^[\\S.!#$%&\u2019*+/=?^_`{|}~-]+@\\S+\\.\\S+$") @Size(min=6, max=127) @NotNull String email;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="timezone")
    @JsonPropertyDescription(value="Timezone of the user.")
    private String timezone;
    @JsonProperty(value="isBot")
    @JsonPropertyDescription(value="When true indicates a special type of user called Bot.")
    private Boolean isBot = false;
    @JsonProperty(value="isAdmin")
    @JsonPropertyDescription(value="When true indicates user is an administrator for the system with superuser privileges.")
    private Boolean isAdmin = false;
    @JsonProperty(value="authenticationMechanism")
    @JsonPropertyDescription(value="User/Bot Authentication Mechanism.")
    @Valid
    private AuthenticationMechanism authenticationMechanism;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="This schema defines the type for a profile of a user, team, or organization.")
    @Valid
    private Profile profile;
    @JsonProperty(value="teams")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> teams = null;
    @JsonProperty(value="defaultPersona")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference defaultPersona;
    @JsonProperty(value="personas")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> personas = null;
    @JsonProperty(value="owns")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owns = null;
    @JsonProperty(value="follows")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> follows = null;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="roles")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> roles = null;
    @JsonProperty(value="inheritedRoles")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> inheritedRoles = null;
    @JsonProperty(value="isEmailVerified")
    @JsonPropertyDescription(value="If the User has verified the mail")
    private Boolean isEmailVerified;
    @JsonProperty(value="domains")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> domains = null;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public User withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public User withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public User withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public User withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public User withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public User withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public User withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public User withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public User withEmail(String email) {
        this.email = email;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public User withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public User withTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @JsonProperty(value="isBot")
    public Boolean getIsBot() {
        return this.isBot;
    }

    @JsonProperty(value="isBot")
    public void setIsBot(Boolean isBot) {
        this.isBot = isBot;
    }

    public User withIsBot(Boolean isBot) {
        this.isBot = isBot;
        return this;
    }

    @JsonProperty(value="isAdmin")
    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    @JsonProperty(value="isAdmin")
    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public User withIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
        return this;
    }

    @JsonProperty(value="authenticationMechanism")
    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    @JsonProperty(value="authenticationMechanism")
    public void setAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
    }

    public User withAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
        return this;
    }

    @JsonProperty(value="profile")
    public Profile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public User withProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @JsonProperty(value="teams")
    public List<EntityReference> getTeams() {
        return this.teams;
    }

    @JsonProperty(value="teams")
    public void setTeams(List<EntityReference> teams) {
        this.teams = teams;
    }

    public User withTeams(List<EntityReference> teams) {
        this.teams = teams;
        return this;
    }

    @JsonProperty(value="defaultPersona")
    public EntityReference getDefaultPersona() {
        return this.defaultPersona;
    }

    @JsonProperty(value="defaultPersona")
    public void setDefaultPersona(EntityReference defaultPersona) {
        this.defaultPersona = defaultPersona;
    }

    public User withDefaultPersona(EntityReference defaultPersona) {
        this.defaultPersona = defaultPersona;
        return this;
    }

    @JsonProperty(value="personas")
    public List<EntityReference> getPersonas() {
        return this.personas;
    }

    @JsonProperty(value="personas")
    public void setPersonas(List<EntityReference> personas) {
        this.personas = personas;
    }

    public User withPersonas(List<EntityReference> personas) {
        this.personas = personas;
        return this;
    }

    @JsonProperty(value="owns")
    public List<EntityReference> getOwns() {
        return this.owns;
    }

    @JsonProperty(value="owns")
    public void setOwns(List<EntityReference> owns) {
        this.owns = owns;
    }

    public User withOwns(List<EntityReference> owns) {
        this.owns = owns;
        return this;
    }

    @JsonProperty(value="follows")
    public List<EntityReference> getFollows() {
        return this.follows;
    }

    @JsonProperty(value="follows")
    public void setFollows(List<EntityReference> follows) {
        this.follows = follows;
    }

    public User withFollows(List<EntityReference> follows) {
        this.follows = follows;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public User withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public User withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty(value="roles")
    public List<EntityReference> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    public void setRoles(List<EntityReference> roles) {
        this.roles = roles;
    }

    public User withRoles(List<EntityReference> roles) {
        this.roles = roles;
        return this;
    }

    @JsonProperty(value="inheritedRoles")
    public List<EntityReference> getInheritedRoles() {
        return this.inheritedRoles;
    }

    @JsonProperty(value="inheritedRoles")
    public void setInheritedRoles(List<EntityReference> inheritedRoles) {
        this.inheritedRoles = inheritedRoles;
    }

    public User withInheritedRoles(List<EntityReference> inheritedRoles) {
        this.inheritedRoles = inheritedRoles;
        return this;
    }

    @JsonProperty(value="isEmailVerified")
    public Boolean getIsEmailVerified() {
        return this.isEmailVerified;
    }

    @JsonProperty(value="isEmailVerified")
    public void setIsEmailVerified(Boolean isEmailVerified) {
        this.isEmailVerified = isEmailVerified;
    }

    public User withIsEmailVerified(Boolean isEmailVerified) {
        this.isEmailVerified = isEmailVerified;
        return this;
    }

    @JsonProperty(value="domains")
    public List<EntityReference> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    public void setDomains(List<EntityReference> domains) {
        this.domains = domains;
    }

    public User withDomains(List<EntityReference> domains) {
        this.domains = domains;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(User.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("timezone");
        sb.append('=');
        sb.append(this.timezone == null ? "<null>" : this.timezone);
        sb.append(',');
        sb.append("isBot");
        sb.append('=');
        sb.append(this.isBot == null ? "<null>" : this.isBot);
        sb.append(',');
        sb.append("isAdmin");
        sb.append('=');
        sb.append(this.isAdmin == null ? "<null>" : this.isAdmin);
        sb.append(',');
        sb.append("authenticationMechanism");
        sb.append('=');
        sb.append(this.authenticationMechanism == null ? "<null>" : this.authenticationMechanism);
        sb.append(',');
        sb.append("profile");
        sb.append('=');
        sb.append(this.profile == null ? "<null>" : this.profile);
        sb.append(',');
        sb.append("teams");
        sb.append('=');
        sb.append(this.teams == null ? "<null>" : this.teams);
        sb.append(',');
        sb.append("defaultPersona");
        sb.append('=');
        sb.append(this.defaultPersona == null ? "<null>" : this.defaultPersona);
        sb.append(',');
        sb.append("personas");
        sb.append('=');
        sb.append(this.personas == null ? "<null>" : this.personas);
        sb.append(',');
        sb.append("owns");
        sb.append('=');
        sb.append(this.owns == null ? "<null>" : this.owns);
        sb.append(',');
        sb.append("follows");
        sb.append('=');
        sb.append(this.follows == null ? "<null>" : this.follows);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("roles");
        sb.append('=');
        sb.append(this.roles == null ? "<null>" : this.roles);
        sb.append(',');
        sb.append("inheritedRoles");
        sb.append('=');
        sb.append(this.inheritedRoles == null ? "<null>" : this.inheritedRoles);
        sb.append(',');
        sb.append("isEmailVerified");
        sb.append('=');
        sb.append(this.isEmailVerified == null ? "<null>" : this.isEmailVerified);
        sb.append(',');
        sb.append("domains");
        sb.append('=');
        sb.append(this.domains == null ? "<null>" : this.domains);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.isBot == null ? 0 : this.isBot.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.timezone == null ? 0 : this.timezone.hashCode());
        result = result * 31 + (this.roles == null ? 0 : this.roles.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.isEmailVerified == null ? 0 : this.isEmailVerified.hashCode());
        result = result * 31 + (this.owns == null ? 0 : this.owns.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.teams == null ? 0 : this.teams.hashCode());
        result = result * 31 + (this.profile == null ? 0 : this.profile.hashCode());
        result = result * 31 + (this.follows == null ? 0 : this.follows.hashCode());
        result = result * 31 + (this.inheritedRoles == null ? 0 : this.inheritedRoles.hashCode());
        result = result * 31 + (this.domains == null ? 0 : this.domains.hashCode());
        result = result * 31 + (this.isAdmin == null ? 0 : this.isAdmin.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.personas == null ? 0 : this.personas.hashCode());
        result = result * 31 + (this.defaultPersona == null ? 0 : this.defaultPersona.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.authenticationMechanism == null ? 0 : this.authenticationMechanism.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof User)) {
            return false;
        }
        User rhs = (User)other;
        return (this.isBot == rhs.isBot || this.isBot != null && this.isBot.equals(rhs.isBot)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.timezone == rhs.timezone || this.timezone != null && this.timezone.equals(rhs.timezone)) && (this.roles == rhs.roles || this.roles != null && this.roles.equals(rhs.roles)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.isEmailVerified == rhs.isEmailVerified || this.isEmailVerified != null && this.isEmailVerified.equals(rhs.isEmailVerified)) && (this.owns == rhs.owns || this.owns != null && this.owns.equals(rhs.owns)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.teams == rhs.teams || this.teams != null && this.teams.equals(rhs.teams)) && (this.profile == rhs.profile || this.profile != null && this.profile.equals(rhs.profile)) && (this.follows == rhs.follows || this.follows != null && this.follows.equals(rhs.follows)) && (this.inheritedRoles == rhs.inheritedRoles || this.inheritedRoles != null && this.inheritedRoles.equals(rhs.inheritedRoles)) && (this.domains == rhs.domains || this.domains != null && this.domains.equals(rhs.domains)) && (this.isAdmin == rhs.isAdmin || this.isAdmin != null && this.isAdmin.equals(rhs.isAdmin)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.personas == rhs.personas || this.personas != null && this.personas.equals(rhs.personas)) && (this.defaultPersona == rhs.defaultPersona || this.defaultPersona != null && this.defaultPersona.equals(rhs.defaultPersona)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.authenticationMechanism == rhs.authenticationMechanism || this.authenticationMechanism != null && this.authenticationMechanism.equals(rhs.authenticationMechanism));
    }
}

