/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.type.CustomPropertyConfig;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "propertyType", "customPropertyConfig"})
public class CustomProperty {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies an entity.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="propertyType")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference propertyType;
    @JsonProperty(value="customPropertyConfig")
    @JsonPropertyDescription(value="Config to define constraints around CustomProperty")
    @Valid
    private CustomPropertyConfig customPropertyConfig;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CustomProperty withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CustomProperty withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="propertyType")
    public EntityReference getPropertyType() {
        return this.propertyType;
    }

    @JsonProperty(value="propertyType")
    public void setPropertyType(EntityReference propertyType) {
        this.propertyType = propertyType;
    }

    public CustomProperty withPropertyType(EntityReference propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @JsonProperty(value="customPropertyConfig")
    public CustomPropertyConfig getCustomPropertyConfig() {
        return this.customPropertyConfig;
    }

    @JsonProperty(value="customPropertyConfig")
    public void setCustomPropertyConfig(CustomPropertyConfig customPropertyConfig) {
        this.customPropertyConfig = customPropertyConfig;
    }

    public CustomProperty withCustomPropertyConfig(CustomPropertyConfig customPropertyConfig) {
        this.customPropertyConfig = customPropertyConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomProperty.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("propertyType");
        sb.append('=');
        sb.append(this.propertyType == null ? "<null>" : this.propertyType);
        sb.append(',');
        sb.append("customPropertyConfig");
        sb.append('=');
        sb.append(this.customPropertyConfig == null ? "<null>" : this.customPropertyConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.propertyType == null ? 0 : this.propertyType.hashCode());
        result = result * 31 + (this.customPropertyConfig == null ? 0 : this.customPropertyConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CustomProperty)) {
            return false;
        }
        CustomProperty rhs = (CustomProperty)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.propertyType == rhs.propertyType || this.propertyType != null && this.propertyType.equals(rhs.propertyType)) && (this.customPropertyConfig == rhs.customPropertyConfig || this.customPropertyConfig != null && this.customPropertyConfig.equals(rhs.customPropertyConfig));
    }
}

