/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "sourcePythonClass", "appConfig", "appPrivateConfig"})
public class ApplicationPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Pipeline Source Config For Application Pipeline type. Nothing is required.")
    private ApplicationConfigType type = ApplicationConfigType.fromValue("Application");
    @JsonProperty(value="sourcePythonClass")
    @JsonPropertyDescription(value="Source Python Class Name to run the application")
    private String sourcePythonClass;
    @JsonProperty(value="appConfig")
    private Object appConfig;
    @JsonProperty(value="appPrivateConfig")
    private Object appPrivateConfig;

    @JsonProperty(value="type")
    public ApplicationConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ApplicationConfigType type) {
        this.type = type;
    }

    public ApplicationPipeline withType(ApplicationConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="sourcePythonClass")
    public String getSourcePythonClass() {
        return this.sourcePythonClass;
    }

    @JsonProperty(value="sourcePythonClass")
    public void setSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
    }

    public ApplicationPipeline withSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
        return this;
    }

    @JsonProperty(value="appConfig")
    public Object getAppConfig() {
        return this.appConfig;
    }

    @JsonProperty(value="appConfig")
    public void setAppConfig(Object appConfig) {
        this.appConfig = appConfig;
    }

    public ApplicationPipeline withAppConfig(Object appConfig) {
        this.appConfig = appConfig;
        return this;
    }

    @JsonProperty(value="appPrivateConfig")
    public Object getAppPrivateConfig() {
        return this.appPrivateConfig;
    }

    @JsonProperty(value="appPrivateConfig")
    public void setAppPrivateConfig(Object appPrivateConfig) {
        this.appPrivateConfig = appPrivateConfig;
    }

    public ApplicationPipeline withAppPrivateConfig(Object appPrivateConfig) {
        this.appPrivateConfig = appPrivateConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApplicationPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("sourcePythonClass");
        sb.append('=');
        sb.append(this.sourcePythonClass == null ? "<null>" : this.sourcePythonClass);
        sb.append(',');
        sb.append("appConfig");
        sb.append('=');
        sb.append(this.appConfig == null ? "<null>" : this.appConfig);
        sb.append(',');
        sb.append("appPrivateConfig");
        sb.append('=');
        sb.append(this.appPrivateConfig == null ? "<null>" : this.appPrivateConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sourcePythonClass == null ? 0 : this.sourcePythonClass.hashCode());
        result = result * 31 + (this.appConfig == null ? 0 : this.appConfig.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.appPrivateConfig == null ? 0 : this.appPrivateConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApplicationPipeline)) {
            return false;
        }
        ApplicationPipeline rhs = (ApplicationPipeline)other;
        return (this.sourcePythonClass == rhs.sourcePythonClass || this.sourcePythonClass != null && this.sourcePythonClass.equals(rhs.sourcePythonClass)) && (this.appConfig == rhs.appConfig || this.appConfig != null && this.appConfig.equals(rhs.appConfig)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.appPrivateConfig == rhs.appPrivateConfig || this.appPrivateConfig != null && this.appPrivateConfig.equals(rhs.appPrivateConfig));
    }

    public static enum ApplicationConfigType {
        APPLICATION("Application");

        private final String value;
        private static final Map<String, ApplicationConfigType> CONSTANTS;

        private ApplicationConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ApplicationConfigType fromValue(String value) {
            ApplicationConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ApplicationConfigType>();
            for (ApplicationConfigType c : ApplicationConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

