/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;
import org.openmetadata.schema.metadataIngestion.Incremental;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "markDeletedTables", "markDeletedStoredProcedures", "includeTables", "includeViews", "includeTags", "includeOwners", "includeStoredProcedures", "includeDDL", "overrideMetadata", "overrideViewLineage", "queryLogDuration", "queryParsingTimeoutLimit", "useFqnForFiltering", "schemaFilterPattern", "tableFilterPattern", "databaseFilterPattern", "threads", "incremental"})
public class DatabaseServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Database Source Config Metadata Pipeline type")
    private DatabaseMetadataConfigType type = DatabaseMetadataConfigType.fromValue("DatabaseMetadata");
    @JsonProperty(value="markDeletedTables")
    @JsonPropertyDescription(value="This is an optional configuration for enabling soft deletion of tables. When this option is enabled, only tables that have been deleted from the source will be soft deleted, and this will apply solely to the schema that is currently being ingested via the pipeline. Any related entities such as test suites or lineage information that were associated with those tables will also be deleted.")
    private Boolean markDeletedTables = true;
    @JsonProperty(value="markDeletedStoredProcedures")
    @JsonPropertyDescription(value="Optional configuration to soft delete stored procedures in OpenMetadata if the source stored procedures are deleted. Also, if the stored procedures is deleted, all the associated entities like lineage, etc., with that stored procedures will be deleted")
    private Boolean markDeletedStoredProcedures = true;
    @JsonProperty(value="includeTables")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching metadata for tables.")
    private Boolean includeTables = true;
    @JsonProperty(value="includeViews")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching metadata for views.")
    private Boolean includeViews = true;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Optional configuration to toggle the tags ingestion.")
    private Boolean includeTags = true;
    @JsonProperty(value="includeOwners")
    @JsonPropertyDescription(value="Set the 'Include Owners' toggle to control whether to include owners to the ingested entity if the owner email matches with a user stored in the OM server as part of metadata ingestion. If the ingested entity already exists and has an owner, the owner will not be overwritten.")
    private Boolean includeOwners = false;
    @JsonProperty(value="includeStoredProcedures")
    @JsonPropertyDescription(value="Optional configuration to toggle the Stored Procedures ingestion.")
    private Boolean includeStoredProcedures = true;
    @JsonProperty(value="includeDDL")
    @JsonPropertyDescription(value="Optional configuration to toggle the DDL Statements ingestion.")
    private Boolean includeDDL = false;
    @JsonProperty(value="overrideMetadata")
    @JsonPropertyDescription(value="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName")
    private Boolean overrideMetadata = false;
    @JsonProperty(value="overrideViewLineage")
    @JsonPropertyDescription(value="Set the 'Override View Lineage' toggle to control whether to override the existing view lineage.")
    private Boolean overrideViewLineage = false;
    @JsonProperty(value="queryLogDuration")
    @JsonPropertyDescription(value="Configuration to tune how far we want to look back in query logs to process Stored Procedures results.")
    private Integer queryLogDuration = 1;
    @JsonProperty(value="queryParsingTimeoutLimit")
    @JsonPropertyDescription(value="Configuration to set the timeout for parsing the query in seconds.")
    private Integer queryParsingTimeoutLimit = 300;
    @JsonProperty(value="useFqnForFiltering")
    @JsonPropertyDescription(value="Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)")
    private Boolean useFqnForFiltering = false;
    @JsonProperty(value="schemaFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern schemaFilterPattern;
    @JsonProperty(value="tableFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern tableFilterPattern;
    @JsonProperty(value="databaseFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern databaseFilterPattern;
    @JsonProperty(value="threads")
    @JsonPropertyDescription(value="Number of Threads to use in order to parallelize Table ingestion.")
    private Integer threads = 1;
    @JsonProperty(value="incremental")
    @JsonPropertyDescription(value="Use incremental Metadata extraction after the first execution. This is commonly done by getting the changes from Audit tables on the supporting databases.")
    @Valid
    private Incremental incremental;

    @JsonProperty(value="type")
    public DatabaseMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DatabaseMetadataConfigType type) {
        this.type = type;
    }

    public DatabaseServiceMetadataPipeline withType(DatabaseMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="markDeletedTables")
    public Boolean getMarkDeletedTables() {
        return this.markDeletedTables;
    }

    @JsonProperty(value="markDeletedTables")
    public void setMarkDeletedTables(Boolean markDeletedTables) {
        this.markDeletedTables = markDeletedTables;
    }

    public DatabaseServiceMetadataPipeline withMarkDeletedTables(Boolean markDeletedTables) {
        this.markDeletedTables = markDeletedTables;
        return this;
    }

    @JsonProperty(value="markDeletedStoredProcedures")
    public Boolean getMarkDeletedStoredProcedures() {
        return this.markDeletedStoredProcedures;
    }

    @JsonProperty(value="markDeletedStoredProcedures")
    public void setMarkDeletedStoredProcedures(Boolean markDeletedStoredProcedures) {
        this.markDeletedStoredProcedures = markDeletedStoredProcedures;
    }

    public DatabaseServiceMetadataPipeline withMarkDeletedStoredProcedures(Boolean markDeletedStoredProcedures) {
        this.markDeletedStoredProcedures = markDeletedStoredProcedures;
        return this;
    }

    @JsonProperty(value="includeTables")
    public Boolean getIncludeTables() {
        return this.includeTables;
    }

    @JsonProperty(value="includeTables")
    public void setIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
    }

    public DatabaseServiceMetadataPipeline withIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
        return this;
    }

    @JsonProperty(value="includeViews")
    public Boolean getIncludeViews() {
        return this.includeViews;
    }

    @JsonProperty(value="includeViews")
    public void setIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
    }

    public DatabaseServiceMetadataPipeline withIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public DatabaseServiceMetadataPipeline withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @JsonProperty(value="includeOwners")
    public Boolean getIncludeOwners() {
        return this.includeOwners;
    }

    @JsonProperty(value="includeOwners")
    public void setIncludeOwners(Boolean includeOwners) {
        this.includeOwners = includeOwners;
    }

    public DatabaseServiceMetadataPipeline withIncludeOwners(Boolean includeOwners) {
        this.includeOwners = includeOwners;
        return this;
    }

    @JsonProperty(value="includeStoredProcedures")
    public Boolean getIncludeStoredProcedures() {
        return this.includeStoredProcedures;
    }

    @JsonProperty(value="includeStoredProcedures")
    public void setIncludeStoredProcedures(Boolean includeStoredProcedures) {
        this.includeStoredProcedures = includeStoredProcedures;
    }

    public DatabaseServiceMetadataPipeline withIncludeStoredProcedures(Boolean includeStoredProcedures) {
        this.includeStoredProcedures = includeStoredProcedures;
        return this;
    }

    @JsonProperty(value="includeDDL")
    public Boolean getIncludeDDL() {
        return this.includeDDL;
    }

    @JsonProperty(value="includeDDL")
    public void setIncludeDDL(Boolean includeDDL) {
        this.includeDDL = includeDDL;
    }

    public DatabaseServiceMetadataPipeline withIncludeDDL(Boolean includeDDL) {
        this.includeDDL = includeDDL;
        return this;
    }

    @JsonProperty(value="overrideMetadata")
    public Boolean getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    public DatabaseServiceMetadataPipeline withOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
        return this;
    }

    @JsonProperty(value="overrideViewLineage")
    public Boolean getOverrideViewLineage() {
        return this.overrideViewLineage;
    }

    @JsonProperty(value="overrideViewLineage")
    public void setOverrideViewLineage(Boolean overrideViewLineage) {
        this.overrideViewLineage = overrideViewLineage;
    }

    public DatabaseServiceMetadataPipeline withOverrideViewLineage(Boolean overrideViewLineage) {
        this.overrideViewLineage = overrideViewLineage;
        return this;
    }

    @JsonProperty(value="queryLogDuration")
    public Integer getQueryLogDuration() {
        return this.queryLogDuration;
    }

    @JsonProperty(value="queryLogDuration")
    public void setQueryLogDuration(Integer queryLogDuration) {
        this.queryLogDuration = queryLogDuration;
    }

    public DatabaseServiceMetadataPipeline withQueryLogDuration(Integer queryLogDuration) {
        this.queryLogDuration = queryLogDuration;
        return this;
    }

    @JsonProperty(value="queryParsingTimeoutLimit")
    public Integer getQueryParsingTimeoutLimit() {
        return this.queryParsingTimeoutLimit;
    }

    @JsonProperty(value="queryParsingTimeoutLimit")
    public void setQueryParsingTimeoutLimit(Integer queryParsingTimeoutLimit) {
        this.queryParsingTimeoutLimit = queryParsingTimeoutLimit;
    }

    public DatabaseServiceMetadataPipeline withQueryParsingTimeoutLimit(Integer queryParsingTimeoutLimit) {
        this.queryParsingTimeoutLimit = queryParsingTimeoutLimit;
        return this;
    }

    @JsonProperty(value="useFqnForFiltering")
    public Boolean getUseFqnForFiltering() {
        return this.useFqnForFiltering;
    }

    @JsonProperty(value="useFqnForFiltering")
    public void setUseFqnForFiltering(Boolean useFqnForFiltering) {
        this.useFqnForFiltering = useFqnForFiltering;
    }

    public DatabaseServiceMetadataPipeline withUseFqnForFiltering(Boolean useFqnForFiltering) {
        this.useFqnForFiltering = useFqnForFiltering;
        return this;
    }

    @JsonProperty(value="schemaFilterPattern")
    public FilterPattern getSchemaFilterPattern() {
        return this.schemaFilterPattern;
    }

    @JsonProperty(value="schemaFilterPattern")
    public void setSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
    }

    public DatabaseServiceMetadataPipeline withSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
        return this;
    }

    @JsonProperty(value="tableFilterPattern")
    public FilterPattern getTableFilterPattern() {
        return this.tableFilterPattern;
    }

    @JsonProperty(value="tableFilterPattern")
    public void setTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
    }

    public DatabaseServiceMetadataPipeline withTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
        return this;
    }

    @JsonProperty(value="databaseFilterPattern")
    public FilterPattern getDatabaseFilterPattern() {
        return this.databaseFilterPattern;
    }

    @JsonProperty(value="databaseFilterPattern")
    public void setDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
    }

    public DatabaseServiceMetadataPipeline withDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
        return this;
    }

    @JsonProperty(value="threads")
    public Integer getThreads() {
        return this.threads;
    }

    @JsonProperty(value="threads")
    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public DatabaseServiceMetadataPipeline withThreads(Integer threads) {
        this.threads = threads;
        return this;
    }

    @JsonProperty(value="incremental")
    public Incremental getIncremental() {
        return this.incremental;
    }

    @JsonProperty(value="incremental")
    public void setIncremental(Incremental incremental) {
        this.incremental = incremental;
    }

    public DatabaseServiceMetadataPipeline withIncremental(Incremental incremental) {
        this.incremental = incremental;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("markDeletedTables");
        sb.append('=');
        sb.append(this.markDeletedTables == null ? "<null>" : this.markDeletedTables);
        sb.append(',');
        sb.append("markDeletedStoredProcedures");
        sb.append('=');
        sb.append(this.markDeletedStoredProcedures == null ? "<null>" : this.markDeletedStoredProcedures);
        sb.append(',');
        sb.append("includeTables");
        sb.append('=');
        sb.append(this.includeTables == null ? "<null>" : this.includeTables);
        sb.append(',');
        sb.append("includeViews");
        sb.append('=');
        sb.append(this.includeViews == null ? "<null>" : this.includeViews);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        sb.append("includeOwners");
        sb.append('=');
        sb.append(this.includeOwners == null ? "<null>" : this.includeOwners);
        sb.append(',');
        sb.append("includeStoredProcedures");
        sb.append('=');
        sb.append(this.includeStoredProcedures == null ? "<null>" : this.includeStoredProcedures);
        sb.append(',');
        sb.append("includeDDL");
        sb.append('=');
        sb.append(this.includeDDL == null ? "<null>" : this.includeDDL);
        sb.append(',');
        sb.append("overrideMetadata");
        sb.append('=');
        sb.append(this.overrideMetadata == null ? "<null>" : this.overrideMetadata);
        sb.append(',');
        sb.append("overrideViewLineage");
        sb.append('=');
        sb.append(this.overrideViewLineage == null ? "<null>" : this.overrideViewLineage);
        sb.append(',');
        sb.append("queryLogDuration");
        sb.append('=');
        sb.append(this.queryLogDuration == null ? "<null>" : this.queryLogDuration);
        sb.append(',');
        sb.append("queryParsingTimeoutLimit");
        sb.append('=');
        sb.append(this.queryParsingTimeoutLimit == null ? "<null>" : this.queryParsingTimeoutLimit);
        sb.append(',');
        sb.append("useFqnForFiltering");
        sb.append('=');
        sb.append(this.useFqnForFiltering == null ? "<null>" : this.useFqnForFiltering);
        sb.append(',');
        sb.append("schemaFilterPattern");
        sb.append('=');
        sb.append(this.schemaFilterPattern == null ? "<null>" : this.schemaFilterPattern);
        sb.append(',');
        sb.append("tableFilterPattern");
        sb.append('=');
        sb.append(this.tableFilterPattern == null ? "<null>" : this.tableFilterPattern);
        sb.append(',');
        sb.append("databaseFilterPattern");
        sb.append('=');
        sb.append(this.databaseFilterPattern == null ? "<null>" : this.databaseFilterPattern);
        sb.append(',');
        sb.append("threads");
        sb.append('=');
        sb.append(this.threads == null ? "<null>" : this.threads);
        sb.append(',');
        sb.append("incremental");
        sb.append('=');
        sb.append(this.incremental == null ? "<null>" : this.incremental);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.includeTables == null ? 0 : this.includeTables.hashCode());
        result = result * 31 + (this.includeViews == null ? 0 : this.includeViews.hashCode());
        result = result * 31 + (this.includeStoredProcedures == null ? 0 : this.includeStoredProcedures.hashCode());
        result = result * 31 + (this.tableFilterPattern == null ? 0 : this.tableFilterPattern.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        result = result * 31 + (this.overrideMetadata == null ? 0 : this.overrideMetadata.hashCode());
        result = result * 31 + (this.includeOwners == null ? 0 : this.includeOwners.hashCode());
        result = result * 31 + (this.useFqnForFiltering == null ? 0 : this.useFqnForFiltering.hashCode());
        result = result * 31 + (this.databaseFilterPattern == null ? 0 : this.databaseFilterPattern.hashCode());
        result = result * 31 + (this.threads == null ? 0 : this.threads.hashCode());
        result = result * 31 + (this.incremental == null ? 0 : this.incremental.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.markDeletedStoredProcedures == null ? 0 : this.markDeletedStoredProcedures.hashCode());
        result = result * 31 + (this.markDeletedTables == null ? 0 : this.markDeletedTables.hashCode());
        result = result * 31 + (this.queryLogDuration == null ? 0 : this.queryLogDuration.hashCode());
        result = result * 31 + (this.schemaFilterPattern == null ? 0 : this.schemaFilterPattern.hashCode());
        result = result * 31 + (this.queryParsingTimeoutLimit == null ? 0 : this.queryParsingTimeoutLimit.hashCode());
        result = result * 31 + (this.overrideViewLineage == null ? 0 : this.overrideViewLineage.hashCode());
        result = result * 31 + (this.includeDDL == null ? 0 : this.includeDDL.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabaseServiceMetadataPipeline)) {
            return false;
        }
        DatabaseServiceMetadataPipeline rhs = (DatabaseServiceMetadataPipeline)other;
        return (this.includeTables == rhs.includeTables || this.includeTables != null && this.includeTables.equals(rhs.includeTables)) && (this.includeViews == rhs.includeViews || this.includeViews != null && this.includeViews.equals(rhs.includeViews)) && (this.includeStoredProcedures == rhs.includeStoredProcedures || this.includeStoredProcedures != null && this.includeStoredProcedures.equals(rhs.includeStoredProcedures)) && (this.tableFilterPattern == rhs.tableFilterPattern || this.tableFilterPattern != null && this.tableFilterPattern.equals(rhs.tableFilterPattern)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags)) && (this.overrideMetadata == rhs.overrideMetadata || this.overrideMetadata != null && this.overrideMetadata.equals(rhs.overrideMetadata)) && (this.includeOwners == rhs.includeOwners || this.includeOwners != null && this.includeOwners.equals(rhs.includeOwners)) && (this.useFqnForFiltering == rhs.useFqnForFiltering || this.useFqnForFiltering != null && this.useFqnForFiltering.equals(rhs.useFqnForFiltering)) && (this.databaseFilterPattern == rhs.databaseFilterPattern || this.databaseFilterPattern != null && this.databaseFilterPattern.equals(rhs.databaseFilterPattern)) && (this.threads == rhs.threads || this.threads != null && this.threads.equals(rhs.threads)) && (this.incremental == rhs.incremental || this.incremental != null && this.incremental.equals(rhs.incremental)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.markDeletedStoredProcedures == rhs.markDeletedStoredProcedures || this.markDeletedStoredProcedures != null && this.markDeletedStoredProcedures.equals(rhs.markDeletedStoredProcedures)) && (this.markDeletedTables == rhs.markDeletedTables || this.markDeletedTables != null && this.markDeletedTables.equals(rhs.markDeletedTables)) && (this.queryLogDuration == rhs.queryLogDuration || this.queryLogDuration != null && this.queryLogDuration.equals(rhs.queryLogDuration)) && (this.schemaFilterPattern == rhs.schemaFilterPattern || this.schemaFilterPattern != null && this.schemaFilterPattern.equals(rhs.schemaFilterPattern)) && (this.queryParsingTimeoutLimit == rhs.queryParsingTimeoutLimit || this.queryParsingTimeoutLimit != null && this.queryParsingTimeoutLimit.equals(rhs.queryParsingTimeoutLimit)) && (this.overrideViewLineage == rhs.overrideViewLineage || this.overrideViewLineage != null && this.overrideViewLineage.equals(rhs.overrideViewLineage)) && (this.includeDDL == rhs.includeDDL || this.includeDDL != null && this.includeDDL.equals(rhs.includeDDL));
    }

    public static enum DatabaseMetadataConfigType {
        DATABASE_METADATA("DatabaseMetadata");

        private final String value;
        private static final Map<String, DatabaseMetadataConfigType> CONSTANTS;

        private DatabaseMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseMetadataConfigType fromValue(String value) {
            DatabaseMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DatabaseMetadataConfigType>();
            for (DatabaseMetadataConfigType c : DatabaseMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

