/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;
import org.openmetadata.schema.type.TableProfilerConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "schemaFilterPattern", "tableFilterPattern", "databaseFilterPattern", "includeViews", "useFqnForFiltering", "generateSampleData", "computeMetrics", "processPiiSensitive", "confidence", "profileSampleType", "profileSample", "sampleDataCount", "threadCount", "timeoutSeconds"})
public class DatabaseServiceProfilerPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Profiler Source Config Pipeline type")
    private ProfilerConfigType type = ProfilerConfigType.fromValue("Profiler");
    @JsonProperty(value="schemaFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern schemaFilterPattern;
    @JsonProperty(value="tableFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern tableFilterPattern;
    @JsonProperty(value="databaseFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern databaseFilterPattern;
    @JsonProperty(value="includeViews")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching metadata for views.")
    private Boolean includeViews = true;
    @JsonProperty(value="useFqnForFiltering")
    @JsonPropertyDescription(value="Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)")
    private Boolean useFqnForFiltering = false;
    @JsonProperty(value="generateSampleData")
    @JsonPropertyDescription(value="Option to turn on/off generating sample data. If enabled, profiler will ingest sample data for each table.")
    private Boolean generateSampleData = true;
    @JsonProperty(value="computeMetrics")
    @JsonPropertyDescription(value="Option to turn on/off computing profiler metrics.")
    private Boolean computeMetrics = true;
    @JsonProperty(value="processPiiSensitive")
    @JsonPropertyDescription(value="Optional configuration to automatically tag columns that might contain sensitive information")
    private Boolean processPiiSensitive = false;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Set the Confidence value for which you want the column to be tagged as PII. Confidence value ranges from 0 to 100. A higher number will yield less false positives but more false negatives. A lower number will yield more false positives but less false negatives.")
    private Double confidence = 80.0;
    @JsonProperty(value="profileSampleType")
    @JsonPropertyDescription(value="Type of Profile Sample (percentage or rows)")
    private TableProfilerConfig.ProfileSampleType profileSampleType = TableProfilerConfig.ProfileSampleType.fromValue("PERCENTAGE");
    @JsonProperty(value="profileSample")
    @JsonPropertyDescription(value="Percentage of data or no. of rows used to compute the profiler metrics and run data quality tests")
    private Double profileSample = null;
    @JsonProperty(value="sampleDataCount")
    @JsonPropertyDescription(value="Number of sample rows to ingest when 'Generate Sample Data' is enabled")
    private Integer sampleDataCount = 50;
    @JsonProperty(value="threadCount")
    @JsonPropertyDescription(value="Number of threads to use during metric computations")
    private Double threadCount = 5.0;
    @JsonProperty(value="timeoutSeconds")
    @JsonPropertyDescription(value="Profiler Timeout in Seconds")
    private Integer timeoutSeconds = 43200;

    @JsonProperty(value="type")
    public ProfilerConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ProfilerConfigType type) {
        this.type = type;
    }

    public DatabaseServiceProfilerPipeline withType(ProfilerConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="schemaFilterPattern")
    public FilterPattern getSchemaFilterPattern() {
        return this.schemaFilterPattern;
    }

    @JsonProperty(value="schemaFilterPattern")
    public void setSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
    }

    public DatabaseServiceProfilerPipeline withSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
        return this;
    }

    @JsonProperty(value="tableFilterPattern")
    public FilterPattern getTableFilterPattern() {
        return this.tableFilterPattern;
    }

    @JsonProperty(value="tableFilterPattern")
    public void setTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
    }

    public DatabaseServiceProfilerPipeline withTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
        return this;
    }

    @JsonProperty(value="databaseFilterPattern")
    public FilterPattern getDatabaseFilterPattern() {
        return this.databaseFilterPattern;
    }

    @JsonProperty(value="databaseFilterPattern")
    public void setDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
    }

    public DatabaseServiceProfilerPipeline withDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
        return this;
    }

    @JsonProperty(value="includeViews")
    public Boolean getIncludeViews() {
        return this.includeViews;
    }

    @JsonProperty(value="includeViews")
    public void setIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
    }

    public DatabaseServiceProfilerPipeline withIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
        return this;
    }

    @JsonProperty(value="useFqnForFiltering")
    public Boolean getUseFqnForFiltering() {
        return this.useFqnForFiltering;
    }

    @JsonProperty(value="useFqnForFiltering")
    public void setUseFqnForFiltering(Boolean useFqnForFiltering) {
        this.useFqnForFiltering = useFqnForFiltering;
    }

    public DatabaseServiceProfilerPipeline withUseFqnForFiltering(Boolean useFqnForFiltering) {
        this.useFqnForFiltering = useFqnForFiltering;
        return this;
    }

    @JsonProperty(value="generateSampleData")
    public Boolean getGenerateSampleData() {
        return this.generateSampleData;
    }

    @JsonProperty(value="generateSampleData")
    public void setGenerateSampleData(Boolean generateSampleData) {
        this.generateSampleData = generateSampleData;
    }

    public DatabaseServiceProfilerPipeline withGenerateSampleData(Boolean generateSampleData) {
        this.generateSampleData = generateSampleData;
        return this;
    }

    @JsonProperty(value="computeMetrics")
    public Boolean getComputeMetrics() {
        return this.computeMetrics;
    }

    @JsonProperty(value="computeMetrics")
    public void setComputeMetrics(Boolean computeMetrics) {
        this.computeMetrics = computeMetrics;
    }

    public DatabaseServiceProfilerPipeline withComputeMetrics(Boolean computeMetrics) {
        this.computeMetrics = computeMetrics;
        return this;
    }

    @JsonProperty(value="processPiiSensitive")
    public Boolean getProcessPiiSensitive() {
        return this.processPiiSensitive;
    }

    @JsonProperty(value="processPiiSensitive")
    public void setProcessPiiSensitive(Boolean processPiiSensitive) {
        this.processPiiSensitive = processPiiSensitive;
    }

    public DatabaseServiceProfilerPipeline withProcessPiiSensitive(Boolean processPiiSensitive) {
        this.processPiiSensitive = processPiiSensitive;
        return this;
    }

    @JsonProperty(value="confidence")
    public Double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Double confidence) {
        this.confidence = confidence;
    }

    public DatabaseServiceProfilerPipeline withConfidence(Double confidence) {
        this.confidence = confidence;
        return this;
    }

    @JsonProperty(value="profileSampleType")
    public TableProfilerConfig.ProfileSampleType getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    public void setProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public DatabaseServiceProfilerPipeline withProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @JsonProperty(value="profileSample")
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    public void setProfileSample(Double profileSample) {
        this.profileSample = profileSample;
    }

    public DatabaseServiceProfilerPipeline withProfileSample(Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @JsonProperty(value="sampleDataCount")
    public Integer getSampleDataCount() {
        return this.sampleDataCount;
    }

    @JsonProperty(value="sampleDataCount")
    public void setSampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
    }

    public DatabaseServiceProfilerPipeline withSampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
        return this;
    }

    @JsonProperty(value="threadCount")
    public Double getThreadCount() {
        return this.threadCount;
    }

    @JsonProperty(value="threadCount")
    public void setThreadCount(Double threadCount) {
        this.threadCount = threadCount;
    }

    public DatabaseServiceProfilerPipeline withThreadCount(Double threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @JsonProperty(value="timeoutSeconds")
    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public DatabaseServiceProfilerPipeline withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseServiceProfilerPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("schemaFilterPattern");
        sb.append('=');
        sb.append(this.schemaFilterPattern == null ? "<null>" : this.schemaFilterPattern);
        sb.append(',');
        sb.append("tableFilterPattern");
        sb.append('=');
        sb.append(this.tableFilterPattern == null ? "<null>" : this.tableFilterPattern);
        sb.append(',');
        sb.append("databaseFilterPattern");
        sb.append('=');
        sb.append(this.databaseFilterPattern == null ? "<null>" : this.databaseFilterPattern);
        sb.append(',');
        sb.append("includeViews");
        sb.append('=');
        sb.append(this.includeViews == null ? "<null>" : this.includeViews);
        sb.append(',');
        sb.append("useFqnForFiltering");
        sb.append('=');
        sb.append(this.useFqnForFiltering == null ? "<null>" : this.useFqnForFiltering);
        sb.append(',');
        sb.append("generateSampleData");
        sb.append('=');
        sb.append(this.generateSampleData == null ? "<null>" : this.generateSampleData);
        sb.append(',');
        sb.append("computeMetrics");
        sb.append('=');
        sb.append(this.computeMetrics == null ? "<null>" : this.computeMetrics);
        sb.append(',');
        sb.append("processPiiSensitive");
        sb.append('=');
        sb.append(this.processPiiSensitive == null ? "<null>" : this.processPiiSensitive);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("profileSampleType");
        sb.append('=');
        sb.append(this.profileSampleType == null ? "<null>" : this.profileSampleType);
        sb.append(',');
        sb.append("profileSample");
        sb.append('=');
        sb.append(this.profileSample == null ? "<null>" : this.profileSample);
        sb.append(',');
        sb.append("sampleDataCount");
        sb.append('=');
        sb.append(this.sampleDataCount == null ? "<null>" : this.sampleDataCount);
        sb.append(',');
        sb.append("threadCount");
        sb.append('=');
        sb.append(this.threadCount == null ? "<null>" : this.threadCount);
        sb.append(',');
        sb.append("timeoutSeconds");
        sb.append('=');
        sb.append(this.timeoutSeconds == null ? "<null>" : this.timeoutSeconds);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.tableFilterPattern == null ? 0 : this.tableFilterPattern.hashCode());
        result = result * 31 + (this.includeViews == null ? 0 : this.includeViews.hashCode());
        result = result * 31 + (this.generateSampleData == null ? 0 : this.generateSampleData.hashCode());
        result = result * 31 + (this.profileSampleType == null ? 0 : this.profileSampleType.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.databaseFilterPattern == null ? 0 : this.databaseFilterPattern.hashCode());
        result = result * 31 + (this.useFqnForFiltering == null ? 0 : this.useFqnForFiltering.hashCode());
        result = result * 31 + (this.threadCount == null ? 0 : this.threadCount.hashCode());
        result = result * 31 + (this.processPiiSensitive == null ? 0 : this.processPiiSensitive.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.computeMetrics == null ? 0 : this.computeMetrics.hashCode());
        result = result * 31 + (this.schemaFilterPattern == null ? 0 : this.schemaFilterPattern.hashCode());
        result = result * 31 + (this.sampleDataCount == null ? 0 : this.sampleDataCount.hashCode());
        result = result * 31 + (this.timeoutSeconds == null ? 0 : this.timeoutSeconds.hashCode());
        result = result * 31 + (this.profileSample == null ? 0 : this.profileSample.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabaseServiceProfilerPipeline)) {
            return false;
        }
        DatabaseServiceProfilerPipeline rhs = (DatabaseServiceProfilerPipeline)other;
        return (this.tableFilterPattern == rhs.tableFilterPattern || this.tableFilterPattern != null && this.tableFilterPattern.equals(rhs.tableFilterPattern)) && (this.includeViews == rhs.includeViews || this.includeViews != null && this.includeViews.equals(rhs.includeViews)) && (this.generateSampleData == rhs.generateSampleData || this.generateSampleData != null && this.generateSampleData.equals(rhs.generateSampleData)) && (this.profileSampleType == rhs.profileSampleType || this.profileSampleType != null && this.profileSampleType.equals((Object)rhs.profileSampleType)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals(rhs.confidence)) && (this.databaseFilterPattern == rhs.databaseFilterPattern || this.databaseFilterPattern != null && this.databaseFilterPattern.equals(rhs.databaseFilterPattern)) && (this.useFqnForFiltering == rhs.useFqnForFiltering || this.useFqnForFiltering != null && this.useFqnForFiltering.equals(rhs.useFqnForFiltering)) && (this.threadCount == rhs.threadCount || this.threadCount != null && this.threadCount.equals(rhs.threadCount)) && (this.processPiiSensitive == rhs.processPiiSensitive || this.processPiiSensitive != null && this.processPiiSensitive.equals(rhs.processPiiSensitive)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.computeMetrics == rhs.computeMetrics || this.computeMetrics != null && this.computeMetrics.equals(rhs.computeMetrics)) && (this.schemaFilterPattern == rhs.schemaFilterPattern || this.schemaFilterPattern != null && this.schemaFilterPattern.equals(rhs.schemaFilterPattern)) && (this.sampleDataCount == rhs.sampleDataCount || this.sampleDataCount != null && this.sampleDataCount.equals(rhs.sampleDataCount)) && (this.timeoutSeconds == rhs.timeoutSeconds || this.timeoutSeconds != null && this.timeoutSeconds.equals(rhs.timeoutSeconds)) && (this.profileSample == rhs.profileSample || this.profileSample != null && this.profileSample.equals(rhs.profileSample));
    }

    public static enum ProfilerConfigType {
        PROFILER("Profiler");

        private final String value;
        private static final Map<String, ProfilerConfigType> CONSTANTS;

        private ProfilerConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProfilerConfigType fromValue(String value) {
            ProfilerConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ProfilerConfigType>();
            for (ProfilerConfigType c : ProfilerConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

