/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "queryLogDuration", "queryLogFilePath", "resultLimit", "parsingTimeoutLimit", "filterCondition", "schemaFilterPattern", "tableFilterPattern", "databaseFilterPattern"})
public class DatabaseServiceQueryLineagePipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Database Source Config Usage Pipeline type")
    private DatabaseLineageConfigType type = DatabaseLineageConfigType.fromValue("DatabaseLineage");
    @JsonProperty(value="queryLogDuration")
    @JsonPropertyDescription(value="Configuration to tune how far we want to look back in query logs to process lineage data.")
    private Integer queryLogDuration = 1;
    @JsonProperty(value="queryLogFilePath")
    @JsonPropertyDescription(value="Configuration to set the file path for query logs")
    private String queryLogFilePath;
    @JsonProperty(value="resultLimit")
    @JsonPropertyDescription(value="Configuration to set the limit for query logs")
    private Integer resultLimit = 1000;
    @JsonProperty(value="parsingTimeoutLimit")
    @JsonPropertyDescription(value="Configuration to set the timeout for parsing the query in seconds.")
    private Integer parsingTimeoutLimit = 300;
    @JsonProperty(value="filterCondition")
    @JsonPropertyDescription(value="Configuration the condition to filter the query history.")
    private String filterCondition;
    @JsonProperty(value="schemaFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern schemaFilterPattern;
    @JsonProperty(value="tableFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern tableFilterPattern;
    @JsonProperty(value="databaseFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern databaseFilterPattern;

    @JsonProperty(value="type")
    public DatabaseLineageConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DatabaseLineageConfigType type) {
        this.type = type;
    }

    public DatabaseServiceQueryLineagePipeline withType(DatabaseLineageConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="queryLogDuration")
    public Integer getQueryLogDuration() {
        return this.queryLogDuration;
    }

    @JsonProperty(value="queryLogDuration")
    public void setQueryLogDuration(Integer queryLogDuration) {
        this.queryLogDuration = queryLogDuration;
    }

    public DatabaseServiceQueryLineagePipeline withQueryLogDuration(Integer queryLogDuration) {
        this.queryLogDuration = queryLogDuration;
        return this;
    }

    @JsonProperty(value="queryLogFilePath")
    public String getQueryLogFilePath() {
        return this.queryLogFilePath;
    }

    @JsonProperty(value="queryLogFilePath")
    public void setQueryLogFilePath(String queryLogFilePath) {
        this.queryLogFilePath = queryLogFilePath;
    }

    public DatabaseServiceQueryLineagePipeline withQueryLogFilePath(String queryLogFilePath) {
        this.queryLogFilePath = queryLogFilePath;
        return this;
    }

    @JsonProperty(value="resultLimit")
    public Integer getResultLimit() {
        return this.resultLimit;
    }

    @JsonProperty(value="resultLimit")
    public void setResultLimit(Integer resultLimit) {
        this.resultLimit = resultLimit;
    }

    public DatabaseServiceQueryLineagePipeline withResultLimit(Integer resultLimit) {
        this.resultLimit = resultLimit;
        return this;
    }

    @JsonProperty(value="parsingTimeoutLimit")
    public Integer getParsingTimeoutLimit() {
        return this.parsingTimeoutLimit;
    }

    @JsonProperty(value="parsingTimeoutLimit")
    public void setParsingTimeoutLimit(Integer parsingTimeoutLimit) {
        this.parsingTimeoutLimit = parsingTimeoutLimit;
    }

    public DatabaseServiceQueryLineagePipeline withParsingTimeoutLimit(Integer parsingTimeoutLimit) {
        this.parsingTimeoutLimit = parsingTimeoutLimit;
        return this;
    }

    @JsonProperty(value="filterCondition")
    public String getFilterCondition() {
        return this.filterCondition;
    }

    @JsonProperty(value="filterCondition")
    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public DatabaseServiceQueryLineagePipeline withFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
        return this;
    }

    @JsonProperty(value="schemaFilterPattern")
    public FilterPattern getSchemaFilterPattern() {
        return this.schemaFilterPattern;
    }

    @JsonProperty(value="schemaFilterPattern")
    public void setSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
    }

    public DatabaseServiceQueryLineagePipeline withSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
        return this;
    }

    @JsonProperty(value="tableFilterPattern")
    public FilterPattern getTableFilterPattern() {
        return this.tableFilterPattern;
    }

    @JsonProperty(value="tableFilterPattern")
    public void setTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
    }

    public DatabaseServiceQueryLineagePipeline withTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
        return this;
    }

    @JsonProperty(value="databaseFilterPattern")
    public FilterPattern getDatabaseFilterPattern() {
        return this.databaseFilterPattern;
    }

    @JsonProperty(value="databaseFilterPattern")
    public void setDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
    }

    public DatabaseServiceQueryLineagePipeline withDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseServiceQueryLineagePipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("queryLogDuration");
        sb.append('=');
        sb.append(this.queryLogDuration == null ? "<null>" : this.queryLogDuration);
        sb.append(',');
        sb.append("queryLogFilePath");
        sb.append('=');
        sb.append(this.queryLogFilePath == null ? "<null>" : this.queryLogFilePath);
        sb.append(',');
        sb.append("resultLimit");
        sb.append('=');
        sb.append(this.resultLimit == null ? "<null>" : this.resultLimit);
        sb.append(',');
        sb.append("parsingTimeoutLimit");
        sb.append('=');
        sb.append(this.parsingTimeoutLimit == null ? "<null>" : this.parsingTimeoutLimit);
        sb.append(',');
        sb.append("filterCondition");
        sb.append('=');
        sb.append(this.filterCondition == null ? "<null>" : this.filterCondition);
        sb.append(',');
        sb.append("schemaFilterPattern");
        sb.append('=');
        sb.append(this.schemaFilterPattern == null ? "<null>" : this.schemaFilterPattern);
        sb.append(',');
        sb.append("tableFilterPattern");
        sb.append('=');
        sb.append(this.tableFilterPattern == null ? "<null>" : this.tableFilterPattern);
        sb.append(',');
        sb.append("databaseFilterPattern");
        sb.append('=');
        sb.append(this.databaseFilterPattern == null ? "<null>" : this.databaseFilterPattern);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.parsingTimeoutLimit == null ? 0 : this.parsingTimeoutLimit.hashCode());
        result = result * 31 + (this.tableFilterPattern == null ? 0 : this.tableFilterPattern.hashCode());
        result = result * 31 + (this.resultLimit == null ? 0 : this.resultLimit.hashCode());
        result = result * 31 + (this.schemaFilterPattern == null ? 0 : this.schemaFilterPattern.hashCode());
        result = result * 31 + (this.filterCondition == null ? 0 : this.filterCondition.hashCode());
        result = result * 31 + (this.databaseFilterPattern == null ? 0 : this.databaseFilterPattern.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.queryLogFilePath == null ? 0 : this.queryLogFilePath.hashCode());
        result = result * 31 + (this.queryLogDuration == null ? 0 : this.queryLogDuration.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabaseServiceQueryLineagePipeline)) {
            return false;
        }
        DatabaseServiceQueryLineagePipeline rhs = (DatabaseServiceQueryLineagePipeline)other;
        return (this.parsingTimeoutLimit == rhs.parsingTimeoutLimit || this.parsingTimeoutLimit != null && this.parsingTimeoutLimit.equals(rhs.parsingTimeoutLimit)) && (this.tableFilterPattern == rhs.tableFilterPattern || this.tableFilterPattern != null && this.tableFilterPattern.equals(rhs.tableFilterPattern)) && (this.resultLimit == rhs.resultLimit || this.resultLimit != null && this.resultLimit.equals(rhs.resultLimit)) && (this.schemaFilterPattern == rhs.schemaFilterPattern || this.schemaFilterPattern != null && this.schemaFilterPattern.equals(rhs.schemaFilterPattern)) && (this.filterCondition == rhs.filterCondition || this.filterCondition != null && this.filterCondition.equals(rhs.filterCondition)) && (this.databaseFilterPattern == rhs.databaseFilterPattern || this.databaseFilterPattern != null && this.databaseFilterPattern.equals(rhs.databaseFilterPattern)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.queryLogFilePath == rhs.queryLogFilePath || this.queryLogFilePath != null && this.queryLogFilePath.equals(rhs.queryLogFilePath)) && (this.queryLogDuration == rhs.queryLogDuration || this.queryLogDuration != null && this.queryLogDuration.equals(rhs.queryLogDuration));
    }

    public static enum DatabaseLineageConfigType {
        DATABASE_LINEAGE("DatabaseLineage");

        private final String value;
        private static final Map<String, DatabaseLineageConfigType> CONSTANTS;

        private DatabaseLineageConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseLineageConfigType fromValue(String value) {
            DatabaseLineageConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DatabaseLineageConfigType>();
            for (DatabaseLineageConfigType c : DatabaseLineageConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

