/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "queryLogDuration", "stageFileLocation", "filterCondition", "resultLimit", "queryLogFilePath"})
public class DatabaseServiceQueryUsagePipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Database Source Config Usage Pipeline type")
    private DatabaseUsageConfigType type = DatabaseUsageConfigType.fromValue("DatabaseUsage");
    @JsonProperty(value="queryLogDuration")
    @JsonPropertyDescription(value="Configuration to tune how far we want to look back in query logs to process usage data.")
    private Integer queryLogDuration = 1;
    @JsonProperty(value="stageFileLocation")
    @JsonPropertyDescription(value="Temporary file name to store the query logs before processing. Absolute file path required.")
    private String stageFileLocation = "/tmp/query_log";
    @JsonProperty(value="filterCondition")
    @JsonPropertyDescription(value="Configuration the condition to filter the query history.")
    private String filterCondition;
    @JsonProperty(value="resultLimit")
    @JsonPropertyDescription(value="Configuration to set the limit for query logs")
    private Integer resultLimit = 1000;
    @JsonProperty(value="queryLogFilePath")
    @JsonPropertyDescription(value="Configuration to set the file path for query logs")
    private String queryLogFilePath;

    @JsonProperty(value="type")
    public DatabaseUsageConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DatabaseUsageConfigType type) {
        this.type = type;
    }

    public DatabaseServiceQueryUsagePipeline withType(DatabaseUsageConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="queryLogDuration")
    public Integer getQueryLogDuration() {
        return this.queryLogDuration;
    }

    @JsonProperty(value="queryLogDuration")
    public void setQueryLogDuration(Integer queryLogDuration) {
        this.queryLogDuration = queryLogDuration;
    }

    public DatabaseServiceQueryUsagePipeline withQueryLogDuration(Integer queryLogDuration) {
        this.queryLogDuration = queryLogDuration;
        return this;
    }

    @JsonProperty(value="stageFileLocation")
    public String getStageFileLocation() {
        return this.stageFileLocation;
    }

    @JsonProperty(value="stageFileLocation")
    public void setStageFileLocation(String stageFileLocation) {
        this.stageFileLocation = stageFileLocation;
    }

    public DatabaseServiceQueryUsagePipeline withStageFileLocation(String stageFileLocation) {
        this.stageFileLocation = stageFileLocation;
        return this;
    }

    @JsonProperty(value="filterCondition")
    public String getFilterCondition() {
        return this.filterCondition;
    }

    @JsonProperty(value="filterCondition")
    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public DatabaseServiceQueryUsagePipeline withFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
        return this;
    }

    @JsonProperty(value="resultLimit")
    public Integer getResultLimit() {
        return this.resultLimit;
    }

    @JsonProperty(value="resultLimit")
    public void setResultLimit(Integer resultLimit) {
        this.resultLimit = resultLimit;
    }

    public DatabaseServiceQueryUsagePipeline withResultLimit(Integer resultLimit) {
        this.resultLimit = resultLimit;
        return this;
    }

    @JsonProperty(value="queryLogFilePath")
    public String getQueryLogFilePath() {
        return this.queryLogFilePath;
    }

    @JsonProperty(value="queryLogFilePath")
    public void setQueryLogFilePath(String queryLogFilePath) {
        this.queryLogFilePath = queryLogFilePath;
    }

    public DatabaseServiceQueryUsagePipeline withQueryLogFilePath(String queryLogFilePath) {
        this.queryLogFilePath = queryLogFilePath;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseServiceQueryUsagePipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("queryLogDuration");
        sb.append('=');
        sb.append(this.queryLogDuration == null ? "<null>" : this.queryLogDuration);
        sb.append(',');
        sb.append("stageFileLocation");
        sb.append('=');
        sb.append(this.stageFileLocation == null ? "<null>" : this.stageFileLocation);
        sb.append(',');
        sb.append("filterCondition");
        sb.append('=');
        sb.append(this.filterCondition == null ? "<null>" : this.filterCondition);
        sb.append(',');
        sb.append("resultLimit");
        sb.append('=');
        sb.append(this.resultLimit == null ? "<null>" : this.resultLimit);
        sb.append(',');
        sb.append("queryLogFilePath");
        sb.append('=');
        sb.append(this.queryLogFilePath == null ? "<null>" : this.queryLogFilePath);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.stageFileLocation == null ? 0 : this.stageFileLocation.hashCode());
        result = result * 31 + (this.resultLimit == null ? 0 : this.resultLimit.hashCode());
        result = result * 31 + (this.filterCondition == null ? 0 : this.filterCondition.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.queryLogFilePath == null ? 0 : this.queryLogFilePath.hashCode());
        result = result * 31 + (this.queryLogDuration == null ? 0 : this.queryLogDuration.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabaseServiceQueryUsagePipeline)) {
            return false;
        }
        DatabaseServiceQueryUsagePipeline rhs = (DatabaseServiceQueryUsagePipeline)other;
        return (this.stageFileLocation == rhs.stageFileLocation || this.stageFileLocation != null && this.stageFileLocation.equals(rhs.stageFileLocation)) && (this.resultLimit == rhs.resultLimit || this.resultLimit != null && this.resultLimit.equals(rhs.resultLimit)) && (this.filterCondition == rhs.filterCondition || this.filterCondition != null && this.filterCondition.equals(rhs.filterCondition)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.queryLogFilePath == rhs.queryLogFilePath || this.queryLogFilePath != null && this.queryLogFilePath.equals(rhs.queryLogFilePath)) && (this.queryLogDuration == rhs.queryLogDuration || this.queryLogDuration != null && this.queryLogDuration.equals(rhs.queryLogDuration));
    }

    public static enum DatabaseUsageConfigType {
        DATABASE_USAGE("DatabaseUsage");

        private final String value;
        private static final Map<String, DatabaseUsageConfigType> CONSTANTS;

        private DatabaseUsageConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseUsageConfigType fromValue(String value) {
            DatabaseUsageConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DatabaseUsageConfigType>();
            for (DatabaseUsageConfigType c : DatabaseUsageConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

