/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "dbtConfigSource", "dbtUpdateDescriptions", "includeTags", "dbtClassificationName", "schemaFilterPattern", "tableFilterPattern", "parsingTimeoutLimit", "databaseFilterPattern"})
public class DbtPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="DBT Config Pipeline type")
    private DbtConfigType type = DbtConfigType.fromValue("DBT");
    @JsonProperty(value="dbtConfigSource")
    @JsonPropertyDescription(value="Available sources to fetch DBT catalog and manifest files.")
    @MaskedField
    @NotNull
    private Object dbtConfigSource;
    @JsonProperty(value="dbtUpdateDescriptions")
    @JsonPropertyDescription(value="Optional configuration to update the description from DBT or not")
    private Boolean dbtUpdateDescriptions = false;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Optional configuration to toggle the tags ingestion.")
    private Boolean includeTags = true;
    @JsonProperty(value="dbtClassificationName")
    @JsonPropertyDescription(value="Custom OpenMetadata Classification name for dbt tags.")
    private String dbtClassificationName = "dbtTags";
    @JsonProperty(value="schemaFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern schemaFilterPattern;
    @JsonProperty(value="tableFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern tableFilterPattern;
    @JsonProperty(value="parsingTimeoutLimit")
    @JsonPropertyDescription(value="Configuration to set the timeout for parsing the query in seconds.")
    private Integer parsingTimeoutLimit = 300;
    @JsonProperty(value="databaseFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern databaseFilterPattern;

    @JsonProperty(value="type")
    public DbtConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DbtConfigType type) {
        this.type = type;
    }

    public DbtPipeline withType(DbtConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="dbtConfigSource")
    @MaskedField
    public Object getDbtConfigSource() {
        return this.dbtConfigSource;
    }

    @JsonProperty(value="dbtConfigSource")
    @MaskedField
    public void setDbtConfigSource(Object dbtConfigSource) {
        this.dbtConfigSource = dbtConfigSource;
    }

    public DbtPipeline withDbtConfigSource(Object dbtConfigSource) {
        this.dbtConfigSource = dbtConfigSource;
        return this;
    }

    @JsonProperty(value="dbtUpdateDescriptions")
    public Boolean getDbtUpdateDescriptions() {
        return this.dbtUpdateDescriptions;
    }

    @JsonProperty(value="dbtUpdateDescriptions")
    public void setDbtUpdateDescriptions(Boolean dbtUpdateDescriptions) {
        this.dbtUpdateDescriptions = dbtUpdateDescriptions;
    }

    public DbtPipeline withDbtUpdateDescriptions(Boolean dbtUpdateDescriptions) {
        this.dbtUpdateDescriptions = dbtUpdateDescriptions;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public DbtPipeline withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @JsonProperty(value="dbtClassificationName")
    public String getDbtClassificationName() {
        return this.dbtClassificationName;
    }

    @JsonProperty(value="dbtClassificationName")
    public void setDbtClassificationName(String dbtClassificationName) {
        this.dbtClassificationName = dbtClassificationName;
    }

    public DbtPipeline withDbtClassificationName(String dbtClassificationName) {
        this.dbtClassificationName = dbtClassificationName;
        return this;
    }

    @JsonProperty(value="schemaFilterPattern")
    public FilterPattern getSchemaFilterPattern() {
        return this.schemaFilterPattern;
    }

    @JsonProperty(value="schemaFilterPattern")
    public void setSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
    }

    public DbtPipeline withSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
        return this;
    }

    @JsonProperty(value="tableFilterPattern")
    public FilterPattern getTableFilterPattern() {
        return this.tableFilterPattern;
    }

    @JsonProperty(value="tableFilterPattern")
    public void setTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
    }

    public DbtPipeline withTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
        return this;
    }

    @JsonProperty(value="parsingTimeoutLimit")
    public Integer getParsingTimeoutLimit() {
        return this.parsingTimeoutLimit;
    }

    @JsonProperty(value="parsingTimeoutLimit")
    public void setParsingTimeoutLimit(Integer parsingTimeoutLimit) {
        this.parsingTimeoutLimit = parsingTimeoutLimit;
    }

    public DbtPipeline withParsingTimeoutLimit(Integer parsingTimeoutLimit) {
        this.parsingTimeoutLimit = parsingTimeoutLimit;
        return this;
    }

    @JsonProperty(value="databaseFilterPattern")
    public FilterPattern getDatabaseFilterPattern() {
        return this.databaseFilterPattern;
    }

    @JsonProperty(value="databaseFilterPattern")
    public void setDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
    }

    public DbtPipeline withDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DbtPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("dbtConfigSource");
        sb.append('=');
        sb.append(this.dbtConfigSource == null ? "<null>" : this.dbtConfigSource);
        sb.append(',');
        sb.append("dbtUpdateDescriptions");
        sb.append('=');
        sb.append(this.dbtUpdateDescriptions == null ? "<null>" : this.dbtUpdateDescriptions);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        sb.append("dbtClassificationName");
        sb.append('=');
        sb.append(this.dbtClassificationName == null ? "<null>" : this.dbtClassificationName);
        sb.append(',');
        sb.append("schemaFilterPattern");
        sb.append('=');
        sb.append(this.schemaFilterPattern == null ? "<null>" : this.schemaFilterPattern);
        sb.append(',');
        sb.append("tableFilterPattern");
        sb.append('=');
        sb.append(this.tableFilterPattern == null ? "<null>" : this.tableFilterPattern);
        sb.append(',');
        sb.append("parsingTimeoutLimit");
        sb.append('=');
        sb.append(this.parsingTimeoutLimit == null ? "<null>" : this.parsingTimeoutLimit);
        sb.append(',');
        sb.append("databaseFilterPattern");
        sb.append('=');
        sb.append(this.databaseFilterPattern == null ? "<null>" : this.databaseFilterPattern);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.tableFilterPattern == null ? 0 : this.tableFilterPattern.hashCode());
        result = result * 31 + (this.parsingTimeoutLimit == null ? 0 : this.parsingTimeoutLimit.hashCode());
        result = result * 31 + (this.schemaFilterPattern == null ? 0 : this.schemaFilterPattern.hashCode());
        result = result * 31 + (this.dbtClassificationName == null ? 0 : this.dbtClassificationName.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        result = result * 31 + (this.dbtUpdateDescriptions == null ? 0 : this.dbtUpdateDescriptions.hashCode());
        result = result * 31 + (this.databaseFilterPattern == null ? 0 : this.databaseFilterPattern.hashCode());
        result = result * 31 + (this.dbtConfigSource == null ? 0 : this.dbtConfigSource.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DbtPipeline)) {
            return false;
        }
        DbtPipeline rhs = (DbtPipeline)other;
        return (this.tableFilterPattern == rhs.tableFilterPattern || this.tableFilterPattern != null && this.tableFilterPattern.equals(rhs.tableFilterPattern)) && (this.parsingTimeoutLimit == rhs.parsingTimeoutLimit || this.parsingTimeoutLimit != null && this.parsingTimeoutLimit.equals(rhs.parsingTimeoutLimit)) && (this.schemaFilterPattern == rhs.schemaFilterPattern || this.schemaFilterPattern != null && this.schemaFilterPattern.equals(rhs.schemaFilterPattern)) && (this.dbtClassificationName == rhs.dbtClassificationName || this.dbtClassificationName != null && this.dbtClassificationName.equals(rhs.dbtClassificationName)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags)) && (this.dbtUpdateDescriptions == rhs.dbtUpdateDescriptions || this.dbtUpdateDescriptions != null && this.dbtUpdateDescriptions.equals(rhs.dbtUpdateDescriptions)) && (this.databaseFilterPattern == rhs.databaseFilterPattern || this.databaseFilterPattern != null && this.databaseFilterPattern.equals(rhs.databaseFilterPattern)) && (this.dbtConfigSource == rhs.dbtConfigSource || this.dbtConfigSource != null && this.dbtConfigSource.equals(rhs.dbtConfigSource)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum DbtConfigType {
        DBT("DBT");

        private final String value;
        private static final Map<String, DbtConfigType> CONSTANTS;

        private DbtConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DbtConfigType fromValue(String value) {
            DbtConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DbtConfigType>();
            for (DbtConfigType c : DbtConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

