/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enabled", "lookbackDays", "safetyMarginDays"})
public class Incremental {
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="If True, enables Metadata Extraction to be incremental")
    @NotNull
    private Boolean enabled = false;
    @JsonProperty(value="lookbackDays")
    @JsonPropertyDescription(value="Number os days to search back for a successful pipeline run. The timestamp of the last found successful pipeline run will be used as a base to search for updated entities.")
    private Integer lookbackDays = 7;
    @JsonProperty(value="safetyMarginDays")
    @JsonPropertyDescription(value="Number of days to add to the last successful pipeline run timestamp to search for updated entities.")
    private Integer safetyMarginDays = 1;

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Incremental withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="lookbackDays")
    public Integer getLookbackDays() {
        return this.lookbackDays;
    }

    @JsonProperty(value="lookbackDays")
    public void setLookbackDays(Integer lookbackDays) {
        this.lookbackDays = lookbackDays;
    }

    public Incremental withLookbackDays(Integer lookbackDays) {
        this.lookbackDays = lookbackDays;
        return this;
    }

    @JsonProperty(value="safetyMarginDays")
    public Integer getSafetyMarginDays() {
        return this.safetyMarginDays;
    }

    @JsonProperty(value="safetyMarginDays")
    public void setSafetyMarginDays(Integer safetyMarginDays) {
        this.safetyMarginDays = safetyMarginDays;
    }

    public Incremental withSafetyMarginDays(Integer safetyMarginDays) {
        this.safetyMarginDays = safetyMarginDays;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Incremental.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("lookbackDays");
        sb.append('=');
        sb.append(this.lookbackDays == null ? "<null>" : this.lookbackDays);
        sb.append(',');
        sb.append("safetyMarginDays");
        sb.append('=');
        sb.append(this.safetyMarginDays == null ? "<null>" : this.safetyMarginDays);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lookbackDays == null ? 0 : this.lookbackDays.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.safetyMarginDays == null ? 0 : this.safetyMarginDays.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Incremental)) {
            return false;
        }
        Incremental rhs = (Incremental)other;
        return (this.lookbackDays == rhs.lookbackDays || this.lookbackDays != null && this.lookbackDays.equals(rhs.lookbackDays)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.safetyMarginDays == rhs.safetyMarginDays || this.safetyMarginDays != null && this.safetyMarginDays.equals(rhs.safetyMarginDays));
    }
}

