/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "topicFilterPattern", "generateSampleData", "markDeletedTopics", "overrideMetadata"})
public class MessagingServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Messaging Source Config Metadata Pipeline type")
    private MessagingMetadataConfigType type = MessagingMetadataConfigType.fromValue("MessagingMetadata");
    @JsonProperty(value="topicFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern topicFilterPattern;
    @JsonProperty(value="generateSampleData")
    @JsonPropertyDescription(value="Option to turn on/off generating sample data during metadata extraction.")
    private Boolean generateSampleData = false;
    @JsonProperty(value="markDeletedTopics")
    @JsonPropertyDescription(value="Optional configuration to soft delete topics in OpenMetadata if the source topics are deleted. Also, if the topic is deleted, all the associated entities like sample data, lineage, etc., with that topic will be deleted")
    private Boolean markDeletedTopics = true;
    @JsonProperty(value="overrideMetadata")
    @JsonPropertyDescription(value="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName")
    private Boolean overrideMetadata = false;

    @JsonProperty(value="type")
    public MessagingMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(MessagingMetadataConfigType type) {
        this.type = type;
    }

    public MessagingServiceMetadataPipeline withType(MessagingMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="topicFilterPattern")
    public FilterPattern getTopicFilterPattern() {
        return this.topicFilterPattern;
    }

    @JsonProperty(value="topicFilterPattern")
    public void setTopicFilterPattern(FilterPattern topicFilterPattern) {
        this.topicFilterPattern = topicFilterPattern;
    }

    public MessagingServiceMetadataPipeline withTopicFilterPattern(FilterPattern topicFilterPattern) {
        this.topicFilterPattern = topicFilterPattern;
        return this;
    }

    @JsonProperty(value="generateSampleData")
    public Boolean getGenerateSampleData() {
        return this.generateSampleData;
    }

    @JsonProperty(value="generateSampleData")
    public void setGenerateSampleData(Boolean generateSampleData) {
        this.generateSampleData = generateSampleData;
    }

    public MessagingServiceMetadataPipeline withGenerateSampleData(Boolean generateSampleData) {
        this.generateSampleData = generateSampleData;
        return this;
    }

    @JsonProperty(value="markDeletedTopics")
    public Boolean getMarkDeletedTopics() {
        return this.markDeletedTopics;
    }

    @JsonProperty(value="markDeletedTopics")
    public void setMarkDeletedTopics(Boolean markDeletedTopics) {
        this.markDeletedTopics = markDeletedTopics;
    }

    public MessagingServiceMetadataPipeline withMarkDeletedTopics(Boolean markDeletedTopics) {
        this.markDeletedTopics = markDeletedTopics;
        return this;
    }

    @JsonProperty(value="overrideMetadata")
    public Boolean getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    public MessagingServiceMetadataPipeline withOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessagingServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("topicFilterPattern");
        sb.append('=');
        sb.append(this.topicFilterPattern == null ? "<null>" : this.topicFilterPattern);
        sb.append(',');
        sb.append("generateSampleData");
        sb.append('=');
        sb.append(this.generateSampleData == null ? "<null>" : this.generateSampleData);
        sb.append(',');
        sb.append("markDeletedTopics");
        sb.append('=');
        sb.append(this.markDeletedTopics == null ? "<null>" : this.markDeletedTopics);
        sb.append(',');
        sb.append("overrideMetadata");
        sb.append('=');
        sb.append(this.overrideMetadata == null ? "<null>" : this.overrideMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.topicFilterPattern == null ? 0 : this.topicFilterPattern.hashCode());
        result = result * 31 + (this.markDeletedTopics == null ? 0 : this.markDeletedTopics.hashCode());
        result = result * 31 + (this.generateSampleData == null ? 0 : this.generateSampleData.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.overrideMetadata == null ? 0 : this.overrideMetadata.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MessagingServiceMetadataPipeline)) {
            return false;
        }
        MessagingServiceMetadataPipeline rhs = (MessagingServiceMetadataPipeline)other;
        return (this.topicFilterPattern == rhs.topicFilterPattern || this.topicFilterPattern != null && this.topicFilterPattern.equals(rhs.topicFilterPattern)) && (this.markDeletedTopics == rhs.markDeletedTopics || this.markDeletedTopics != null && this.markDeletedTopics.equals(rhs.markDeletedTopics)) && (this.generateSampleData == rhs.generateSampleData || this.generateSampleData != null && this.generateSampleData.equals(rhs.generateSampleData)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.overrideMetadata == rhs.overrideMetadata || this.overrideMetadata != null && this.overrideMetadata.equals(rhs.overrideMetadata));
    }

    public static enum MessagingMetadataConfigType {
        MESSAGING_METADATA("MessagingMetadata");

        private final String value;
        private static final Map<String, MessagingMetadataConfigType> CONSTANTS;

        private MessagingMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessagingMetadataConfigType fromValue(String value) {
            MessagingMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MessagingMetadataConfigType>();
            for (MessagingMetadataConfigType c : MessagingMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

