/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.metadataIngestion.WorkflowConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"workflowConfig", "sourcePythonClass", "appConfig", "appPrivateConfig", "ingestionPipelineFQN", "pipelineRunId"})
public class OpenMetadataAppConfig {
    @JsonProperty(value="workflowConfig")
    @JsonPropertyDescription(value="Configuration for the entire Ingestion Workflow.")
    @Valid
    @NotNull
    private WorkflowConfig workflowConfig;
    @JsonProperty(value="sourcePythonClass")
    @JsonPropertyDescription(value="Source Python Class Name to run the application")
    private String sourcePythonClass;
    @JsonProperty(value="appConfig")
    private Object appConfig;
    @JsonProperty(value="appPrivateConfig")
    private Object appPrivateConfig;
    @JsonProperty(value="ingestionPipelineFQN")
    @JsonPropertyDescription(value="Fully qualified name of ingestion pipeline, used to identify the current ingestion pipeline")
    private String ingestionPipelineFQN;
    @JsonProperty(value="pipelineRunId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID pipelineRunId;

    @JsonProperty(value="workflowConfig")
    public WorkflowConfig getWorkflowConfig() {
        return this.workflowConfig;
    }

    @JsonProperty(value="workflowConfig")
    public void setWorkflowConfig(WorkflowConfig workflowConfig) {
        this.workflowConfig = workflowConfig;
    }

    public OpenMetadataAppConfig withWorkflowConfig(WorkflowConfig workflowConfig) {
        this.workflowConfig = workflowConfig;
        return this;
    }

    @JsonProperty(value="sourcePythonClass")
    public String getSourcePythonClass() {
        return this.sourcePythonClass;
    }

    @JsonProperty(value="sourcePythonClass")
    public void setSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
    }

    public OpenMetadataAppConfig withSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
        return this;
    }

    @JsonProperty(value="appConfig")
    public Object getAppConfig() {
        return this.appConfig;
    }

    @JsonProperty(value="appConfig")
    public void setAppConfig(Object appConfig) {
        this.appConfig = appConfig;
    }

    public OpenMetadataAppConfig withAppConfig(Object appConfig) {
        this.appConfig = appConfig;
        return this;
    }

    @JsonProperty(value="appPrivateConfig")
    public Object getAppPrivateConfig() {
        return this.appPrivateConfig;
    }

    @JsonProperty(value="appPrivateConfig")
    public void setAppPrivateConfig(Object appPrivateConfig) {
        this.appPrivateConfig = appPrivateConfig;
    }

    public OpenMetadataAppConfig withAppPrivateConfig(Object appPrivateConfig) {
        this.appPrivateConfig = appPrivateConfig;
        return this;
    }

    @JsonProperty(value="ingestionPipelineFQN")
    public String getIngestionPipelineFQN() {
        return this.ingestionPipelineFQN;
    }

    @JsonProperty(value="ingestionPipelineFQN")
    public void setIngestionPipelineFQN(String ingestionPipelineFQN) {
        this.ingestionPipelineFQN = ingestionPipelineFQN;
    }

    public OpenMetadataAppConfig withIngestionPipelineFQN(String ingestionPipelineFQN) {
        this.ingestionPipelineFQN = ingestionPipelineFQN;
        return this;
    }

    @JsonProperty(value="pipelineRunId")
    public UUID getPipelineRunId() {
        return this.pipelineRunId;
    }

    @JsonProperty(value="pipelineRunId")
    public void setPipelineRunId(UUID pipelineRunId) {
        this.pipelineRunId = pipelineRunId;
    }

    public OpenMetadataAppConfig withPipelineRunId(UUID pipelineRunId) {
        this.pipelineRunId = pipelineRunId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenMetadataAppConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("workflowConfig");
        sb.append('=');
        sb.append(this.workflowConfig == null ? "<null>" : this.workflowConfig);
        sb.append(',');
        sb.append("sourcePythonClass");
        sb.append('=');
        sb.append(this.sourcePythonClass == null ? "<null>" : this.sourcePythonClass);
        sb.append(',');
        sb.append("appConfig");
        sb.append('=');
        sb.append(this.appConfig == null ? "<null>" : this.appConfig);
        sb.append(',');
        sb.append("appPrivateConfig");
        sb.append('=');
        sb.append(this.appPrivateConfig == null ? "<null>" : this.appPrivateConfig);
        sb.append(',');
        sb.append("ingestionPipelineFQN");
        sb.append('=');
        sb.append(this.ingestionPipelineFQN == null ? "<null>" : this.ingestionPipelineFQN);
        sb.append(',');
        sb.append("pipelineRunId");
        sb.append('=');
        sb.append(this.pipelineRunId == null ? "<null>" : this.pipelineRunId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sourcePythonClass == null ? 0 : this.sourcePythonClass.hashCode());
        result = result * 31 + (this.appConfig == null ? 0 : this.appConfig.hashCode());
        result = result * 31 + (this.appPrivateConfig == null ? 0 : this.appPrivateConfig.hashCode());
        result = result * 31 + (this.pipelineRunId == null ? 0 : this.pipelineRunId.hashCode());
        result = result * 31 + (this.workflowConfig == null ? 0 : this.workflowConfig.hashCode());
        result = result * 31 + (this.ingestionPipelineFQN == null ? 0 : this.ingestionPipelineFQN.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenMetadataAppConfig)) {
            return false;
        }
        OpenMetadataAppConfig rhs = (OpenMetadataAppConfig)other;
        return (this.sourcePythonClass == rhs.sourcePythonClass || this.sourcePythonClass != null && this.sourcePythonClass.equals(rhs.sourcePythonClass)) && (this.appConfig == rhs.appConfig || this.appConfig != null && this.appConfig.equals(rhs.appConfig)) && (this.appPrivateConfig == rhs.appPrivateConfig || this.appPrivateConfig != null && this.appPrivateConfig.equals(rhs.appPrivateConfig)) && (this.pipelineRunId == rhs.pipelineRunId || this.pipelineRunId != null && this.pipelineRunId.equals(rhs.pipelineRunId)) && (this.workflowConfig == rhs.workflowConfig || this.workflowConfig != null && this.workflowConfig.equals(rhs.workflowConfig)) && (this.ingestionPipelineFQN == rhs.ingestionPipelineFQN || this.ingestionPipelineFQN != null && this.ingestionPipelineFQN.equals(rhs.ingestionPipelineFQN));
    }
}

