/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "searchIndexFilterPattern", "markDeletedSearchIndexes", "includeSampleData", "sampleSize", "overrideMetadata"})
public class SearchServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Search Source Config Metadata Pipeline type")
    private SearchMetadataConfigType type = SearchMetadataConfigType.fromValue("SearchMetadata");
    @JsonProperty(value="searchIndexFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern searchIndexFilterPattern;
    @JsonProperty(value="markDeletedSearchIndexes")
    @JsonPropertyDescription(value="Optional configuration to soft delete search indexes in OpenMetadata if the source search indexes are deleted. Also, if the search index is deleted, all the associated entities like lineage, etc., with that search index will be deleted")
    private Boolean markDeletedSearchIndexes = true;
    @JsonProperty(value="includeSampleData")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching sample data for search index.")
    private Boolean includeSampleData = true;
    @JsonProperty(value="sampleSize")
    @JsonPropertyDescription(value="No. of records of sample data we want to ingest.")
    private Integer sampleSize = 10;
    @JsonProperty(value="overrideMetadata")
    @JsonPropertyDescription(value="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName")
    private Boolean overrideMetadata = false;

    @JsonProperty(value="type")
    public SearchMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SearchMetadataConfigType type) {
        this.type = type;
    }

    public SearchServiceMetadataPipeline withType(SearchMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="searchIndexFilterPattern")
    public FilterPattern getSearchIndexFilterPattern() {
        return this.searchIndexFilterPattern;
    }

    @JsonProperty(value="searchIndexFilterPattern")
    public void setSearchIndexFilterPattern(FilterPattern searchIndexFilterPattern) {
        this.searchIndexFilterPattern = searchIndexFilterPattern;
    }

    public SearchServiceMetadataPipeline withSearchIndexFilterPattern(FilterPattern searchIndexFilterPattern) {
        this.searchIndexFilterPattern = searchIndexFilterPattern;
        return this;
    }

    @JsonProperty(value="markDeletedSearchIndexes")
    public Boolean getMarkDeletedSearchIndexes() {
        return this.markDeletedSearchIndexes;
    }

    @JsonProperty(value="markDeletedSearchIndexes")
    public void setMarkDeletedSearchIndexes(Boolean markDeletedSearchIndexes) {
        this.markDeletedSearchIndexes = markDeletedSearchIndexes;
    }

    public SearchServiceMetadataPipeline withMarkDeletedSearchIndexes(Boolean markDeletedSearchIndexes) {
        this.markDeletedSearchIndexes = markDeletedSearchIndexes;
        return this;
    }

    @JsonProperty(value="includeSampleData")
    public Boolean getIncludeSampleData() {
        return this.includeSampleData;
    }

    @JsonProperty(value="includeSampleData")
    public void setIncludeSampleData(Boolean includeSampleData) {
        this.includeSampleData = includeSampleData;
    }

    public SearchServiceMetadataPipeline withIncludeSampleData(Boolean includeSampleData) {
        this.includeSampleData = includeSampleData;
        return this;
    }

    @JsonProperty(value="sampleSize")
    public Integer getSampleSize() {
        return this.sampleSize;
    }

    @JsonProperty(value="sampleSize")
    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public SearchServiceMetadataPipeline withSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
        return this;
    }

    @JsonProperty(value="overrideMetadata")
    public Boolean getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    public SearchServiceMetadataPipeline withOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SearchServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("searchIndexFilterPattern");
        sb.append('=');
        sb.append(this.searchIndexFilterPattern == null ? "<null>" : this.searchIndexFilterPattern);
        sb.append(',');
        sb.append("markDeletedSearchIndexes");
        sb.append('=');
        sb.append(this.markDeletedSearchIndexes == null ? "<null>" : this.markDeletedSearchIndexes);
        sb.append(',');
        sb.append("includeSampleData");
        sb.append('=');
        sb.append(this.includeSampleData == null ? "<null>" : this.includeSampleData);
        sb.append(',');
        sb.append("sampleSize");
        sb.append('=');
        sb.append(this.sampleSize == null ? "<null>" : this.sampleSize);
        sb.append(',');
        sb.append("overrideMetadata");
        sb.append('=');
        sb.append(this.overrideMetadata == null ? "<null>" : this.overrideMetadata);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.searchIndexFilterPattern == null ? 0 : this.searchIndexFilterPattern.hashCode());
        result = result * 31 + (this.markDeletedSearchIndexes == null ? 0 : this.markDeletedSearchIndexes.hashCode());
        result = result * 31 + (this.includeSampleData == null ? 0 : this.includeSampleData.hashCode());
        result = result * 31 + (this.overrideMetadata == null ? 0 : this.overrideMetadata.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.sampleSize == null ? 0 : this.sampleSize.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SearchServiceMetadataPipeline)) {
            return false;
        }
        SearchServiceMetadataPipeline rhs = (SearchServiceMetadataPipeline)other;
        return (this.searchIndexFilterPattern == rhs.searchIndexFilterPattern || this.searchIndexFilterPattern != null && this.searchIndexFilterPattern.equals(rhs.searchIndexFilterPattern)) && (this.markDeletedSearchIndexes == rhs.markDeletedSearchIndexes || this.markDeletedSearchIndexes != null && this.markDeletedSearchIndexes.equals(rhs.markDeletedSearchIndexes)) && (this.includeSampleData == rhs.includeSampleData || this.includeSampleData != null && this.includeSampleData.equals(rhs.includeSampleData)) && (this.overrideMetadata == rhs.overrideMetadata || this.overrideMetadata != null && this.overrideMetadata.equals(rhs.overrideMetadata)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.sampleSize == rhs.sampleSize || this.sampleSize != null && this.sampleSize.equals(rhs.sampleSize));
    }

    public static enum SearchMetadataConfigType {
        SEARCH_METADATA("SearchMetadata");

        private final String value;
        private static final Map<String, SearchMetadataConfigType> CONSTANTS;

        private SearchMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SearchMetadataConfigType fromValue(String value) {
            SearchMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SearchMetadataConfigType>();
            for (SearchMetadataConfigType c : SearchMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

