/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "containerFilterPattern", "storageMetadataConfigSource", "markDeletedContainers", "overrideMetadata", "includeTags"})
public class StorageServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Object Store Source Config Metadata Pipeline type")
    private StorageMetadataConfigType type = StorageMetadataConfigType.fromValue("StorageMetadata");
    @JsonProperty(value="containerFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern containerFilterPattern;
    @JsonProperty(value="storageMetadataConfigSource")
    @MaskedField
    private Object storageMetadataConfigSource;
    @JsonProperty(value="markDeletedContainers")
    @JsonPropertyDescription(value="Optional configuration to soft delete containers in OpenMetadata if the source containers are deleted. Also, if the topic is deleted, all the associated entities with that containers will be deleted")
    private Boolean markDeletedContainers = true;
    @JsonProperty(value="overrideMetadata")
    @JsonPropertyDescription(value="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName")
    private Boolean overrideMetadata = false;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Optional configuration to toggle the tags ingestion.")
    private Boolean includeTags = false;

    @JsonProperty(value="type")
    public StorageMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(StorageMetadataConfigType type) {
        this.type = type;
    }

    public StorageServiceMetadataPipeline withType(StorageMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="containerFilterPattern")
    public FilterPattern getContainerFilterPattern() {
        return this.containerFilterPattern;
    }

    @JsonProperty(value="containerFilterPattern")
    public void setContainerFilterPattern(FilterPattern containerFilterPattern) {
        this.containerFilterPattern = containerFilterPattern;
    }

    public StorageServiceMetadataPipeline withContainerFilterPattern(FilterPattern containerFilterPattern) {
        this.containerFilterPattern = containerFilterPattern;
        return this;
    }

    @JsonProperty(value="storageMetadataConfigSource")
    @MaskedField
    public Object getStorageMetadataConfigSource() {
        return this.storageMetadataConfigSource;
    }

    @JsonProperty(value="storageMetadataConfigSource")
    @MaskedField
    public void setStorageMetadataConfigSource(Object storageMetadataConfigSource) {
        this.storageMetadataConfigSource = storageMetadataConfigSource;
    }

    public StorageServiceMetadataPipeline withStorageMetadataConfigSource(Object storageMetadataConfigSource) {
        this.storageMetadataConfigSource = storageMetadataConfigSource;
        return this;
    }

    @JsonProperty(value="markDeletedContainers")
    public Boolean getMarkDeletedContainers() {
        return this.markDeletedContainers;
    }

    @JsonProperty(value="markDeletedContainers")
    public void setMarkDeletedContainers(Boolean markDeletedContainers) {
        this.markDeletedContainers = markDeletedContainers;
    }

    public StorageServiceMetadataPipeline withMarkDeletedContainers(Boolean markDeletedContainers) {
        this.markDeletedContainers = markDeletedContainers;
        return this;
    }

    @JsonProperty(value="overrideMetadata")
    public Boolean getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    public StorageServiceMetadataPipeline withOverrideMetadata(Boolean overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public StorageServiceMetadataPipeline withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("containerFilterPattern");
        sb.append('=');
        sb.append(this.containerFilterPattern == null ? "<null>" : this.containerFilterPattern);
        sb.append(',');
        sb.append("storageMetadataConfigSource");
        sb.append('=');
        sb.append(this.storageMetadataConfigSource == null ? "<null>" : this.storageMetadataConfigSource);
        sb.append(',');
        sb.append("markDeletedContainers");
        sb.append('=');
        sb.append(this.markDeletedContainers == null ? "<null>" : this.markDeletedContainers);
        sb.append(',');
        sb.append("overrideMetadata");
        sb.append('=');
        sb.append(this.overrideMetadata == null ? "<null>" : this.overrideMetadata);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.containerFilterPattern == null ? 0 : this.containerFilterPattern.hashCode());
        result = result * 31 + (this.storageMetadataConfigSource == null ? 0 : this.storageMetadataConfigSource.hashCode());
        result = result * 31 + (this.markDeletedContainers == null ? 0 : this.markDeletedContainers.hashCode());
        result = result * 31 + (this.overrideMetadata == null ? 0 : this.overrideMetadata.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StorageServiceMetadataPipeline)) {
            return false;
        }
        StorageServiceMetadataPipeline rhs = (StorageServiceMetadataPipeline)other;
        return (this.containerFilterPattern == rhs.containerFilterPattern || this.containerFilterPattern != null && this.containerFilterPattern.equals(rhs.containerFilterPattern)) && (this.storageMetadataConfigSource == rhs.storageMetadataConfigSource || this.storageMetadataConfigSource != null && this.storageMetadataConfigSource.equals(rhs.storageMetadataConfigSource)) && (this.markDeletedContainers == rhs.markDeletedContainers || this.markDeletedContainers != null && this.markDeletedContainers.equals(rhs.markDeletedContainers)) && (this.overrideMetadata == rhs.overrideMetadata || this.overrideMetadata != null && this.overrideMetadata.equals(rhs.overrideMetadata)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum StorageMetadataConfigType {
        STORAGE_METADATA("StorageMetadata");

        private final String value;
        private static final Map<String, StorageMetadataConfigType> CONSTANTS;

        private StorageMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static StorageMetadataConfigType fromValue(String value) {
            StorageMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, StorageMetadataConfigType>();
            for (StorageMetadataConfigType c : StorageMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

