/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openmetadata.schema.type.TableProfilerConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "entityFullyQualifiedName", "profileSample", "profileSampleType", "testCases"})
public class TestSuitePipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Pipeline Source Config Metadata Pipeline type")
    @NotNull
    private TestSuiteConfigType type = TestSuiteConfigType.fromValue("TestSuite");
    @JsonProperty(value="entityFullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    @NotNull
    private @Size(min=1, max=3072) @NotNull String entityFullyQualifiedName;
    @JsonProperty(value="profileSample")
    @JsonPropertyDescription(value="Percentage of data or no. of rows we want to execute the profiler and tests on")
    private Double profileSample = null;
    @JsonProperty(value="profileSampleType")
    @JsonPropertyDescription(value="Type of Profile Sample (percentage or rows)")
    private TableProfilerConfig.ProfileSampleType profileSampleType = TableProfilerConfig.ProfileSampleType.fromValue("PERCENTAGE");
    @JsonProperty(value="testCases")
    @JsonPropertyDescription(value="List of test cases to be executed on the entity. If null, all test cases will be executed.")
    @Valid
    private List<String> testCases = null;

    @JsonProperty(value="type")
    public TestSuiteConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TestSuiteConfigType type) {
        this.type = type;
    }

    public TestSuitePipeline withType(TestSuiteConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="entityFullyQualifiedName")
    public String getEntityFullyQualifiedName() {
        return this.entityFullyQualifiedName;
    }

    @JsonProperty(value="entityFullyQualifiedName")
    public void setEntityFullyQualifiedName(String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
    }

    public TestSuitePipeline withEntityFullyQualifiedName(String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
        return this;
    }

    @JsonProperty(value="profileSample")
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    public void setProfileSample(Double profileSample) {
        this.profileSample = profileSample;
    }

    public TestSuitePipeline withProfileSample(Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @JsonProperty(value="profileSampleType")
    public TableProfilerConfig.ProfileSampleType getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    public void setProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public TestSuitePipeline withProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @JsonProperty(value="testCases")
    public List<String> getTestCases() {
        return this.testCases;
    }

    @JsonProperty(value="testCases")
    public void setTestCases(List<String> testCases) {
        this.testCases = testCases;
    }

    public TestSuitePipeline withTestCases(List<String> testCases) {
        this.testCases = testCases;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestSuitePipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("entityFullyQualifiedName");
        sb.append('=');
        sb.append(this.entityFullyQualifiedName == null ? "<null>" : this.entityFullyQualifiedName);
        sb.append(',');
        sb.append("profileSample");
        sb.append('=');
        sb.append(this.profileSample == null ? "<null>" : this.profileSample);
        sb.append(',');
        sb.append("profileSampleType");
        sb.append('=');
        sb.append(this.profileSampleType == null ? "<null>" : this.profileSampleType);
        sb.append(',');
        sb.append("testCases");
        sb.append('=');
        sb.append(this.testCases == null ? "<null>" : this.testCases);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.testCases == null ? 0 : this.testCases.hashCode());
        result = result * 31 + (this.entityFullyQualifiedName == null ? 0 : this.entityFullyQualifiedName.hashCode());
        result = result * 31 + (this.profileSample == null ? 0 : this.profileSample.hashCode());
        result = result * 31 + (this.profileSampleType == null ? 0 : this.profileSampleType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestSuitePipeline)) {
            return false;
        }
        TestSuitePipeline rhs = (TestSuitePipeline)other;
        return (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.testCases == rhs.testCases || this.testCases != null && this.testCases.equals(rhs.testCases)) && (this.entityFullyQualifiedName == rhs.entityFullyQualifiedName || this.entityFullyQualifiedName != null && this.entityFullyQualifiedName.equals(rhs.entityFullyQualifiedName)) && (this.profileSample == rhs.profileSample || this.profileSample != null && this.profileSample.equals(rhs.profileSample)) && (this.profileSampleType == rhs.profileSampleType || this.profileSampleType != null && this.profileSampleType.equals((Object)rhs.profileSampleType));
    }

    public static enum TestSuiteConfigType {
        TEST_SUITE("TestSuite");

        private final String value;
        private static final Map<String, TestSuiteConfigType> CONSTANTS;

        private TestSuiteConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TestSuiteConfigType fromValue(String value) {
            TestSuiteConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TestSuiteConfigType>();
            for (TestSuiteConfigType c : TestSuiteConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

