/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.metadataIngestion.LogLevels;
import org.openmetadata.schema.services.connections.metadata.ComponentConfig;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"loggerLevel", "openMetadataServerConfig", "config"})
public class WorkflowConfig {
    @JsonProperty(value="loggerLevel")
    @JsonPropertyDescription(value="Supported logging levels")
    private LogLevels loggerLevel = LogLevels.fromValue("INFO");
    @JsonProperty(value="openMetadataServerConfig")
    @JsonPropertyDescription(value="OpenMetadata Connection Config")
    @Valid
    @NotNull
    private OpenMetadataConnection openMetadataServerConfig;
    @JsonProperty(value="config")
    @JsonPropertyDescription(value="key/value pairs to pass to workflow component.")
    @Valid
    private ComponentConfig config;

    @JsonProperty(value="loggerLevel")
    public LogLevels getLoggerLevel() {
        return this.loggerLevel;
    }

    @JsonProperty(value="loggerLevel")
    public void setLoggerLevel(LogLevels loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    public WorkflowConfig withLoggerLevel(LogLevels loggerLevel) {
        this.loggerLevel = loggerLevel;
        return this;
    }

    @JsonProperty(value="openMetadataServerConfig")
    public OpenMetadataConnection getOpenMetadataServerConfig() {
        return this.openMetadataServerConfig;
    }

    @JsonProperty(value="openMetadataServerConfig")
    public void setOpenMetadataServerConfig(OpenMetadataConnection openMetadataServerConfig) {
        this.openMetadataServerConfig = openMetadataServerConfig;
    }

    public WorkflowConfig withOpenMetadataServerConfig(OpenMetadataConnection openMetadataServerConfig) {
        this.openMetadataServerConfig = openMetadataServerConfig;
        return this;
    }

    @JsonProperty(value="config")
    public ComponentConfig getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    public void setConfig(ComponentConfig config) {
        this.config = config;
    }

    public WorkflowConfig withConfig(ComponentConfig config) {
        this.config = config;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(WorkflowConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("loggerLevel");
        sb.append('=');
        sb.append(this.loggerLevel == null ? "<null>" : this.loggerLevel);
        sb.append(',');
        sb.append("openMetadataServerConfig");
        sb.append('=');
        sb.append(this.openMetadataServerConfig == null ? "<null>" : this.openMetadataServerConfig);
        sb.append(',');
        sb.append("config");
        sb.append('=');
        sb.append(this.config == null ? "<null>" : this.config);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.loggerLevel == null ? 0 : this.loggerLevel.hashCode());
        result = result * 31 + (this.config == null ? 0 : this.config.hashCode());
        result = result * 31 + (this.openMetadataServerConfig == null ? 0 : this.openMetadataServerConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof WorkflowConfig)) {
            return false;
        }
        WorkflowConfig rhs = (WorkflowConfig)other;
        return (this.loggerLevel == rhs.loggerLevel || this.loggerLevel != null && this.loggerLevel.equals((Object)rhs.loggerLevel)) && (this.config == rhs.config || this.config != null && this.config.equals(rhs.config)) && (this.openMetadataServerConfig == rhs.openMetadataServerConfig || this.openMetadataServerConfig != null && this.openMetadataServerConfig.equals(rhs.openMetadataServerConfig));
    }
}

