/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.dbtconfig;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtPrefixConfig__1;
import org.openmetadata.schema.security.credentials.GCPCredentials;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dbtConfigType", "dbtSecurityConfig", "dbtPrefixConfig"})
public class DbtGCSConfig {
    @JsonProperty(value="dbtConfigType")
    @JsonPropertyDescription(value="dbt Configuration type")
    @NotNull
    private DbtConfigType dbtConfigType = DbtConfigType.fromValue("gcs");
    @JsonProperty(value="dbtSecurityConfig")
    @JsonPropertyDescription(value="GCP credentials configs.")
    @Valid
    @NotNull
    private GCPCredentials dbtSecurityConfig;
    @JsonProperty(value="dbtPrefixConfig")
    @JsonPropertyDescription(value="Details of the bucket where the dbt files are stored")
    @Valid
    private DbtPrefixConfig__1 dbtPrefixConfig;

    @JsonProperty(value="dbtConfigType")
    public DbtConfigType getDbtConfigType() {
        return this.dbtConfigType;
    }

    @JsonProperty(value="dbtConfigType")
    public void setDbtConfigType(DbtConfigType dbtConfigType) {
        this.dbtConfigType = dbtConfigType;
    }

    public DbtGCSConfig withDbtConfigType(DbtConfigType dbtConfigType) {
        this.dbtConfigType = dbtConfigType;
        return this;
    }

    @JsonProperty(value="dbtSecurityConfig")
    public GCPCredentials getDbtSecurityConfig() {
        return this.dbtSecurityConfig;
    }

    @JsonProperty(value="dbtSecurityConfig")
    public void setDbtSecurityConfig(GCPCredentials dbtSecurityConfig) {
        this.dbtSecurityConfig = dbtSecurityConfig;
    }

    public DbtGCSConfig withDbtSecurityConfig(GCPCredentials dbtSecurityConfig) {
        this.dbtSecurityConfig = dbtSecurityConfig;
        return this;
    }

    @JsonProperty(value="dbtPrefixConfig")
    public DbtPrefixConfig__1 getDbtPrefixConfig() {
        return this.dbtPrefixConfig;
    }

    @JsonProperty(value="dbtPrefixConfig")
    public void setDbtPrefixConfig(DbtPrefixConfig__1 dbtPrefixConfig) {
        this.dbtPrefixConfig = dbtPrefixConfig;
    }

    public DbtGCSConfig withDbtPrefixConfig(DbtPrefixConfig__1 dbtPrefixConfig) {
        this.dbtPrefixConfig = dbtPrefixConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DbtGCSConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dbtConfigType");
        sb.append('=');
        sb.append(this.dbtConfigType == null ? "<null>" : this.dbtConfigType);
        sb.append(',');
        sb.append("dbtSecurityConfig");
        sb.append('=');
        sb.append(this.dbtSecurityConfig == null ? "<null>" : this.dbtSecurityConfig);
        sb.append(',');
        sb.append("dbtPrefixConfig");
        sb.append('=');
        sb.append(this.dbtPrefixConfig == null ? "<null>" : this.dbtPrefixConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dbtConfigType == null ? 0 : this.dbtConfigType.hashCode());
        result = result * 31 + (this.dbtPrefixConfig == null ? 0 : this.dbtPrefixConfig.hashCode());
        result = result * 31 + (this.dbtSecurityConfig == null ? 0 : this.dbtSecurityConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DbtGCSConfig)) {
            return false;
        }
        DbtGCSConfig rhs = (DbtGCSConfig)other;
        return (this.dbtConfigType == rhs.dbtConfigType || this.dbtConfigType != null && this.dbtConfigType.equals((Object)rhs.dbtConfigType)) && (this.dbtPrefixConfig == rhs.dbtPrefixConfig || this.dbtPrefixConfig != null && this.dbtPrefixConfig.equals(rhs.dbtPrefixConfig)) && (this.dbtSecurityConfig == rhs.dbtSecurityConfig || this.dbtSecurityConfig != null && this.dbtSecurityConfig.equals(rhs.dbtSecurityConfig));
    }

    public static enum DbtConfigType {
        GCS("gcs");

        private final String value;
        private static final Map<String, DbtConfigType> CONSTANTS;

        private DbtConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DbtConfigType fromValue(String value) {
            DbtConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DbtConfigType>();
            for (DbtConfigType c : DbtConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

