/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.dbtconfig;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dbtConfigType", "dbtCatalogFilePath", "dbtManifestFilePath", "dbtRunResultsFilePath"})
public class DbtLocalConfig {
    @JsonProperty(value="dbtConfigType")
    @JsonPropertyDescription(value="dbt Configuration type")
    @NotNull
    private DbtConfigType dbtConfigType = DbtConfigType.fromValue("local");
    @JsonProperty(value="dbtCatalogFilePath")
    @JsonPropertyDescription(value="DBT catalog file path to extract dbt models with their column schemas.")
    private String dbtCatalogFilePath;
    @JsonProperty(value="dbtManifestFilePath")
    @JsonPropertyDescription(value="DBT manifest file path to extract dbt models and associate with tables.")
    @NotNull
    private String dbtManifestFilePath;
    @JsonProperty(value="dbtRunResultsFilePath")
    @JsonPropertyDescription(value="DBT run results file path to extract the test results information.")
    private String dbtRunResultsFilePath;

    @JsonProperty(value="dbtConfigType")
    public DbtConfigType getDbtConfigType() {
        return this.dbtConfigType;
    }

    @JsonProperty(value="dbtConfigType")
    public void setDbtConfigType(DbtConfigType dbtConfigType) {
        this.dbtConfigType = dbtConfigType;
    }

    public DbtLocalConfig withDbtConfigType(DbtConfigType dbtConfigType) {
        this.dbtConfigType = dbtConfigType;
        return this;
    }

    @JsonProperty(value="dbtCatalogFilePath")
    public String getDbtCatalogFilePath() {
        return this.dbtCatalogFilePath;
    }

    @JsonProperty(value="dbtCatalogFilePath")
    public void setDbtCatalogFilePath(String dbtCatalogFilePath) {
        this.dbtCatalogFilePath = dbtCatalogFilePath;
    }

    public DbtLocalConfig withDbtCatalogFilePath(String dbtCatalogFilePath) {
        this.dbtCatalogFilePath = dbtCatalogFilePath;
        return this;
    }

    @JsonProperty(value="dbtManifestFilePath")
    public String getDbtManifestFilePath() {
        return this.dbtManifestFilePath;
    }

    @JsonProperty(value="dbtManifestFilePath")
    public void setDbtManifestFilePath(String dbtManifestFilePath) {
        this.dbtManifestFilePath = dbtManifestFilePath;
    }

    public DbtLocalConfig withDbtManifestFilePath(String dbtManifestFilePath) {
        this.dbtManifestFilePath = dbtManifestFilePath;
        return this;
    }

    @JsonProperty(value="dbtRunResultsFilePath")
    public String getDbtRunResultsFilePath() {
        return this.dbtRunResultsFilePath;
    }

    @JsonProperty(value="dbtRunResultsFilePath")
    public void setDbtRunResultsFilePath(String dbtRunResultsFilePath) {
        this.dbtRunResultsFilePath = dbtRunResultsFilePath;
    }

    public DbtLocalConfig withDbtRunResultsFilePath(String dbtRunResultsFilePath) {
        this.dbtRunResultsFilePath = dbtRunResultsFilePath;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DbtLocalConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dbtConfigType");
        sb.append('=');
        sb.append(this.dbtConfigType == null ? "<null>" : this.dbtConfigType);
        sb.append(',');
        sb.append("dbtCatalogFilePath");
        sb.append('=');
        sb.append(this.dbtCatalogFilePath == null ? "<null>" : this.dbtCatalogFilePath);
        sb.append(',');
        sb.append("dbtManifestFilePath");
        sb.append('=');
        sb.append(this.dbtManifestFilePath == null ? "<null>" : this.dbtManifestFilePath);
        sb.append(',');
        sb.append("dbtRunResultsFilePath");
        sb.append('=');
        sb.append(this.dbtRunResultsFilePath == null ? "<null>" : this.dbtRunResultsFilePath);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dbtConfigType == null ? 0 : this.dbtConfigType.hashCode());
        result = result * 31 + (this.dbtCatalogFilePath == null ? 0 : this.dbtCatalogFilePath.hashCode());
        result = result * 31 + (this.dbtRunResultsFilePath == null ? 0 : this.dbtRunResultsFilePath.hashCode());
        result = result * 31 + (this.dbtManifestFilePath == null ? 0 : this.dbtManifestFilePath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DbtLocalConfig)) {
            return false;
        }
        DbtLocalConfig rhs = (DbtLocalConfig)other;
        return (this.dbtConfigType == rhs.dbtConfigType || this.dbtConfigType != null && this.dbtConfigType.equals((Object)rhs.dbtConfigType)) && (this.dbtCatalogFilePath == rhs.dbtCatalogFilePath || this.dbtCatalogFilePath != null && this.dbtCatalogFilePath.equals(rhs.dbtCatalogFilePath)) && (this.dbtRunResultsFilePath == rhs.dbtRunResultsFilePath || this.dbtRunResultsFilePath != null && this.dbtRunResultsFilePath.equals(rhs.dbtRunResultsFilePath)) && (this.dbtManifestFilePath == rhs.dbtManifestFilePath || this.dbtManifestFilePath != null && this.dbtManifestFilePath.equals(rhs.dbtManifestFilePath));
    }

    public static enum DbtConfigType {
        LOCAL("local");

        private final String value;
        private static final Map<String, DbtConfigType> CONSTANTS;

        private DbtConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DbtConfigType fromValue(String value) {
            DbtConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DbtConfigType>();
            for (DbtConfigType c : DbtConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

