/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.storage;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.Column;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"containerName", "dataPath", "structureFormat", "separator", "isPartitioned", "partitionColumns"})
public class ManifestMetadataEntry {
    @JsonProperty(value="containerName")
    @JsonPropertyDescription(value="The top-level container name containing the data path to be ingested")
    @NotNull
    private String containerName;
    @JsonProperty(value="dataPath")
    @JsonPropertyDescription(value="The path where the data resides in the container, excluding the bucket name")
    @NotNull
    private String dataPath;
    @JsonProperty(value="structureFormat")
    @JsonPropertyDescription(value="What's the schema format for the container, eg. avro, parquet, csv.")
    private String structureFormat = null;
    @JsonProperty(value="separator")
    @JsonPropertyDescription(value="For delimited files such as CSV, what is the separator being used?")
    private String separator = null;
    @JsonProperty(value="isPartitioned")
    @JsonPropertyDescription(value="Flag indicating whether the container's data is partitioned")
    private Boolean isPartitioned = false;
    @JsonProperty(value="partitionColumns")
    @JsonPropertyDescription(value="What are the partition columns in case the container's data is partitioned")
    @Valid
    private List<Column> partitionColumns = null;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="containerName")
    public String getContainerName() {
        return this.containerName;
    }

    @JsonProperty(value="containerName")
    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public ManifestMetadataEntry withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @JsonProperty(value="dataPath")
    public String getDataPath() {
        return this.dataPath;
    }

    @JsonProperty(value="dataPath")
    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public ManifestMetadataEntry withDataPath(String dataPath) {
        this.dataPath = dataPath;
        return this;
    }

    @JsonProperty(value="structureFormat")
    public String getStructureFormat() {
        return this.structureFormat;
    }

    @JsonProperty(value="structureFormat")
    public void setStructureFormat(String structureFormat) {
        this.structureFormat = structureFormat;
    }

    public ManifestMetadataEntry withStructureFormat(String structureFormat) {
        this.structureFormat = structureFormat;
        return this;
    }

    @JsonProperty(value="separator")
    public String getSeparator() {
        return this.separator;
    }

    @JsonProperty(value="separator")
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public ManifestMetadataEntry withSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    @JsonProperty(value="isPartitioned")
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @JsonProperty(value="isPartitioned")
    public void setIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
    }

    public ManifestMetadataEntry withIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
        return this;
    }

    @JsonProperty(value="partitionColumns")
    public List<Column> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonProperty(value="partitionColumns")
    public void setPartitionColumns(List<Column> partitionColumns) {
        this.partitionColumns = partitionColumns;
    }

    public ManifestMetadataEntry withPartitionColumns(List<Column> partitionColumns) {
        this.partitionColumns = partitionColumns;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ManifestMetadataEntry withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ManifestMetadataEntry.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("containerName");
        sb.append('=');
        sb.append(this.containerName == null ? "<null>" : this.containerName);
        sb.append(',');
        sb.append("dataPath");
        sb.append('=');
        sb.append(this.dataPath == null ? "<null>" : this.dataPath);
        sb.append(',');
        sb.append("structureFormat");
        sb.append('=');
        sb.append(this.structureFormat == null ? "<null>" : this.structureFormat);
        sb.append(',');
        sb.append("separator");
        sb.append('=');
        sb.append(this.separator == null ? "<null>" : this.separator);
        sb.append(',');
        sb.append("isPartitioned");
        sb.append('=');
        sb.append(this.isPartitioned == null ? "<null>" : this.isPartitioned);
        sb.append(',');
        sb.append("partitionColumns");
        sb.append('=');
        sb.append(this.partitionColumns == null ? "<null>" : this.partitionColumns);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.structureFormat == null ? 0 : this.structureFormat.hashCode());
        result = result * 31 + (this.containerName == null ? 0 : this.containerName.hashCode());
        result = result * 31 + (this.partitionColumns == null ? 0 : this.partitionColumns.hashCode());
        result = result * 31 + (this.isPartitioned == null ? 0 : this.isPartitioned.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.separator == null ? 0 : this.separator.hashCode());
        result = result * 31 + (this.dataPath == null ? 0 : this.dataPath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ManifestMetadataEntry)) {
            return false;
        }
        ManifestMetadataEntry rhs = (ManifestMetadataEntry)other;
        return (this.structureFormat == rhs.structureFormat || this.structureFormat != null && this.structureFormat.equals(rhs.structureFormat)) && (this.containerName == rhs.containerName || this.containerName != null && this.containerName.equals(rhs.containerName)) && (this.partitionColumns == rhs.partitionColumns || this.partitionColumns != null && this.partitionColumns.equals(rhs.partitionColumns)) && (this.isPartitioned == rhs.isPartitioned || this.isPartitioned != null && this.isPartitioned.equals(rhs.isPartitioned)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.separator == rhs.separator || this.separator != null && this.separator.equals(rhs.separator)) && (this.dataPath == rhs.dataPath || this.dataPath != null && this.dataPath.equals(rhs.dataPath));
    }
}

