/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.storage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"containerName", "objectPrefix"})
public class StorageMetadataBucketDetails {
    @JsonProperty(value="containerName")
    @JsonPropertyDescription(value="Name of the top level container where the storage metadata file is stored")
    @NotNull
    private String containerName;
    @JsonProperty(value="objectPrefix")
    @JsonPropertyDescription(value="Path of the folder where the storage metadata file is stored. If the file is at the root, you can keep it empty.")
    private String objectPrefix;

    @JsonProperty(value="containerName")
    public String getContainerName() {
        return this.containerName;
    }

    @JsonProperty(value="containerName")
    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public StorageMetadataBucketDetails withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @JsonProperty(value="objectPrefix")
    public String getObjectPrefix() {
        return this.objectPrefix;
    }

    @JsonProperty(value="objectPrefix")
    public void setObjectPrefix(String objectPrefix) {
        this.objectPrefix = objectPrefix;
    }

    public StorageMetadataBucketDetails withObjectPrefix(String objectPrefix) {
        this.objectPrefix = objectPrefix;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageMetadataBucketDetails.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("containerName");
        sb.append('=');
        sb.append(this.containerName == null ? "<null>" : this.containerName);
        sb.append(',');
        sb.append("objectPrefix");
        sb.append('=');
        sb.append(this.objectPrefix == null ? "<null>" : this.objectPrefix);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.objectPrefix == null ? 0 : this.objectPrefix.hashCode());
        result = result * 31 + (this.containerName == null ? 0 : this.containerName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StorageMetadataBucketDetails)) {
            return false;
        }
        StorageMetadataBucketDetails rhs = (StorageMetadataBucketDetails)other;
        return (this.objectPrefix == rhs.objectPrefix || this.objectPrefix != null && this.objectPrefix.equals(rhs.objectPrefix)) && (this.containerName == rhs.containerName || this.containerName != null && this.containerName.equals(rhs.containerName));
    }
}

