/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.storage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.metadataIngestion.storage.StorageMetadataBucketDetails;
import org.openmetadata.schema.security.credentials.AWSCredentials;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"securityConfig", "prefixConfig"})
public class StorageMetadataS3Config {
    @JsonProperty(value="securityConfig")
    @JsonPropertyDescription(value="AWS credentials configs.")
    @Valid
    private AWSCredentials securityConfig;
    @JsonProperty(value="prefixConfig")
    @JsonPropertyDescription(value="Details of the bucket where the storage metadata manifest file is stored")
    @Valid
    @NotNull
    private StorageMetadataBucketDetails prefixConfig;

    @JsonProperty(value="securityConfig")
    public AWSCredentials getSecurityConfig() {
        return this.securityConfig;
    }

    @JsonProperty(value="securityConfig")
    public void setSecurityConfig(AWSCredentials securityConfig) {
        this.securityConfig = securityConfig;
    }

    public StorageMetadataS3Config withSecurityConfig(AWSCredentials securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    @JsonProperty(value="prefixConfig")
    public StorageMetadataBucketDetails getPrefixConfig() {
        return this.prefixConfig;
    }

    @JsonProperty(value="prefixConfig")
    public void setPrefixConfig(StorageMetadataBucketDetails prefixConfig) {
        this.prefixConfig = prefixConfig;
    }

    public StorageMetadataS3Config withPrefixConfig(StorageMetadataBucketDetails prefixConfig) {
        this.prefixConfig = prefixConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageMetadataS3Config.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("securityConfig");
        sb.append('=');
        sb.append(this.securityConfig == null ? "<null>" : this.securityConfig);
        sb.append(',');
        sb.append("prefixConfig");
        sb.append('=');
        sb.append(this.prefixConfig == null ? "<null>" : this.prefixConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.prefixConfig == null ? 0 : this.prefixConfig.hashCode());
        result = result * 31 + (this.securityConfig == null ? 0 : this.securityConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StorageMetadataS3Config)) {
            return false;
        }
        StorageMetadataS3Config rhs = (StorageMetadataS3Config)other;
        return (this.prefixConfig == rhs.prefixConfig || this.prefixConfig != null && this.prefixConfig.equals(rhs.prefixConfig)) && (this.securityConfig == rhs.securityConfig || this.securityConfig != null && this.securityConfig.equals(rhs.securityConfig));
    }
}

