/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.profiler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MetricType {
    MEAN("mean"),
    VALUES_COUNT("valuesCount"),
    COUNT_IN_SET("countInSet"),
    COLUMN_COUNT("columnCount"),
    DISTINCT_COUNT("distinctCount"),
    DISTINCT_PROPORTION("distinctProportion"),
    I_LIKE_COUNT("iLikeCount"),
    LIKE_COUNT("likeCount"),
    NOT_LIKE_COUNT("notLikeCount"),
    REGEX_COUNT("regexCount"),
    NOT_REGEX_COUNT("notRegexCount"),
    MAX("max"),
    MAX_LENGTH("maxLength"),
    MIN("min"),
    MIN_LENGTH("minLength"),
    NULL_COUNT("nullCount"),
    ROW_COUNT("rowCount"),
    STDDEV("stddev"),
    SUM("sum"),
    UNIQUE_COUNT("uniqueCount"),
    UNIQUE_PROPORTION("uniqueProportion"),
    COLUMN_NAMES("columnNames"),
    DUPLICATE_COUNT("duplicateCount"),
    I_LIKE_RATIO("iLikeRatio"),
    LIKE_RATIO("likeRatio"),
    NULL_PROPORTION("nullProportion"),
    INTER_QUARTILE_RANGE("interQuartileRange"),
    NON_PARAMETRIC_SKEW("nonParametricSkew"),
    MEDIAN("median"),
    FIRST_QUARTILE("firstQuartile"),
    THIRD_QUARTILE("thirdQuartile"),
    SYSTEM("system"),
    HISTOGRAM("histogram");

    private final String value;
    private static final Map<String, MetricType> CONSTANTS;

    private MetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MetricType fromValue(String value) {
        MetricType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MetricType>();
        for (MetricType c : MetricType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

