/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "id", "secret", "scope", "discoveryUri", "useNonce", "preferredJwsAlgorithm", "responseType", "disablePkce", "maxClockSkew", "clientAuthenticationMethod", "tokenValidity", "customParams", "tenant", "serverUrl", "callbackUrl"})
public class OidcClientConfig {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="IDP type (Example Google,Azure).")
    private String type;
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Client ID.")
    private String id;
    @JsonProperty(value="secret")
    @JsonPropertyDescription(value="Client Secret.")
    private String secret;
    @JsonProperty(value="scope")
    @JsonPropertyDescription(value="Oidc Request Scopes.")
    private String scope = "openid email profile";
    @JsonProperty(value="discoveryUri")
    @JsonPropertyDescription(value="Discovery Uri for the Client.")
    private String discoveryUri;
    @JsonProperty(value="useNonce")
    @JsonPropertyDescription(value="Use Nonce.")
    private String useNonce = "true";
    @JsonProperty(value="preferredJwsAlgorithm")
    @JsonPropertyDescription(value="Preferred Jws Algorithm.")
    private String preferredJwsAlgorithm = "RS256";
    @JsonProperty(value="responseType")
    @JsonPropertyDescription(value="Auth0 Client Secret Key.")
    private String responseType = "code";
    @JsonProperty(value="disablePkce")
    @JsonPropertyDescription(value="Disable PKCE.")
    private Boolean disablePkce = true;
    @JsonProperty(value="maxClockSkew")
    @JsonPropertyDescription(value="Max Clock Skew")
    private String maxClockSkew;
    @JsonProperty(value="clientAuthenticationMethod")
    @JsonPropertyDescription(value="Client Authentication Method.")
    private ClientAuthenticationMethod clientAuthenticationMethod;
    @JsonProperty(value="tokenValidity")
    @JsonPropertyDescription(value="Validity for the JWT Token created from SAML Response")
    private Integer tokenValidity = 3600;
    @JsonProperty(value="customParams")
    @JsonPropertyDescription(value="Custom Params.")
    @Valid
    private Map<String, String> customParams;
    @JsonProperty(value="tenant")
    @JsonPropertyDescription(value="Tenant in case of Azure.")
    private String tenant;
    @JsonProperty(value="serverUrl")
    @JsonPropertyDescription(value="Server Url.")
    private String serverUrl;
    @JsonProperty(value="callbackUrl")
    @JsonPropertyDescription(value="Callback Url.")
    private String callbackUrl;

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public OidcClientConfig withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public OidcClientConfig withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public OidcClientConfig withSecret(String secret) {
        this.secret = secret;
        return this;
    }

    @JsonProperty(value="scope")
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    public OidcClientConfig withScope(String scope) {
        this.scope = scope;
        return this;
    }

    @JsonProperty(value="discoveryUri")
    public String getDiscoveryUri() {
        return this.discoveryUri;
    }

    @JsonProperty(value="discoveryUri")
    public void setDiscoveryUri(String discoveryUri) {
        this.discoveryUri = discoveryUri;
    }

    public OidcClientConfig withDiscoveryUri(String discoveryUri) {
        this.discoveryUri = discoveryUri;
        return this;
    }

    @JsonProperty(value="useNonce")
    public String getUseNonce() {
        return this.useNonce;
    }

    @JsonProperty(value="useNonce")
    public void setUseNonce(String useNonce) {
        this.useNonce = useNonce;
    }

    public OidcClientConfig withUseNonce(String useNonce) {
        this.useNonce = useNonce;
        return this;
    }

    @JsonProperty(value="preferredJwsAlgorithm")
    public String getPreferredJwsAlgorithm() {
        return this.preferredJwsAlgorithm;
    }

    @JsonProperty(value="preferredJwsAlgorithm")
    public void setPreferredJwsAlgorithm(String preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
    }

    public OidcClientConfig withPreferredJwsAlgorithm(String preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
        return this;
    }

    @JsonProperty(value="responseType")
    public String getResponseType() {
        return this.responseType;
    }

    @JsonProperty(value="responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public OidcClientConfig withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty(value="disablePkce")
    public Boolean getDisablePkce() {
        return this.disablePkce;
    }

    @JsonProperty(value="disablePkce")
    public void setDisablePkce(Boolean disablePkce) {
        this.disablePkce = disablePkce;
    }

    public OidcClientConfig withDisablePkce(Boolean disablePkce) {
        this.disablePkce = disablePkce;
        return this;
    }

    @JsonProperty(value="maxClockSkew")
    public String getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @JsonProperty(value="maxClockSkew")
    public void setMaxClockSkew(String maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public OidcClientConfig withMaxClockSkew(String maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
        return this;
    }

    @JsonProperty(value="clientAuthenticationMethod")
    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    @JsonProperty(value="clientAuthenticationMethod")
    public void setClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public OidcClientConfig withClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
        return this;
    }

    @JsonProperty(value="tokenValidity")
    public Integer getTokenValidity() {
        return this.tokenValidity;
    }

    @JsonProperty(value="tokenValidity")
    public void setTokenValidity(Integer tokenValidity) {
        this.tokenValidity = tokenValidity;
    }

    public OidcClientConfig withTokenValidity(Integer tokenValidity) {
        this.tokenValidity = tokenValidity;
        return this;
    }

    @JsonProperty(value="customParams")
    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    @JsonProperty(value="customParams")
    public void setCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
    }

    public OidcClientConfig withCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
        return this;
    }

    @JsonProperty(value="tenant")
    public String getTenant() {
        return this.tenant;
    }

    @JsonProperty(value="tenant")
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public OidcClientConfig withTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @JsonProperty(value="serverUrl")
    public String getServerUrl() {
        return this.serverUrl;
    }

    @JsonProperty(value="serverUrl")
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public OidcClientConfig withServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @JsonProperty(value="callbackUrl")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callbackUrl")
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public OidcClientConfig withCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OidcClientConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("secret");
        sb.append('=');
        sb.append(this.secret == null ? "<null>" : this.secret);
        sb.append(',');
        sb.append("scope");
        sb.append('=');
        sb.append(this.scope == null ? "<null>" : this.scope);
        sb.append(',');
        sb.append("discoveryUri");
        sb.append('=');
        sb.append(this.discoveryUri == null ? "<null>" : this.discoveryUri);
        sb.append(',');
        sb.append("useNonce");
        sb.append('=');
        sb.append(this.useNonce == null ? "<null>" : this.useNonce);
        sb.append(',');
        sb.append("preferredJwsAlgorithm");
        sb.append('=');
        sb.append(this.preferredJwsAlgorithm == null ? "<null>" : this.preferredJwsAlgorithm);
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(this.responseType == null ? "<null>" : this.responseType);
        sb.append(',');
        sb.append("disablePkce");
        sb.append('=');
        sb.append(this.disablePkce == null ? "<null>" : this.disablePkce);
        sb.append(',');
        sb.append("maxClockSkew");
        sb.append('=');
        sb.append(this.maxClockSkew == null ? "<null>" : this.maxClockSkew);
        sb.append(',');
        sb.append("clientAuthenticationMethod");
        sb.append('=');
        sb.append(this.clientAuthenticationMethod == null ? "<null>" : this.clientAuthenticationMethod);
        sb.append(',');
        sb.append("tokenValidity");
        sb.append('=');
        sb.append(this.tokenValidity == null ? "<null>" : this.tokenValidity);
        sb.append(',');
        sb.append("customParams");
        sb.append('=');
        sb.append(this.customParams == null ? "<null>" : this.customParams);
        sb.append(',');
        sb.append("tenant");
        sb.append('=');
        sb.append(this.tenant == null ? "<null>" : this.tenant);
        sb.append(',');
        sb.append("serverUrl");
        sb.append('=');
        sb.append(this.serverUrl == null ? "<null>" : this.serverUrl);
        sb.append(',');
        sb.append("callbackUrl");
        sb.append('=');
        sb.append(this.callbackUrl == null ? "<null>" : this.callbackUrl);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.customParams == null ? 0 : this.customParams.hashCode());
        result = result * 31 + (this.useNonce == null ? 0 : this.useNonce.hashCode());
        result = result * 31 + (this.tokenValidity == null ? 0 : this.tokenValidity.hashCode());
        result = result * 31 + (this.secret == null ? 0 : this.secret.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.disablePkce == null ? 0 : this.disablePkce.hashCode());
        result = result * 31 + (this.responseType == null ? 0 : this.responseType.hashCode());
        result = result * 31 + (this.preferredJwsAlgorithm == null ? 0 : this.preferredJwsAlgorithm.hashCode());
        result = result * 31 + (this.scope == null ? 0 : this.scope.hashCode());
        result = result * 31 + (this.serverUrl == null ? 0 : this.serverUrl.hashCode());
        result = result * 31 + (this.maxClockSkew == null ? 0 : this.maxClockSkew.hashCode());
        result = result * 31 + (this.callbackUrl == null ? 0 : this.callbackUrl.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.discoveryUri == null ? 0 : this.discoveryUri.hashCode());
        result = result * 31 + (this.clientAuthenticationMethod == null ? 0 : this.clientAuthenticationMethod.hashCode());
        result = result * 31 + (this.tenant == null ? 0 : this.tenant.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OidcClientConfig)) {
            return false;
        }
        OidcClientConfig rhs = (OidcClientConfig)other;
        return (this.customParams == rhs.customParams || this.customParams != null && this.customParams.equals(rhs.customParams)) && (this.useNonce == rhs.useNonce || this.useNonce != null && this.useNonce.equals(rhs.useNonce)) && (this.tokenValidity == rhs.tokenValidity || this.tokenValidity != null && this.tokenValidity.equals(rhs.tokenValidity)) && (this.secret == rhs.secret || this.secret != null && this.secret.equals(rhs.secret)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.disablePkce == rhs.disablePkce || this.disablePkce != null && this.disablePkce.equals(rhs.disablePkce)) && (this.responseType == rhs.responseType || this.responseType != null && this.responseType.equals(rhs.responseType)) && (this.preferredJwsAlgorithm == rhs.preferredJwsAlgorithm || this.preferredJwsAlgorithm != null && this.preferredJwsAlgorithm.equals(rhs.preferredJwsAlgorithm)) && (this.scope == rhs.scope || this.scope != null && this.scope.equals(rhs.scope)) && (this.serverUrl == rhs.serverUrl || this.serverUrl != null && this.serverUrl.equals(rhs.serverUrl)) && (this.maxClockSkew == rhs.maxClockSkew || this.maxClockSkew != null && this.maxClockSkew.equals(rhs.maxClockSkew)) && (this.callbackUrl == rhs.callbackUrl || this.callbackUrl != null && this.callbackUrl.equals(rhs.callbackUrl)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.discoveryUri == rhs.discoveryUri || this.discoveryUri != null && this.discoveryUri.equals(rhs.discoveryUri)) && (this.clientAuthenticationMethod == rhs.clientAuthenticationMethod || this.clientAuthenticationMethod != null && this.clientAuthenticationMethod.equals((Object)rhs.clientAuthenticationMethod)) && (this.tenant == rhs.tenant || this.tenant != null && this.tenant.equals(rhs.tenant));
    }

    public static enum ClientAuthenticationMethod {
        CLIENT_SECRET_BASIC("client_secret_basic"),
        CLIENT_SECRET_POST("client_secret_post"),
        CLIENT_SECRET_JWT("client_secret_jwt"),
        PRIVATE_KEY_JWT("private_key_jwt");

        private final String value;
        private static final Map<String, ClientAuthenticationMethod> CONSTANTS;

        private ClientAuthenticationMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ClientAuthenticationMethod fromValue(String value) {
            ClientAuthenticationMethod constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ClientAuthenticationMethod>();
            for (ClientAuthenticationMethod c : ClientAuthenticationMethod.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

