/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clientId", "orgURL", "privateKey", "email", "scopes"})
public class OktaSSOClientConfig {
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Okta Client ID.")
    @NotNull
    private String clientId;
    @JsonProperty(value="orgURL")
    @JsonPropertyDescription(value="Okta org url.")
    @NotNull
    private String orgURL;
    @JsonProperty(value="privateKey")
    @JsonPropertyDescription(value="Okta Private Key.")
    @PasswordField
    @NotNull
    private String privateKey;
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Okta Service account Email.")
    @NotNull
    private String email;
    @JsonProperty(value="scopes")
    @JsonPropertyDescription(value="Okta client scopes.")
    @Valid
    private List<String> scopes = new ArrayList<String>();

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OktaSSOClientConfig withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="orgURL")
    public String getOrgURL() {
        return this.orgURL;
    }

    @JsonProperty(value="orgURL")
    public void setOrgURL(String orgURL) {
        this.orgURL = orgURL;
    }

    public OktaSSOClientConfig withOrgURL(String orgURL) {
        this.orgURL = orgURL;
        return this;
    }

    @JsonProperty(value="privateKey")
    @PasswordField
    public String getPrivateKey() {
        return this.privateKey;
    }

    @JsonProperty(value="privateKey")
    @PasswordField
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public OktaSSOClientConfig withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public OktaSSOClientConfig withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public OktaSSOClientConfig withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OktaSSOClientConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("orgURL");
        sb.append('=');
        sb.append(this.orgURL == null ? "<null>" : this.orgURL);
        sb.append(',');
        sb.append("privateKey");
        sb.append('=');
        sb.append(this.privateKey == null ? "<null>" : this.privateKey);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("scopes");
        sb.append('=');
        sb.append(this.scopes == null ? "<null>" : this.scopes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.orgURL == null ? 0 : this.orgURL.hashCode());
        result = result * 31 + (this.scopes == null ? 0 : this.scopes.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OktaSSOClientConfig)) {
            return false;
        }
        OktaSSOClientConfig rhs = (OktaSSOClientConfig)other;
        return (this.privateKey == rhs.privateKey || this.privateKey != null && this.privateKey.equals(rhs.privateKey)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.orgURL == rhs.orgURL || this.orgURL != null && this.orgURL.equals(rhs.orgURL)) && (this.scopes == rhs.scopes || this.scopes != null && this.scopes.equals(rhs.scopes)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email));
    }
}

