/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.credentials;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"awsAccessKeyId", "awsSecretAccessKey", "awsRegion", "awsSessionToken", "endPointURL", "profileName", "assumeRoleArn", "assumeRoleSessionName", "assumeRoleSourceIdentity"})
public class AWSCredentials {
    @JsonProperty(value="awsAccessKeyId")
    @JsonPropertyDescription(value="AWS Access key ID.")
    private String awsAccessKeyId;
    @JsonProperty(value="awsSecretAccessKey")
    @JsonPropertyDescription(value="AWS Secret Access Key.")
    @PasswordField
    private String awsSecretAccessKey;
    @JsonProperty(value="awsRegion")
    @JsonPropertyDescription(value="AWS Region")
    @NotNull
    private String awsRegion;
    @JsonProperty(value="awsSessionToken")
    @JsonPropertyDescription(value="AWS Session Token.")
    private String awsSessionToken;
    @JsonProperty(value="endPointURL")
    @JsonPropertyDescription(value="EndPoint URL for the AWS")
    private URI endPointURL;
    @JsonProperty(value="profileName")
    @JsonPropertyDescription(value="The name of a profile to use with the boto session.")
    private String profileName;
    @JsonProperty(value="assumeRoleArn")
    @JsonPropertyDescription(value="The Amazon Resource Name (ARN) of the role to assume. Required Field in case of Assume Role")
    private String assumeRoleArn;
    @JsonProperty(value="assumeRoleSessionName")
    @JsonPropertyDescription(value="An identifier for the assumed role session. Use the role session name to uniquely identify a session when the same role is assumed by different principals or for different reasons. Required Field in case of Assume Role")
    private String assumeRoleSessionName = "OpenMetadataSession";
    @JsonProperty(value="assumeRoleSourceIdentity")
    @JsonPropertyDescription(value="The Amazon Resource Name (ARN) of the role to assume. Optional Field in case of Assume Role")
    private String assumeRoleSourceIdentity;

    @JsonProperty(value="awsAccessKeyId")
    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    @JsonProperty(value="awsAccessKeyId")
    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public AWSCredentials withAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
        return this;
    }

    @JsonProperty(value="awsSecretAccessKey")
    @PasswordField
    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    @JsonProperty(value="awsSecretAccessKey")
    @PasswordField
    public void setAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    public AWSCredentials withAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = awsSecretAccessKey;
        return this;
    }

    @JsonProperty(value="awsRegion")
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @JsonProperty(value="awsRegion")
    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public AWSCredentials withAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    @JsonProperty(value="awsSessionToken")
    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    @JsonProperty(value="awsSessionToken")
    public void setAwsSessionToken(String awsSessionToken) {
        this.awsSessionToken = awsSessionToken;
    }

    public AWSCredentials withAwsSessionToken(String awsSessionToken) {
        this.awsSessionToken = awsSessionToken;
        return this;
    }

    @JsonProperty(value="endPointURL")
    public URI getEndPointURL() {
        return this.endPointURL;
    }

    @JsonProperty(value="endPointURL")
    public void setEndPointURL(URI endPointURL) {
        this.endPointURL = endPointURL;
    }

    public AWSCredentials withEndPointURL(URI endPointURL) {
        this.endPointURL = endPointURL;
        return this;
    }

    @JsonProperty(value="profileName")
    public String getProfileName() {
        return this.profileName;
    }

    @JsonProperty(value="profileName")
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public AWSCredentials withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    @JsonProperty(value="assumeRoleArn")
    public String getAssumeRoleArn() {
        return this.assumeRoleArn;
    }

    @JsonProperty(value="assumeRoleArn")
    public void setAssumeRoleArn(String assumeRoleArn) {
        this.assumeRoleArn = assumeRoleArn;
    }

    public AWSCredentials withAssumeRoleArn(String assumeRoleArn) {
        this.assumeRoleArn = assumeRoleArn;
        return this;
    }

    @JsonProperty(value="assumeRoleSessionName")
    public String getAssumeRoleSessionName() {
        return this.assumeRoleSessionName;
    }

    @JsonProperty(value="assumeRoleSessionName")
    public void setAssumeRoleSessionName(String assumeRoleSessionName) {
        this.assumeRoleSessionName = assumeRoleSessionName;
    }

    public AWSCredentials withAssumeRoleSessionName(String assumeRoleSessionName) {
        this.assumeRoleSessionName = assumeRoleSessionName;
        return this;
    }

    @JsonProperty(value="assumeRoleSourceIdentity")
    public String getAssumeRoleSourceIdentity() {
        return this.assumeRoleSourceIdentity;
    }

    @JsonProperty(value="assumeRoleSourceIdentity")
    public void setAssumeRoleSourceIdentity(String assumeRoleSourceIdentity) {
        this.assumeRoleSourceIdentity = assumeRoleSourceIdentity;
    }

    public AWSCredentials withAssumeRoleSourceIdentity(String assumeRoleSourceIdentity) {
        this.assumeRoleSourceIdentity = assumeRoleSourceIdentity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AWSCredentials.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("awsAccessKeyId");
        sb.append('=');
        sb.append(this.awsAccessKeyId == null ? "<null>" : this.awsAccessKeyId);
        sb.append(',');
        sb.append("awsSecretAccessKey");
        sb.append('=');
        sb.append(this.awsSecretAccessKey == null ? "<null>" : this.awsSecretAccessKey);
        sb.append(',');
        sb.append("awsRegion");
        sb.append('=');
        sb.append(this.awsRegion == null ? "<null>" : this.awsRegion);
        sb.append(',');
        sb.append("awsSessionToken");
        sb.append('=');
        sb.append(this.awsSessionToken == null ? "<null>" : this.awsSessionToken);
        sb.append(',');
        sb.append("endPointURL");
        sb.append('=');
        sb.append(this.endPointURL == null ? "<null>" : this.endPointURL);
        sb.append(',');
        sb.append("profileName");
        sb.append('=');
        sb.append(this.profileName == null ? "<null>" : this.profileName);
        sb.append(',');
        sb.append("assumeRoleArn");
        sb.append('=');
        sb.append(this.assumeRoleArn == null ? "<null>" : this.assumeRoleArn);
        sb.append(',');
        sb.append("assumeRoleSessionName");
        sb.append('=');
        sb.append(this.assumeRoleSessionName == null ? "<null>" : this.assumeRoleSessionName);
        sb.append(',');
        sb.append("assumeRoleSourceIdentity");
        sb.append('=');
        sb.append(this.assumeRoleSourceIdentity == null ? "<null>" : this.assumeRoleSourceIdentity);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.profileName == null ? 0 : this.profileName.hashCode());
        result = result * 31 + (this.awsRegion == null ? 0 : this.awsRegion.hashCode());
        result = result * 31 + (this.assumeRoleSessionName == null ? 0 : this.assumeRoleSessionName.hashCode());
        result = result * 31 + (this.awsAccessKeyId == null ? 0 : this.awsAccessKeyId.hashCode());
        result = result * 31 + (this.assumeRoleArn == null ? 0 : this.assumeRoleArn.hashCode());
        result = result * 31 + (this.assumeRoleSourceIdentity == null ? 0 : this.assumeRoleSourceIdentity.hashCode());
        result = result * 31 + (this.endPointURL == null ? 0 : this.endPointURL.hashCode());
        result = result * 31 + (this.awsSessionToken == null ? 0 : this.awsSessionToken.hashCode());
        result = result * 31 + (this.awsSecretAccessKey == null ? 0 : this.awsSecretAccessKey.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AWSCredentials)) {
            return false;
        }
        AWSCredentials rhs = (AWSCredentials)other;
        return (this.profileName == rhs.profileName || this.profileName != null && this.profileName.equals(rhs.profileName)) && (this.awsRegion == rhs.awsRegion || this.awsRegion != null && this.awsRegion.equals(rhs.awsRegion)) && (this.assumeRoleSessionName == rhs.assumeRoleSessionName || this.assumeRoleSessionName != null && this.assumeRoleSessionName.equals(rhs.assumeRoleSessionName)) && (this.awsAccessKeyId == rhs.awsAccessKeyId || this.awsAccessKeyId != null && this.awsAccessKeyId.equals(rhs.awsAccessKeyId)) && (this.assumeRoleArn == rhs.assumeRoleArn || this.assumeRoleArn != null && this.assumeRoleArn.equals(rhs.assumeRoleArn)) && (this.assumeRoleSourceIdentity == rhs.assumeRoleSourceIdentity || this.assumeRoleSourceIdentity != null && this.assumeRoleSourceIdentity.equals(rhs.assumeRoleSourceIdentity)) && (this.endPointURL == rhs.endPointURL || this.endPointURL != null && this.endPointURL.equals(rhs.endPointURL)) && (this.awsSessionToken == rhs.awsSessionToken || this.awsSessionToken != null && this.awsSessionToken.equals(rhs.awsSessionToken)) && (this.awsSecretAccessKey == rhs.awsSecretAccessKey || this.awsSecretAccessKey != null && this.awsSecretAccessKey.equals(rhs.awsSecretAccessKey));
    }
}

