/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.credentials;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clientId", "clientSecret", "tenantId", "accountName", "vaultName", "scopes"})
public class AzureCredentials {
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Your Service Principal App ID (Client ID)")
    private String clientId;
    @JsonProperty(value="clientSecret")
    @JsonPropertyDescription(value="Your Service Principal Password (Client Secret)")
    @PasswordField
    private String clientSecret;
    @JsonProperty(value="tenantId")
    @JsonPropertyDescription(value="Tenant ID of your Azure Subscription")
    private String tenantId;
    @JsonProperty(value="accountName")
    @JsonPropertyDescription(value="Account Name of your storage account")
    private String accountName;
    @JsonProperty(value="vaultName")
    @JsonPropertyDescription(value="Key Vault Name")
    private String vaultName;
    @JsonProperty(value="scopes")
    @JsonPropertyDescription(value="Scopes to get access token, for e.g. api://6dfX33ab-XXXX-49df-XXXX-3459eX817d3e/.default")
    private String scopes;

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AzureCredentials withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="clientSecret")
    @PasswordField
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @PasswordField
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public AzureCredentials withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public AzureCredentials withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @JsonProperty(value="accountName")
    public String getAccountName() {
        return this.accountName;
    }

    @JsonProperty(value="accountName")
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public AzureCredentials withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @JsonProperty(value="vaultName")
    public String getVaultName() {
        return this.vaultName;
    }

    @JsonProperty(value="vaultName")
    public void setVaultName(String vaultName) {
        this.vaultName = vaultName;
    }

    public AzureCredentials withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    @JsonProperty(value="scopes")
    public String getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public AzureCredentials withScopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AzureCredentials.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("clientSecret");
        sb.append('=');
        sb.append(this.clientSecret == null ? "<null>" : this.clientSecret);
        sb.append(',');
        sb.append("tenantId");
        sb.append('=');
        sb.append(this.tenantId == null ? "<null>" : this.tenantId);
        sb.append(',');
        sb.append("accountName");
        sb.append('=');
        sb.append(this.accountName == null ? "<null>" : this.accountName);
        sb.append(',');
        sb.append("vaultName");
        sb.append('=');
        sb.append(this.vaultName == null ? "<null>" : this.vaultName);
        sb.append(',');
        sb.append("scopes");
        sb.append('=');
        sb.append(this.scopes == null ? "<null>" : this.scopes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.vaultName == null ? 0 : this.vaultName.hashCode());
        result = result * 31 + (this.accountName == null ? 0 : this.accountName.hashCode());
        result = result * 31 + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = result * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = result * 31 + (this.scopes == null ? 0 : this.scopes.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AzureCredentials)) {
            return false;
        }
        AzureCredentials rhs = (AzureCredentials)other;
        return (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.vaultName == rhs.vaultName || this.vaultName != null && this.vaultName.equals(rhs.vaultName)) && (this.accountName == rhs.accountName || this.accountName != null && this.accountName.equals(rhs.accountName)) && (this.tenantId == rhs.tenantId || this.tenantId != null && this.tenantId.equals(rhs.tenantId)) && (this.clientSecret == rhs.clientSecret || this.clientSecret != null && this.clientSecret.equals(rhs.clientSecret)) && (this.scopes == rhs.scopes || this.scopes != null && this.scopes.equals(rhs.scopes));
    }
}

