/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.credentials;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.GCPImpersonateServiceAccountValues;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"gcpConfig", "gcpImpersonateServiceAccount"})
public class GCPCredentials {
    @JsonProperty(value="gcpConfig")
    @JsonPropertyDescription(value="We support two ways of authenticating to GCP i.e via GCP Credentials Values or GCP Credentials Path")
    @NotNull
    private Object gcpConfig;
    @JsonProperty(value="gcpImpersonateServiceAccount")
    @JsonPropertyDescription(value="Pass the values to impersonate a service account of Google Cloud")
    @Valid
    private GCPImpersonateServiceAccountValues gcpImpersonateServiceAccount;

    @JsonProperty(value="gcpConfig")
    public Object getGcpConfig() {
        return this.gcpConfig;
    }

    @JsonProperty(value="gcpConfig")
    public void setGcpConfig(Object gcpConfig) {
        this.gcpConfig = gcpConfig;
    }

    public GCPCredentials withGcpConfig(Object gcpConfig) {
        this.gcpConfig = gcpConfig;
        return this;
    }

    @JsonProperty(value="gcpImpersonateServiceAccount")
    public GCPImpersonateServiceAccountValues getGcpImpersonateServiceAccount() {
        return this.gcpImpersonateServiceAccount;
    }

    @JsonProperty(value="gcpImpersonateServiceAccount")
    public void setGcpImpersonateServiceAccount(GCPImpersonateServiceAccountValues gcpImpersonateServiceAccount) {
        this.gcpImpersonateServiceAccount = gcpImpersonateServiceAccount;
    }

    public GCPCredentials withGcpImpersonateServiceAccount(GCPImpersonateServiceAccountValues gcpImpersonateServiceAccount) {
        this.gcpImpersonateServiceAccount = gcpImpersonateServiceAccount;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GCPCredentials.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("gcpConfig");
        sb.append('=');
        sb.append(this.gcpConfig == null ? "<null>" : this.gcpConfig);
        sb.append(',');
        sb.append("gcpImpersonateServiceAccount");
        sb.append('=');
        sb.append(this.gcpImpersonateServiceAccount == null ? "<null>" : this.gcpImpersonateServiceAccount);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.gcpImpersonateServiceAccount == null ? 0 : this.gcpImpersonateServiceAccount.hashCode());
        result = result * 31 + (this.gcpConfig == null ? 0 : this.gcpConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GCPCredentials)) {
            return false;
        }
        GCPCredentials rhs = (GCPCredentials)other;
        return (this.gcpImpersonateServiceAccount == rhs.gcpImpersonateServiceAccount || this.gcpImpersonateServiceAccount != null && this.gcpImpersonateServiceAccount.equals(rhs.gcpImpersonateServiceAccount)) && (this.gcpConfig == rhs.gcpConfig || this.gcpConfig != null && this.gcpConfig.equals(rhs.gcpConfig));
    }
}

