/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.credentials;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import org.openmetadata.schema.security.credentials.credentialSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "externalType", "audience", "subjectTokenType", "tokenURL", "credentialSource"})
public class GCPExternalAccount {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Google Cloud Platform account type.")
    private String type = "external_account";
    @JsonProperty(value="externalType")
    @JsonPropertyDescription(value="Google Cloud Platform account type.")
    private String externalType = "external_account";
    @JsonProperty(value="audience")
    @JsonPropertyDescription(value="Google Security Token Service audience which contains the resource name for the workload identity pool and the provider identifier in that pool.")
    private String audience;
    @JsonProperty(value="subjectTokenType")
    @JsonPropertyDescription(value="Google Security Token Service subject token type based on the OAuth 2.0 token exchange spec.")
    private String subjectTokenType;
    @JsonProperty(value="tokenURL")
    @JsonPropertyDescription(value="Google Security Token Service token exchange endpoint.")
    private String tokenURL;
    @JsonProperty(value="credentialSource")
    @JsonPropertyDescription(value="This object defines the mechanism used to retrieve the external credential from the local environment so that it can be exchanged for a GCP access token via the STS endpoint")
    @Valid
    private credentialSource credentialSource;

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public GCPExternalAccount withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="externalType")
    public String getExternalType() {
        return this.externalType;
    }

    @JsonProperty(value="externalType")
    public void setExternalType(String externalType) {
        this.externalType = externalType;
    }

    public GCPExternalAccount withExternalType(String externalType) {
        this.externalType = externalType;
        return this;
    }

    @JsonProperty(value="audience")
    public String getAudience() {
        return this.audience;
    }

    @JsonProperty(value="audience")
    public void setAudience(String audience) {
        this.audience = audience;
    }

    public GCPExternalAccount withAudience(String audience) {
        this.audience = audience;
        return this;
    }

    @JsonProperty(value="subjectTokenType")
    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    @JsonProperty(value="subjectTokenType")
    public void setSubjectTokenType(String subjectTokenType) {
        this.subjectTokenType = subjectTokenType;
    }

    public GCPExternalAccount withSubjectTokenType(String subjectTokenType) {
        this.subjectTokenType = subjectTokenType;
        return this;
    }

    @JsonProperty(value="tokenURL")
    public String getTokenURL() {
        return this.tokenURL;
    }

    @JsonProperty(value="tokenURL")
    public void setTokenURL(String tokenURL) {
        this.tokenURL = tokenURL;
    }

    public GCPExternalAccount withTokenURL(String tokenURL) {
        this.tokenURL = tokenURL;
        return this;
    }

    @JsonProperty(value="credentialSource")
    public credentialSource getCredentialSource() {
        return this.credentialSource;
    }

    @JsonProperty(value="credentialSource")
    public void setCredentialSource(credentialSource credentialSource2) {
        this.credentialSource = credentialSource2;
    }

    public GCPExternalAccount withCredentialSource(credentialSource credentialSource2) {
        this.credentialSource = credentialSource2;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GCPExternalAccount.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("externalType");
        sb.append('=');
        sb.append(this.externalType == null ? "<null>" : this.externalType);
        sb.append(',');
        sb.append("audience");
        sb.append('=');
        sb.append(this.audience == null ? "<null>" : this.audience);
        sb.append(',');
        sb.append("subjectTokenType");
        sb.append('=');
        sb.append(this.subjectTokenType == null ? "<null>" : this.subjectTokenType);
        sb.append(',');
        sb.append("tokenURL");
        sb.append('=');
        sb.append(this.tokenURL == null ? "<null>" : this.tokenURL);
        sb.append(',');
        sb.append("credentialSource");
        sb.append('=');
        sb.append(this.credentialSource == null ? "<null>" : this.credentialSource);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.externalType == null ? 0 : this.externalType.hashCode());
        result = result * 31 + (this.audience == null ? 0 : this.audience.hashCode());
        result = result * 31 + (this.subjectTokenType == null ? 0 : this.subjectTokenType.hashCode());
        result = result * 31 + (this.tokenURL == null ? 0 : this.tokenURL.hashCode());
        result = result * 31 + (this.credentialSource == null ? 0 : this.credentialSource.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GCPExternalAccount)) {
            return false;
        }
        GCPExternalAccount rhs = (GCPExternalAccount)other;
        return (this.externalType == rhs.externalType || this.externalType != null && this.externalType.equals(rhs.externalType)) && (this.audience == rhs.audience || this.audience != null && this.audience.equals(rhs.audience)) && (this.subjectTokenType == rhs.subjectTokenType || this.subjectTokenType != null && this.subjectTokenType.equals(rhs.subjectTokenType)) && (this.tokenURL == rhs.tokenURL || this.tokenURL != null && this.tokenURL.equals(rhs.tokenURL)) && (this.credentialSource == rhs.credentialSource || this.credentialSource != null && this.credentialSource.equals(rhs.credentialSource)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type));
    }
}

