/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.credentials;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "projectId", "privateKeyId", "privateKey", "clientEmail", "clientId", "authUri", "tokenUri", "authProviderX509CertUrl", "clientX509CertUrl"})
public class GCPValues {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Google Cloud Platform account type.")
    private String type = "service_account";
    @JsonProperty(value="projectId")
    @JsonPropertyDescription(value="Project ID")
    private Object projectId;
    @JsonProperty(value="privateKeyId")
    @JsonPropertyDescription(value="Google Cloud private key id.")
    private String privateKeyId;
    @JsonProperty(value="privateKey")
    @JsonPropertyDescription(value="Google Cloud private key.")
    @PasswordField
    private String privateKey;
    @JsonProperty(value="clientEmail")
    @JsonPropertyDescription(value="Google Cloud email.")
    private String clientEmail;
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Google Cloud Client ID.")
    private String clientId;
    @JsonProperty(value="authUri")
    @JsonPropertyDescription(value="Google Cloud auth uri.")
    private URI authUri = URI.create("https://accounts.google.com/o/oauth2/auth");
    @JsonProperty(value="tokenUri")
    @JsonPropertyDescription(value="Google Cloud token uri.")
    private URI tokenUri = URI.create("https://oauth2.googleapis.com/token");
    @JsonProperty(value="authProviderX509CertUrl")
    @JsonPropertyDescription(value="Google Cloud auth provider certificate.")
    private URI authProviderX509CertUrl = URI.create("https://www.googleapis.com/oauth2/v1/certs");
    @JsonProperty(value="clientX509CertUrl")
    @JsonPropertyDescription(value="Google Cloud client certificate uri.")
    private URI clientX509CertUrl;

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public GCPValues withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="projectId")
    public Object getProjectId() {
        return this.projectId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(Object projectId) {
        this.projectId = projectId;
    }

    public GCPValues withProjectId(Object projectId) {
        this.projectId = projectId;
        return this;
    }

    @JsonProperty(value="privateKeyId")
    public String getPrivateKeyId() {
        return this.privateKeyId;
    }

    @JsonProperty(value="privateKeyId")
    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public GCPValues withPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
        return this;
    }

    @JsonProperty(value="privateKey")
    @PasswordField
    public String getPrivateKey() {
        return this.privateKey;
    }

    @JsonProperty(value="privateKey")
    @PasswordField
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public GCPValues withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @JsonProperty(value="clientEmail")
    public String getClientEmail() {
        return this.clientEmail;
    }

    @JsonProperty(value="clientEmail")
    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public GCPValues withClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GCPValues withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="authUri")
    public URI getAuthUri() {
        return this.authUri;
    }

    @JsonProperty(value="authUri")
    public void setAuthUri(URI authUri) {
        this.authUri = authUri;
    }

    public GCPValues withAuthUri(URI authUri) {
        this.authUri = authUri;
        return this;
    }

    @JsonProperty(value="tokenUri")
    public URI getTokenUri() {
        return this.tokenUri;
    }

    @JsonProperty(value="tokenUri")
    public void setTokenUri(URI tokenUri) {
        this.tokenUri = tokenUri;
    }

    public GCPValues withTokenUri(URI tokenUri) {
        this.tokenUri = tokenUri;
        return this;
    }

    @JsonProperty(value="authProviderX509CertUrl")
    public URI getAuthProviderX509CertUrl() {
        return this.authProviderX509CertUrl;
    }

    @JsonProperty(value="authProviderX509CertUrl")
    public void setAuthProviderX509CertUrl(URI authProviderX509CertUrl) {
        this.authProviderX509CertUrl = authProviderX509CertUrl;
    }

    public GCPValues withAuthProviderX509CertUrl(URI authProviderX509CertUrl) {
        this.authProviderX509CertUrl = authProviderX509CertUrl;
        return this;
    }

    @JsonProperty(value="clientX509CertUrl")
    public URI getClientX509CertUrl() {
        return this.clientX509CertUrl;
    }

    @JsonProperty(value="clientX509CertUrl")
    public void setClientX509CertUrl(URI clientX509CertUrl) {
        this.clientX509CertUrl = clientX509CertUrl;
    }

    public GCPValues withClientX509CertUrl(URI clientX509CertUrl) {
        this.clientX509CertUrl = clientX509CertUrl;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GCPValues.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("projectId");
        sb.append('=');
        sb.append(this.projectId == null ? "<null>" : this.projectId);
        sb.append(',');
        sb.append("privateKeyId");
        sb.append('=');
        sb.append(this.privateKeyId == null ? "<null>" : this.privateKeyId);
        sb.append(',');
        sb.append("privateKey");
        sb.append('=');
        sb.append(this.privateKey == null ? "<null>" : this.privateKey);
        sb.append(',');
        sb.append("clientEmail");
        sb.append('=');
        sb.append(this.clientEmail == null ? "<null>" : this.clientEmail);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("authUri");
        sb.append('=');
        sb.append(this.authUri == null ? "<null>" : this.authUri);
        sb.append(',');
        sb.append("tokenUri");
        sb.append('=');
        sb.append(this.tokenUri == null ? "<null>" : this.tokenUri);
        sb.append(',');
        sb.append("authProviderX509CertUrl");
        sb.append('=');
        sb.append(this.authProviderX509CertUrl == null ? "<null>" : this.authProviderX509CertUrl);
        sb.append(',');
        sb.append("clientX509CertUrl");
        sb.append('=');
        sb.append(this.clientX509CertUrl == null ? "<null>" : this.clientX509CertUrl);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = result * 31 + (this.authUri == null ? 0 : this.authUri.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.clientEmail == null ? 0 : this.clientEmail.hashCode());
        result = result * 31 + (this.tokenUri == null ? 0 : this.tokenUri.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.authProviderX509CertUrl == null ? 0 : this.authProviderX509CertUrl.hashCode());
        result = result * 31 + (this.clientX509CertUrl == null ? 0 : this.clientX509CertUrl.hashCode());
        result = result * 31 + (this.projectId == null ? 0 : this.projectId.hashCode());
        result = result * 31 + (this.privateKeyId == null ? 0 : this.privateKeyId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GCPValues)) {
            return false;
        }
        GCPValues rhs = (GCPValues)other;
        return (this.privateKey == rhs.privateKey || this.privateKey != null && this.privateKey.equals(rhs.privateKey)) && (this.authUri == rhs.authUri || this.authUri != null && this.authUri.equals(rhs.authUri)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.clientEmail == rhs.clientEmail || this.clientEmail != null && this.clientEmail.equals(rhs.clientEmail)) && (this.tokenUri == rhs.tokenUri || this.tokenUri != null && this.tokenUri.equals(rhs.tokenUri)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.authProviderX509CertUrl == rhs.authProviderX509CertUrl || this.authProviderX509CertUrl != null && this.authProviderX509CertUrl.equals(rhs.authProviderX509CertUrl)) && (this.clientX509CertUrl == rhs.clientX509CertUrl || this.clientX509CertUrl != null && this.clientX509CertUrl.equals(rhs.clientX509CertUrl)) && (this.projectId == rhs.projectId || this.projectId != null && this.projectId.equals(rhs.projectId)) && (this.privateKeyId == rhs.privateKeyId || this.privateKeyId != null && this.privateKeyId.equals(rhs.privateKeyId));
    }
}

