/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.credentials;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "repositoryOwner", "repositoryName", "token"})
public class GitlabCredentials {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Gitlab Credentials type")
    private GitlabType type = GitlabType.fromValue("Gitlab");
    @JsonProperty(value="repositoryOwner")
    @JsonPropertyDescription(value="The owner (user or organization) of a Git repository. For example, in https://github.com/open-metadata/OpenMetadata, the owner is `open-metadata`.")
    @NotNull
    private String repositoryOwner;
    @JsonProperty(value="repositoryName")
    @JsonPropertyDescription(value="The name of a Git repository. For example, in https://github.com/open-metadata/OpenMetadata, the name is `OpenMetadata`.")
    @NotNull
    private String repositoryName;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Token to use the API. This is required for private repositories and to ensure we don't hit API limits.")
    @PasswordField
    private String token;

    @JsonProperty(value="type")
    public GitlabType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(GitlabType type) {
        this.type = type;
    }

    public GitlabCredentials withType(GitlabType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="repositoryOwner")
    public String getRepositoryOwner() {
        return this.repositoryOwner;
    }

    @JsonProperty(value="repositoryOwner")
    public void setRepositoryOwner(String repositoryOwner) {
        this.repositoryOwner = repositoryOwner;
    }

    public GitlabCredentials withRepositoryOwner(String repositoryOwner) {
        this.repositoryOwner = repositoryOwner;
        return this;
    }

    @JsonProperty(value="repositoryName")
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @JsonProperty(value="repositoryName")
    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public GitlabCredentials withRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public GitlabCredentials withToken(String token) {
        this.token = token;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GitlabCredentials.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("repositoryOwner");
        sb.append('=');
        sb.append(this.repositoryOwner == null ? "<null>" : this.repositoryOwner);
        sb.append(',');
        sb.append("repositoryName");
        sb.append('=');
        sb.append(this.repositoryName == null ? "<null>" : this.repositoryName);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.repositoryOwner == null ? 0 : this.repositoryOwner.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.repositoryName == null ? 0 : this.repositoryName.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GitlabCredentials)) {
            return false;
        }
        GitlabCredentials rhs = (GitlabCredentials)other;
        return (this.repositoryOwner == rhs.repositoryOwner || this.repositoryOwner != null && this.repositoryOwner.equals(rhs.repositoryOwner)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.repositoryName == rhs.repositoryName || this.repositoryName != null && this.repositoryName.equals(rhs.repositoryName)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }

    public static enum GitlabType {
        GITLAB("Gitlab");

        private final String value;
        private static final Map<String, GitlabType> CONSTANTS;

        private GitlabType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GitlabType fromValue(String value) {
            GitlabType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, GitlabType>();
            for (GitlabType c : GitlabType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

