/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.secrets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import org.openmetadata.schema.security.secrets.Parameters;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"secretsManager", "prefix", "tags", "parameters"})
public class SecretsManagerConfiguration {
    @JsonProperty(value="secretsManager")
    @JsonPropertyDescription(value="OpenMetadata Secrets Manager Provider. Make sure to configure the same secrets manager providers as the ones configured on the OpenMetadata server.")
    private SecretsManagerProvider secretsManager = SecretsManagerProvider.fromValue("db");
    @JsonProperty(value="prefix")
    @JsonPropertyDescription(value="Prefix to be added to the secret key ID: `/<prefix>/<clusterName>/<key>`")
    private String prefix;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Add tags to the created resource, e.g., in AWS. Format is `[key1:value1,key2:value2,...]`")
    @Valid
    private List<String> tags = null;
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="Extra parameters used by the Secrets Manager implementation.")
    @Valid
    private Parameters parameters;

    @JsonProperty(value="secretsManager")
    public SecretsManagerProvider getSecretsManager() {
        return this.secretsManager;
    }

    @JsonProperty(value="secretsManager")
    public void setSecretsManager(SecretsManagerProvider secretsManager) {
        this.secretsManager = secretsManager;
    }

    public SecretsManagerConfiguration withSecretsManager(SecretsManagerProvider secretsManager) {
        this.secretsManager = secretsManager;
        return this;
    }

    @JsonProperty(value="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty(value="prefix")
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public SecretsManagerConfiguration withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SecretsManagerConfiguration withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="parameters")
    public Parameters getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public SecretsManagerConfiguration withParameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SecretsManagerConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("secretsManager");
        sb.append('=');
        sb.append(this.secretsManager == null ? "<null>" : this.secretsManager);
        sb.append(',');
        sb.append("prefix");
        sb.append('=');
        sb.append(this.prefix == null ? "<null>" : this.prefix);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("parameters");
        sb.append('=');
        sb.append(this.parameters == null ? "<null>" : this.parameters);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.secretsManager == null ? 0 : this.secretsManager.hashCode());
        result = result * 31 + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = result * 31 + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecretsManagerConfiguration)) {
            return false;
        }
        SecretsManagerConfiguration rhs = (SecretsManagerConfiguration)other;
        return (this.secretsManager == rhs.secretsManager || this.secretsManager != null && this.secretsManager.equals((Object)rhs.secretsManager)) && (this.parameters == rhs.parameters || this.parameters != null && this.parameters.equals(rhs.parameters)) && (this.prefix == rhs.prefix || this.prefix != null && this.prefix.equals(rhs.prefix)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }
}

