/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.secrets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SecretsManagerProvider {
    DB("db"),
    MANAGED_AWS("managed-aws"),
    AWS("aws"),
    MANAGED_AWS_SSM("managed-aws-ssm"),
    AWS_SSM("aws-ssm"),
    MANAGED_AZURE_KV("managed-azure-kv"),
    AZURE_KV("azure-kv"),
    IN_MEMORY("in-memory"),
    GCP("gcp");

    private final String value;
    private static final Map<String, SecretsManagerProvider> CONSTANTS;

    private SecretsManagerProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SecretsManagerProvider fromValue(String value) {
        SecretsManagerProvider constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SecretsManagerProvider>();
        for (SecretsManagerProvider c : SecretsManagerProvider.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

